/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricFilter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;

public interface MetricRegistry {
    public static String name(String name, String ... names) {
        ArrayList<String> ns = new ArrayList<String>();
        ns.add(name);
        ns.addAll(Arrays.asList(names));
        return ns.stream().filter(part -> part != null && !part.isEmpty()).collect(Collectors.joining("."));
    }

    public static String name(Class<?> klass, String ... names) {
        return MetricRegistry.name(klass.getCanonicalName(), names);
    }

    public <T extends Metric> T register(String var1, T var2) throws IllegalArgumentException;

    public <T extends Metric> T register(Metadata var1, T var2) throws IllegalArgumentException;

    public <T extends Metric> T register(Metadata var1, T var2, Tag ... var3) throws IllegalArgumentException;

    public Counter counter(String var1);

    public Counter counter(String var1, Tag ... var2);

    public Counter counter(MetricID var1);

    public Counter counter(Metadata var1);

    public Counter counter(Metadata var1, Tag ... var2);

    public ConcurrentGauge concurrentGauge(String var1);

    public ConcurrentGauge concurrentGauge(String var1, Tag ... var2);

    public ConcurrentGauge concurrentGauge(MetricID var1);

    public ConcurrentGauge concurrentGauge(Metadata var1);

    public ConcurrentGauge concurrentGauge(Metadata var1, Tag ... var2);

    public <T, R extends Number> Gauge<R> gauge(String var1, T var2, Function<T, R> var3, Tag ... var4);

    public <T, R extends Number> Gauge<R> gauge(MetricID var1, T var2, Function<T, R> var3);

    public <T, R extends Number> Gauge<R> gauge(Metadata var1, T var2, Function<T, R> var3, Tag ... var4);

    public <T extends Number> Gauge<T> gauge(String var1, Supplier<T> var2, Tag ... var3);

    public <T extends Number> Gauge<T> gauge(MetricID var1, Supplier<T> var2);

    public <T extends Number> Gauge<T> gauge(Metadata var1, Supplier<T> var2, Tag ... var3);

    public Histogram histogram(String var1);

    public Histogram histogram(String var1, Tag ... var2);

    public Histogram histogram(MetricID var1);

    public Histogram histogram(Metadata var1);

    public Histogram histogram(Metadata var1, Tag ... var2);

    public Meter meter(String var1);

    public Meter meter(String var1, Tag ... var2);

    public Meter meter(MetricID var1);

    public Meter meter(Metadata var1);

    public Meter meter(Metadata var1, Tag ... var2);

    public Timer timer(String var1);

    public Timer timer(String var1, Tag ... var2);

    public Timer timer(MetricID var1);

    public Timer timer(Metadata var1);

    public Timer timer(Metadata var1, Tag ... var2);

    public SimpleTimer simpleTimer(String var1);

    public SimpleTimer simpleTimer(String var1, Tag ... var2);

    public SimpleTimer simpleTimer(MetricID var1);

    public SimpleTimer simpleTimer(Metadata var1);

    public SimpleTimer simpleTimer(Metadata var1, Tag ... var2);

    public Metric getMetric(MetricID var1);

    public <T extends Metric> T getMetric(MetricID var1, Class<T> var2);

    public Counter getCounter(MetricID var1);

    public ConcurrentGauge getConcurrentGauge(MetricID var1);

    public Gauge<?> getGauge(MetricID var1);

    public Histogram getHistogram(MetricID var1);

    public Meter getMeter(MetricID var1);

    public Timer getTimer(MetricID var1);

    public SimpleTimer getSimpleTimer(MetricID var1);

    public Metadata getMetadata(String var1);

    public boolean remove(String var1);

    public boolean remove(MetricID var1);

    public void removeMatching(MetricFilter var1);

    public SortedSet<String> getNames();

    public SortedSet<MetricID> getMetricIDs();

    public SortedMap<MetricID, Gauge> getGauges();

    public SortedMap<MetricID, Gauge> getGauges(MetricFilter var1);

    public SortedMap<MetricID, Counter> getCounters();

    public SortedMap<MetricID, Counter> getCounters(MetricFilter var1);

    public SortedMap<MetricID, ConcurrentGauge> getConcurrentGauges();

    public SortedMap<MetricID, ConcurrentGauge> getConcurrentGauges(MetricFilter var1);

    public SortedMap<MetricID, Histogram> getHistograms();

    public SortedMap<MetricID, Histogram> getHistograms(MetricFilter var1);

    public SortedMap<MetricID, Meter> getMeters();

    public SortedMap<MetricID, Meter> getMeters(MetricFilter var1);

    public SortedMap<MetricID, Timer> getTimers();

    public SortedMap<MetricID, Timer> getTimers(MetricFilter var1);

    public SortedMap<MetricID, SimpleTimer> getSimpleTimers();

    public SortedMap<MetricID, SimpleTimer> getSimpleTimers(MetricFilter var1);

    public SortedMap<MetricID, Metric> getMetrics(MetricFilter var1);

    public <T extends Metric> SortedMap<MetricID, T> getMetrics(Class<T> var1, MetricFilter var2);

    public Map<MetricID, Metric> getMetrics();

    public Map<String, Metadata> getMetadata();

    public Type getType();

    public static enum Type {
        APPLICATION("application"),
        BASE("base"),
        VENDOR("vendor");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

