/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming.remote.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.NamingException;
import org.wildfly.naming.client.WildFlyInitialContextFactory;
import org.wildfly.naming.client._private.Messages;

@Deprecated
public final class InitialContextFactory
implements javax.naming.spi.InitialContextFactory {
    @Deprecated
    public static final String ENDPOINT = "jboss.naming.client.endpoint";
    @Deprecated
    public static final String CONNECTION = "jboss.naming.client.connection";
    @Deprecated
    public static final String SETUP_EJB_CONTEXT = "jboss.naming.client.ejb.context";
    @Deprecated
    public static final String CALLBACK_HANDLER_KEY = "jboss.naming.client.security.callback.handler.class";
    @Deprecated
    public static final String PASSWORD_BASE64_KEY = "jboss.naming.client.security.password.base64";
    @Deprecated
    public static final String REALM_KEY = "jboss.naming.client.security.realm";
    private static final String CLIENT_PROPS_FILE_NAME = "jboss-naming-client.properties";
    private final WildFlyInitialContextFactory delegate = new WildFlyInitialContextFactory();

    @Override
    public Context getInitialContext(Hashtable<?, ?> environment) throws NamingException {
        return this.delegate.getInitialContext(this.findClientProperties(environment));
    }

    private static ClassLoader getClientClassLoader() {
        ClassLoader tccl = InitialContextFactory.secureGetContextClassLoader();
        if (tccl != null) {
            return tccl;
        }
        return InitialContextFactory.class.getClassLoader();
    }

    private Properties findClientProperties(Hashtable<?, ?> env) throws ConfigurationException {
        Properties properties = new Properties();
        this.findAndPopulateClientProperties(properties);
        for (Map.Entry<?, ?> entry : env.entrySet()) {
            if (entry.getKey() instanceof String && entry.getValue() instanceof String) {
                properties.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof Number)) continue;
            properties.setProperty((String)entry.getKey(), String.valueOf(entry.getValue()));
        }
        return properties;
    }

    private void findAndPopulateClientProperties(Properties props) throws ConfigurationException {
        ClassLoader classLoader = InitialContextFactory.getClientClassLoader();
        Messages.log.debug("Looking for jboss-naming-client.properties using classloader " + classLoader);
        InputStream clientPropsInputStream = classLoader.getResourceAsStream(CLIENT_PROPS_FILE_NAME);
        if (clientPropsInputStream != null) {
            Messages.log.debug("Found jboss-naming-client.properties using classloader " + classLoader);
            Messages.log.oldClientPropertyFileDeprecated();
            try (InputStreamReader reader = new InputStreamReader(clientPropsInputStream, StandardCharsets.UTF_8);
                 BufferedReader bufferedReader = new BufferedReader(reader);){
                Properties clientProps = new Properties();
                clientProps.load(bufferedReader);
                props.putAll((Map<?, ?>)clientProps);
            }
            catch (IOException e) {
                ConfigurationException ce = new ConfigurationException("Could not load jboss-naming-client.properties");
                ce.initCause(e);
                throw ce;
            }
        }
    }

    private static ClassLoader secureGetContextClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        ClassLoader contextClassLoader = sm != null ? AccessController.doPrivileged(InitialContextFactory::getContextClassLoader) : InitialContextFactory.getContextClassLoader();
        return contextClassLoader == null ? InitialContextFactory.class.getClassLoader() : contextClassLoader;
    }

    private static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    static {
        Messages.log.oldContextDeprecated();
    }
}

