/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commons.marshall.InstanceReusingAdvancedExternalizer;
import org.infinispan.commons.marshall.MarshallingException;
import org.infinispan.commons.util.Util;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.JGroupsAddressCache;

@ProtoTypeId(value=10)
public class JGroupsAddress
implements Address {
    protected final org.jgroups.Address address;
    private final int hashCode;

    public JGroupsAddress(org.jgroups.Address address) {
        if (address == null) {
            throw new IllegalArgumentException("Address shall not be null");
        }
        this.address = address;
        this.hashCode = address.hashCode();
    }

    @ProtoFactory
    JGroupsAddress(byte[] bytes) throws IOException {
        try (DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));){
            this.address = org.jgroups.util.Util.readAddress((DataInput)in);
            this.hashCode = this.address.hashCode();
        }
        catch (ClassNotFoundException e) {
            throw new MarshallingException((Throwable)e);
        }
    }

    @ProtoField(value=1)
    byte[] getBytes() throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream out = new DataOutputStream(baos);){
                org.jgroups.util.Util.writeAddress((org.jgroups.Address)this.address, (DataOutput)out);
                byArray = baos.toByteArray();
            }
            return byArray;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JGroupsAddress that = (JGroupsAddress)o;
        return this.hashCode == that.hashCode && this.address.equals(that.address);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return String.valueOf(this.address);
    }

    public org.jgroups.Address getJGroupsAddress() {
        return this.address;
    }

    @Override
    public int compareTo(Address o) {
        JGroupsAddress oa = (JGroupsAddress)o;
        return this.address.compareTo((Object)oa.address);
    }

    public static final class Externalizer
    extends InstanceReusingAdvancedExternalizer<JGroupsAddress> {
        public Externalizer() {
            super(false);
        }

        public void doWriteObject(ObjectOutput output, JGroupsAddress address) throws IOException {
            try {
                org.jgroups.util.Util.writeAddress((org.jgroups.Address)address.address, (DataOutput)output);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        public JGroupsAddress doReadObject(ObjectInput unmarshaller) throws IOException, ClassNotFoundException {
            try {
                org.jgroups.Address address = org.jgroups.util.Util.readAddress((DataInput)unmarshaller);
                return (JGroupsAddress)JGroupsAddressCache.fromJGroupsAddress(address);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        public Integer getId() {
            return 20;
        }

        public Set<Class<? extends JGroupsAddress>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{JGroupsAddress.class});
        }
    }
}

