/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.irac;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.container.versioning.irac.IracTombstoneInfo;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CompletableFutures;

public class IracTombstonePrimaryCheckCommand
implements CacheRpcCommand {
    public static final byte COMMAND_ID = 47;
    private ByteString cacheName;
    private Collection<IracTombstoneInfo> tombstoneToCheck;

    public IracTombstonePrimaryCheckCommand() {
    }

    public IracTombstonePrimaryCheckCommand(ByteString cacheName) {
        this.cacheName = cacheName;
    }

    public IracTombstonePrimaryCheckCommand(ByteString cacheName, Collection<IracTombstoneInfo> tombstoneToCheck) {
        this.cacheName = cacheName;
        this.tombstoneToCheck = tombstoneToCheck;
    }

    public CompletionStage<Void> invokeAsync(ComponentRegistry registry) {
        registry.getIracTombstoneManager().running().checkStaleTombstone(this.tombstoneToCheck);
        return CompletableFutures.completedNull();
    }

    @Override
    public byte getCommandId() {
        return 47;
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallCollection(this.tombstoneToCheck, (ObjectOutput)output, IracTombstoneInfo::writeTo);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.tombstoneToCheck = MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayList::new, IracTombstoneInfo::readFrom);
    }

    @Override
    public ByteString getCacheName() {
        return this.cacheName;
    }

    @Override
    public Address getOrigin() {
        return null;
    }

    @Override
    public void setOrigin(Address origin) {
    }

    public String toString() {
        return "IracTombstonePrimaryCheckCommand{cacheName=" + this.cacheName + ", tombstoneToCheck=" + this.tombstoneToCheck + '}';
    }

    public Collection<IracTombstoneInfo> getTombstoneToCheck() {
        return this.tombstoneToCheck;
    }
}

