/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem.remote;

import java.util.function.Consumer;
import org.jboss.as.clustering.controller.transform.SimpleAttributeConverter;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanModel;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteCacheContainerResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteTransactionResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;

public class RemoteTransactionResourceTransformer
implements Consumer<ModelVersion> {
    private final ResourceTransformationDescriptionBuilder builder;

    RemoteTransactionResourceTransformer(ResourceTransformationDescriptionBuilder parent) {
        this.builder = parent.addChildResource(RemoteTransactionResourceDefinition.PATH);
    }

    @Override
    public void accept(ModelVersion version) {
        if (InfinispanModel.VERSION_15_0_0.requiresTransformation(version)) {
            SimpleAttributeConverter converter = new SimpleAttributeConverter(new SimpleAttributeConverter.Converter(){

                public void convert(PathAddress address, String name, ModelNode value, ModelNode model, TransformationContext context) {
                    ModelNode parentModel = context.readResourceFromRoot(address.getParent()).getModel();
                    if (parentModel.hasDefined(RemoteCacheContainerResourceDefinition.Attribute.TRANSACTION_TIMEOUT.getName())) {
                        value.set(parentModel.get(RemoteCacheContainerResourceDefinition.Attribute.TRANSACTION_TIMEOUT.getName()));
                    }
                }
            });
            this.builder.getAttributeBuilder().setValueConverter((AttributeConverter)converter, new AttributeDefinition[]{RemoteTransactionResourceDefinition.Attribute.TIMEOUT.getDefinition()});
        }
    }
}

