/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.infinispan.commons.util.AggregatedClassLoader;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponent;
import org.jboss.as.clustering.infinispan.subsystem.CustomStoreConfiguration;
import org.jboss.as.clustering.infinispan.subsystem.CustomStoreConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.CustomStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreServiceConfigurator;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceBuilder;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;

public class CustomStoreServiceConfigurator
extends StoreServiceConfigurator<CustomStoreConfiguration, CustomStoreConfigurationBuilder> {
    private final SupplierDependency<List<Module>> modules;
    private volatile String className;

    CustomStoreServiceConfigurator(PathAddress address) {
        super(address, CustomStoreConfigurationBuilder.class);
        this.modules = new ServiceSupplierDependency(CacheComponent.MODULES.getServiceName(address.getParent()));
    }

    @Override
    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.className = CustomStoreResourceDefinition.Attribute.CLASS.resolveModelAttribute((ExpressionResolver)context, model).asString();
        return super.configure(context, model);
    }

    @Override
    public <T> ServiceBuilder<T> register(ServiceBuilder<T> builder) {
        return super.register(this.modules.register(builder));
    }

    @Override
    public PersistenceConfiguration get() {
        PersistenceConfiguration persistence = super.get();
        StoreConfiguration store = (StoreConfiguration)persistence.stores().get(0);
        List modules = (List)this.modules.get();
        AggregatedClassLoader loader = modules.size() > 1 ? new AggregatedClassLoader((Collection)modules.stream().map(Module::getClassLoader).collect(Collectors.toList())) : ((Module)modules.get(0)).getClassLoader();
        try {
            Class<StoreConfigurationBuilder> storeClass = loader.loadClass(this.className).asSubclass(StoreConfigurationBuilder.class);
            return ((StoreConfigurationBuilder)((StoreConfigurationBuilder)((StoreConfigurationBuilder)((StoreConfigurationBuilder)((StoreConfigurationBuilder)new ConfigurationBuilder().persistence().passivation(persistence.passivation()).addStore(storeClass).async().read(store.async()).fetchPersistentState(store.fetchPersistentState())).preload(store.preload())).purgeOnStartup(store.purgeOnStartup())).shared(store.shared())).withProperties(store.properties())).persistence().create();
        }
        catch (ClassCastException | ClassNotFoundException e) {
            throw InfinispanLogger.ROOT_LOGGER.invalidCacheStore(e, this.className);
        }
    }

    @Override
    public void accept(CustomStoreConfigurationBuilder builder) {
    }
}

