/*
 * Decompiled with CFR 0.152.
 */
package net.sf.regain.crawler.preparator;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import net.sf.regain.RegainException;
import net.sf.regain.RegainToolkit;
import net.sf.regain.crawler.document.AbstractPreparator;
import net.sf.regain.crawler.document.RawDocument;
import net.sf.regain.crawler.preparator.rtf.RtfFilterReader;

public class SimpleRtfPreparator
extends AbstractPreparator {
    public SimpleRtfPreparator() throws RegainException {
        super("text/rtf");
    }

    public void prepare(RawDocument rawDocument) throws RegainException {
        InputStream stream = null;
        try {
            stream = rawDocument.getContentAsStream();
            RtfFilterReader reader = new RtfFilterReader(new InputStreamReader(stream));
            StringWriter writer = new StringWriter();
            RegainToolkit.pipe((Reader)reader, (Writer)writer);
            stream.close();
            reader.close();
            writer.close();
            String cleanedContent = writer.toString();
            this.setCleanedContent(cleanedContent);
        }
        catch (Exception exc) {
            throw new RegainException("Reading RTF dokument failed: " + rawDocument.getUrl(), (Throwable)exc);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception exc) {}
            }
        }
    }
}

