/*
 * Decompiled with CFR 0.152.
 */
package net.sf.regain.crawler.preparator;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.sf.regain.RegainException;
import net.sf.regain.RegainToolkit;
import net.sf.regain.crawler.document.AbstractPreparator;
import net.sf.regain.crawler.document.RawDocument;

public class JarPreparator
extends AbstractPreparator {
    public JarPreparator() throws RegainException {
        super(new String[]{"application/java-archive", "application/x-java-webarchive", "application/x-java-enterprisearchive"});
    }

    public void prepare(RawDocument rawDocument) throws RegainException {
        File rawFile = rawDocument.getContentAsFile(false);
        ArrayList<String> contentParts = new ArrayList<String>();
        try {
            JarFile jarFile = new JarFile(rawFile);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                String filenameWithVariants = RegainToolkit.urlToWhitespacedFileName((String)entry.getName());
                if (!filenameWithVariants.startsWith(entry.getName().substring(0, entry.getName().length() - 1))) {
                    contentParts.add(entry.getName());
                }
                contentParts.add(filenameWithVariants);
            }
            this.setCleanedContent(this.concatenateStringParts(contentParts, Integer.MAX_VALUE));
        }
        catch (Exception ex) {
            throw new RegainException("Error parsing jar/war/ear file: " + rawDocument.getUrl(), (Throwable)ex);
        }
    }
}

