/*
 * Decompiled with CFR 0.152.
 */
package net.sf.regain.crawler.preparator;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import net.sf.regain.RegainException;
import net.sf.regain.RegainToolkit;
import net.sf.regain.crawler.document.AbstractPreparator;
import net.sf.regain.crawler.document.RawDocument;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.TagException;
import org.jaudiotagger.tag.id3.ID3v1Tag;
import org.jaudiotagger.tag.id3.ID3v24Tag;

public class MP3Preparator
extends AbstractPreparator {
    public MP3Preparator() throws RegainException {
        super(new String[]{"audio/mp3", "audio/x-mp3", "audio/mpeg"});
    }

    public void prepare(RawDocument rawDocument) throws RegainException {
        File rawFile = rawDocument.getContentAsFile(false);
        try {
            this.prepareFile(rawFile, rawDocument.getUrl());
        }
        catch (ReadOnlyFileException ex) {
            try {
                File tempFile = File.createTempFile(rawFile.getName(), ".mp3");
                RegainToolkit.copyFile((File)rawFile, (File)tempFile);
                this.prepareFile(tempFile, rawDocument.getUrl());
                if (!tempFile.delete()) {
                    tempFile.deleteOnExit();
                }
            }
            catch (ReadOnlyFileException e) {
                throw new RegainException("Error handling audio file: " + rawDocument.getUrl(), (Throwable)e);
            }
            catch (IOException e) {
                throw new RegainException("Error handling audio file: " + rawDocument.getUrl(), (Throwable)e);
            }
        }
    }

    protected void prepareFile(File rawFile, String origUrl) throws ReadOnlyFileException, RegainException {
        block12: {
            try {
                MP3File mp3file = new MP3File(rawFile);
                ArrayList<String> info = new ArrayList<String>();
                if (mp3file.hasID3v2Tag()) {
                    ID3v24Tag id3v24tag = mp3file.getID3v2TagAsv24();
                    info.add(id3v24tag.getFirst("TPE1").trim());
                    info.add(id3v24tag.getFirst("TALB").trim());
                    info.add(id3v24tag.getFirst("TIT2").trim());
                    try {
                        int year = new Integer(id3v24tag.getFirst("TDRC").trim());
                        if (year > 0) {
                            info.add(id3v24tag.getFirst("TDRC").trim());
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    info.add(mp3file.getMP3AudioHeader().getTrackLengthAsString().trim());
                    info.add(mp3file.getMP3AudioHeader().getBitRate().trim() + "kbps");
                    this.setCleanedContent(this.concatenateStringParts(info, Integer.MAX_VALUE));
                    this.setTitle(this.concatenateStringParts(info, 2));
                    break block12;
                }
                if (mp3file.hasID3v1Tag()) {
                    ID3v1Tag tag = mp3file.getID3v1Tag();
                    info.add(tag.getFirst(FieldKey.ARTIST).trim());
                    info.add(tag.getFirst(FieldKey.ALBUM).trim());
                    info.add(tag.getFirst(FieldKey.TITLE).trim());
                    try {
                        int year = new Integer(tag.getFirst(FieldKey.YEAR).trim());
                        if (year > 0) {
                            info.add(tag.getFirst(FieldKey.YEAR).trim());
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    info.add(mp3file.getMP3AudioHeader().getTrackLengthAsString().trim());
                    info.add(mp3file.getMP3AudioHeader().getBitRate().trim() + "kbps");
                    this.setCleanedContent(this.concatenateStringParts(info, Integer.MAX_VALUE));
                    this.setTitle(this.concatenateStringParts(info, 2));
                    break block12;
                }
                this.setCleanedContent("");
            }
            catch (TagException ex) {
                throw new RegainException("Error handling audio file: " + origUrl, (Throwable)ex);
            }
            catch (InvalidAudioFrameException ex) {
                throw new RegainException("Error handling audio file: " + origUrl, (Throwable)ex);
            }
            catch (IOException ex) {
                throw new RegainException("Error handling audio file: " + origUrl, (Throwable)ex);
            }
        }
    }
}

