/*
 * Decompiled with CFR 0.152.
 */
package net.sf.regain.crawler.preparator;

import java.io.InputStream;
import javax.swing.text.Document;
import javax.swing.text.rtf.RTFEditorKit;
import net.sf.regain.RegainException;
import net.sf.regain.crawler.document.AbstractPreparator;
import net.sf.regain.crawler.document.RawDocument;

public class SwingRtfPreparator
extends AbstractPreparator {
    private RTFEditorKit mRTFEditorKit;

    public SwingRtfPreparator() throws RegainException {
        super("text/rtf");
    }

    public void prepare(RawDocument rawDocument) throws RegainException {
        if (this.mRTFEditorKit == null) {
            this.mRTFEditorKit = new RTFEditorKit();
        }
        InputStream stream = null;
        try {
            stream = rawDocument.getContentAsStream();
            Document doc = this.mRTFEditorKit.createDefaultDocument();
            this.mRTFEditorKit.read(stream, doc, 0);
            String cleanedContent = doc.getText(0, doc.getLength());
            this.setCleanedContent(cleanedContent);
        }
        catch (Exception exc) {
            throw new RegainException("Reading RTF dokument failed: " + rawDocument.getUrl(), (Throwable)exc);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception exc) {}
            }
        }
    }

    public void close() throws RegainException {
        this.mRTFEditorKit = null;
    }
}

