/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.slf4j.Marker;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.spi.LocationAwareLogger;

public final class JDK14LoggerAdapter
extends MarkerIgnoringBase
implements LocationAwareLogger {
    final Logger logger;
    static String SELF = JDK14LoggerAdapter.class.getName();
    static String SUPER = MarkerIgnoringBase.class.getName();

    JDK14LoggerAdapter(Logger logger) {
        this.logger = logger;
    }

    public String getName() {
        return this.logger.getName();
    }

    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    public void debug(String msg) {
        this.log(SELF, Level.FINE, msg, null);
    }

    public void debug(String format, Object arg) {
        if (this.logger.isLoggable(Level.FINE)) {
            String msgStr = MessageFormatter.format(format, arg);
            this.log(SELF, Level.FINE, msgStr, null);
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.logger.isLoggable(Level.FINE)) {
            String msgStr = MessageFormatter.format(format, arg1, arg2);
            this.log(SELF, Level.FINE, msgStr, null);
        }
    }

    public void debug(String format, Object[] argArray) {
        if (this.logger.isLoggable(Level.FINE)) {
            String msgStr = MessageFormatter.arrayFormat(format, argArray);
            this.log(SELF, Level.FINE, msgStr, null);
        }
    }

    public void debug(String msg, Throwable t) {
        this.log(SELF, Level.FINE, msg, t);
    }

    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    public void info(String msg) {
        this.log(SELF, Level.INFO, msg, null);
    }

    public void info(String format, Object arg) {
        if (this.logger.isLoggable(Level.INFO)) {
            String msgStr = MessageFormatter.format(format, arg);
            this.log(SELF, Level.INFO, msgStr, null);
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.logger.isLoggable(Level.INFO)) {
            String msgStr = MessageFormatter.format(format, arg1, arg2);
            this.log(SELF, Level.INFO, msgStr, null);
        }
    }

    public void info(String format, Object[] argArray) {
        if (this.logger.isLoggable(Level.INFO)) {
            String msgStr = MessageFormatter.arrayFormat(format, argArray);
            this.log(SELF, Level.INFO, msgStr, null);
        }
    }

    public void info(String msg, Throwable t) {
        this.log(SELF, Level.INFO, msg, t);
    }

    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    public void warn(String msg) {
        this.log(SELF, Level.WARNING, msg, null);
    }

    public void warn(String format, Object arg) {
        if (this.logger.isLoggable(Level.WARNING)) {
            String msgStr = MessageFormatter.format(format, arg);
            this.log(SELF, Level.WARNING, msgStr, null);
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (this.logger.isLoggable(Level.WARNING)) {
            String msgStr = MessageFormatter.format(format, arg1, arg2);
            this.log(SELF, Level.WARNING, msgStr, null);
        }
    }

    public void warn(String format, Object[] argArray) {
        if (this.logger.isLoggable(Level.WARNING)) {
            String msgStr = MessageFormatter.arrayFormat(format, argArray);
            this.log(SELF, Level.WARNING, msgStr, null);
        }
    }

    public void warn(String msg, Throwable t) {
        this.log(SELF, Level.WARNING, msg, t);
    }

    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    public void error(String msg) {
        this.log(SELF, Level.SEVERE, msg, null);
    }

    public void error(String format, Object arg) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            String msgStr = MessageFormatter.format(format, arg);
            this.log(SELF, Level.SEVERE, msgStr, null);
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            String msgStr = MessageFormatter.format(format, arg1, arg2);
            this.log(SELF, Level.SEVERE, msgStr, null);
        }
    }

    public void error(String format, Object[] argArray) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            String msgStr = MessageFormatter.arrayFormat(format, argArray);
            this.log(SELF, Level.SEVERE, msgStr, null);
        }
    }

    public void error(String msg, Throwable t) {
        this.log(SELF, Level.SEVERE, msg, t);
    }

    private void log(String callerFQCN, Level level, String msg, Throwable t) {
        LogRecord record = new LogRecord(level, msg);
        record.setLoggerName(this.getName());
        record.setThrown(t);
        this.fillCallerData(callerFQCN, record);
        this.logger.log(record);
    }

    private final void fillCallerData(String callerFQCN, LogRecord record) {
        StackTraceElement[] steArray = new Throwable().getStackTrace();
        int selfIndex = -1;
        for (int i = 0; i < steArray.length; ++i) {
            String className = steArray[i].getClassName();
            if (!className.equals(callerFQCN) && !className.equals(SUPER)) continue;
            selfIndex = i;
            break;
        }
        int found = -1;
        for (int i = selfIndex + 1; i < steArray.length; ++i) {
            String className = steArray[i].getClassName();
            if (className.equals(callerFQCN) || className.equals(SUPER)) continue;
            found = i;
            break;
        }
        if (found != -1) {
            StackTraceElement ste = steArray[found];
            record.setSourceClassName(ste.getClassName());
            record.setSourceMethodName(ste.getMethodName());
        }
    }

    public void log(Marker marker, String callerFQCN, int level, String message, Throwable t) {
        Level julLevel;
        switch (level) {
            case 0: {
                julLevel = Level.FINE;
                break;
            }
            case 1: {
                julLevel = Level.INFO;
                break;
            }
            case 2: {
                julLevel = Level.WARNING;
                break;
            }
            case 3: {
                julLevel = Level.SEVERE;
                break;
            }
            default: {
                throw new IllegalStateException("Level number " + level + " is not recognized.");
            }
        }
        this.log(callerFQCN, julLevel, message, t);
    }
}

