/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.websites.flickr;

import org.ontoware.rdf2go.model.node.URI;
import org.semanticdesktop.aperture.datasource.base.DataSourceBase;
import org.semanticdesktop.aperture.websites.flickr.FLICKRDS;

public class FlickrDataSource
extends DataSourceBase {
    public URI getType() {
        return FLICKRDS.FlickrDataSource;
    }

    public String getAccountToCrawl() {
        return this.getConfiguration().getString(FLICKRDS.accountToCrawl);
    }

    public void setAccountToCrawl(String accountToCrawl) {
        if (accountToCrawl == null) {
            this.getConfiguration().remove(FLICKRDS.accountToCrawl);
        } else {
            this.getConfiguration().put(FLICKRDS.accountToCrawl, accountToCrawl);
        }
    }

    public String getApikey() {
        return this.getConfiguration().getString(FLICKRDS.apikey);
    }

    public void setApikey(String apikey) {
        if (apikey == null) {
            this.getConfiguration().remove(FLICKRDS.apikey);
        } else {
            this.getConfiguration().put(FLICKRDS.apikey, apikey);
        }
    }

    public String getSharedSecret() {
        return this.getConfiguration().getString(FLICKRDS.sharedSecret);
    }

    public void setSharedSecret(String sharedSecret) {
        if (sharedSecret == null) {
            this.getConfiguration().remove(FLICKRDS.sharedSecret);
        } else {
            this.getConfiguration().put(FLICKRDS.sharedSecret, sharedSecret);
        }
    }

    public String getTargetFolder() {
        return this.getConfiguration().getString(FLICKRDS.targetFolder);
    }

    public void setTargetFolder(String targetFolder) {
        if (targetFolder == null) {
            this.getConfiguration().remove(FLICKRDS.targetFolder);
        } else {
            this.getConfiguration().put(FLICKRDS.targetFolder, targetFolder);
        }
    }

    public CrawlType getCrawlType() {
        return CrawlType.fromUri(this.getConfiguration().getURI(FLICKRDS.crawlType));
    }

    public void setCrawlType(CrawlType crawlType) {
        if (crawlType == null) {
            this.getConfiguration().remove(FLICKRDS.crawlType);
        } else {
            this.getConfiguration().put(FLICKRDS.crawlType, crawlType.toUri());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CrawlType {
        MetadataAndPicturesCrawlType,
        MetadataOnlyCrawlType;


        public static CrawlType fromUri(URI uri) {
            if (uri == null) {
                return null;
            }
            if (uri.equals(FLICKRDS.MetadataAndPicturesCrawlType)) {
                return MetadataAndPicturesCrawlType;
            }
            if (uri.equals(FLICKRDS.MetadataOnlyCrawlType)) {
                return MetadataOnlyCrawlType;
            }
            return null;
        }

        public URI toUri() {
            if (this.equals((Object)MetadataAndPicturesCrawlType)) {
                return FLICKRDS.MetadataAndPicturesCrawlType;
            }
            if (this.equals((Object)MetadataOnlyCrawlType)) {
                return FLICKRDS.MetadataOnlyCrawlType;
            }
            return null;
        }
    }
}

