/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.websites.flickr;

import com.aetrion.flickr.Flickr;
import com.aetrion.flickr.FlickrException;
import com.aetrion.flickr.RequestContext;
import com.aetrion.flickr.people.PeopleInterface;
import com.aetrion.flickr.people.User;
import com.aetrion.flickr.photos.Photo;
import com.aetrion.flickr.photos.PhotoList;
import com.aetrion.flickr.photos.PhotosInterface;
import com.aetrion.flickr.photos.Size;
import com.aetrion.flickr.tags.Tag;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.ontoware.rdf2go.vocabulary.RDFS;
import org.semanticdesktop.aperture.accessor.DataObject;
import org.semanticdesktop.aperture.accessor.base.DataObjectBase;
import org.semanticdesktop.aperture.accessor.base.FileDataObjectBase;
import org.semanticdesktop.aperture.crawler.ExitCode;
import org.semanticdesktop.aperture.crawler.base.CrawlerBase;
import org.semanticdesktop.aperture.datasource.DataSource;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.util.IOUtil;
import org.semanticdesktop.aperture.vocabulary.NAO;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.semanticdesktop.aperture.vocabulary.NIE;
import org.semanticdesktop.aperture.websites.flickr.FlickrDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlickrCrawler
extends CrawlerBase {
    private static final Logger LOG = LoggerFactory.getLogger(FlickrCrawler.class);
    private static final File localPhotoBasedirDefault = new File(new File(System.getProperty("user.home")), "flickrPhotos");
    private static final int ENTRIES_PER_PAGE = 10;

    public FlickrCrawler(DataSource ds) {
        this.setDataSource(ds);
    }

    @Override
    protected ExitCode crawlObjects() {
        FlickrDataSource localSource = (FlickrDataSource)this.getDataSource();
        String accountToCrawl = localSource.getAccountToCrawl();
        String sharedSecret = localSource.getSharedSecret();
        String apiKey = localSource.getApikey();
        try {
            int numEntries;
            File localPhotoBasedir;
            String contextUriString;
            User meUser;
            FlickrCredentials credentials = new FlickrCredentials(apiKey, sharedSecret);
            Flickr flickr = credentials.getFlickrInterface();
            PeopleInterface peopleIf = flickr.getPeopleInterface();
            String meId = null;
            if (accountToCrawl.indexOf(64) != -1 && accountToCrawl.indexOf(46) != -1) {
                meUser = peopleIf.findByEmail(accountToCrawl);
                if (meUser != null) {
                    meId = meUser.getId();
                }
            } else {
                meUser = peopleIf.findByUsername(accountToCrawl);
                if (meUser != null) {
                    meId = meUser.getId();
                }
            }
            if (meId == null) {
                throw new RuntimeException("user: " + accountToCrawl + " not found");
            }
            String photoUriPrefix = contextUriString = "http://www.flickr.com/photos/" + meId + "/";
            PhotosInterface photosIf = flickr.getPhotosInterface();
            boolean downloadImages = !FlickrDataSource.CrawlType.MetadataOnlyCrawlType.equals((Object)localSource.getCrawlType());
            try {
                localPhotoBasedir = new File(localSource.getTargetFolder());
            }
            catch (NullPointerException e) {
                localPhotoBasedir = localPhotoBasedirDefault;
                localSource.setTargetFolder(localPhotoBasedir.getPath());
            }
            if (downloadImages) {
                localPhotoBasedir.mkdirs();
            }
            boolean notAProUser = false;
            int page = 0;
            do {
                numEntries = 0;
                PhotoList pl = peopleIf.getPublicPhotos(meId, 10, page);
                Iterator it = pl.iterator();
                block12: while (it.hasNext() && !this.isStopRequested()) {
                    String format;
                    ObjectType objectType;
                    String timeMillis;
                    Date photoChangeDate;
                    ++numEntries;
                    Photo photo = (Photo)it.next();
                    photo = photosIf.getPhoto(photo.getId(), credentials.secret);
                    String id = photo.getId();
                    String photoUriString = photoUriPrefix + id + "/";
                    Date date = photoChangeDate = photo.getLastUpdate() != null ? photo.getLastUpdate() : photo.getDatePosted();
                    if (photoChangeDate == null) {
                        LOG.warn("missing change-date for photo " + photoUriString + ", using current system date");
                        photoChangeDate = new Date();
                    }
                    if (this.accessData != null) {
                        this.accessData.touch(photoUriString);
                        timeMillis = this.accessData.get(photoUriString, "date");
                    } else {
                        timeMillis = null;
                    }
                    if (timeMillis == null) {
                        objectType = ObjectType.NEW;
                    } else {
                        long t = Long.parseLong(timeMillis);
                        objectType = photoChangeDate.getTime() > t ? ObjectType.CHANGED : ObjectType.UNMODIFIED;
                    }
                    if (objectType == ObjectType.UNMODIFIED) {
                        this.reportUnmodifiedDataObject(photoUriString);
                        continue;
                    }
                    if (this.accessData != null) {
                        this.accessData.put(photoUriString, "date", Long.toString(photoChangeDate.getTime()));
                    }
                    ArrayList<DataObject> dataObjects = new ArrayList<DataObject>();
                    DataObject objPhotoIE = this.newDataObject(dataObjects, photoUriString);
                    DataObject objPhotoDOWebsite = this.newDataObject(dataObjects, photo.getUrl());
                    RDFContainer rdf = objPhotoDOWebsite.getMetadata();
                    rdf.add(RDF.type, NFO.Website);
                    rdf.add(NIE.url, photo.getUrl());
                    rdf.add(NIE.interpretedAs, objPhotoIE.getID());
                    File localCopy = null;
                    String mimeType = null;
                    String suffix = "";
                    DataObject objPhotoDO = this.newDataObject(dataObjects, photo.getUrl());
                    RDFContainer rdf2 = objPhotoDO.getMetadata();
                    rdf2.add(RDF.type, NFO.Image);
                    String photoUrl = null;
                    if (photo.getOriginalSecret().length() == 0) {
                        if (!notAProUser) {
                            LOG.warn("You are not a Flickr-PRO user. Cannot download original image. Attempting largest size possible");
                            notAProUser = true;
                        }
                        Collection sizes = photosIf.getSizes(photo.getId());
                        int largestWidth = -1;
                        for (Size size : sizes) {
                            if (size.getWidth() <= largestWidth) continue;
                            photoUrl = size.getSource();
                            largestWidth = size.getWidth();
                            suffix = "_" + size.getWidth() + "x" + size.getHeight();
                        }
                        format = "jpg";
                    } else {
                        photoUrl = photo.getOriginalUrl();
                        format = photo.getOriginalFormat();
                        suffix = "_original";
                    }
                    if (photoUrl != null) {
                        rdf2.add(NIE.url, photoUrl);
                    }
                    rdf2.add(NIE.interpretedAs, objPhotoIE.getID());
                    if (downloadImages && photoUrl != null) {
                        localCopy = new File(localPhotoBasedir, photo.getId() + suffix + "." + format);
                        if (localCopy.exists()) {
                            LOG.info("Skipping photo " + photoUrl + ". File already exists at " + localCopy);
                        } else {
                            LOG.info("Copying photo " + photoUrl + " to " + localCopy + " (format " + format + ")");
                            URLConnection conn = new URL(photoUrl).openConnection();
                            InputStream in = conn.getInputStream();
                            IOUtil.writeStream(in, localCopy);
                            mimeType = conn.getContentType();
                            in.close();
                        }
                    }
                    rdf2 = objPhotoIE.getMetadata();
                    rdf2.add(RDF.type, NIE.InformationElement);
                    this.addIfNotNull(rdf2, RDFS.label, photo.getTitle());
                    this.addIfNotNull(rdf2, NIE.title, photo.getTitle());
                    this.addIfNotNull(rdf2, NIE.contentLastModified, photo.getDateAdded());
                    this.addIfNotNull(rdf2, NIE.created, photo.getDatePosted());
                    this.addIfNotNull(rdf2, NIE.contentCreated, photo.getDateTaken());
                    this.addIfNotNull(rdf2, NIE.description, photo.getDescription());
                    rdf2.add(NIE.isStoredAs, objPhotoDOWebsite.getID());
                    if (localCopy != null) {
                        DataObject file = this.newFileDataObject(dataObjects, localCopy);
                        rdf2.add(NIE.isStoredAs, file.getID());
                    }
                    if (mimeType == null) {
                        mimeType = "image/jpeg";
                    }
                    rdf2.add(NIE.mimeType, mimeType);
                    Collection tags = photo.getTags();
                    for (Tag t : tags) {
                        String tagsPrefix = "http://www.flickr.com/photos/" + meId + "/tags/";
                        String tagValue = t.getValue();
                        if (tagValue == null) continue;
                        String tag = tagsPrefix + tagValue;
                        DataObject objTag = this.newDataObject(dataObjects, tag);
                        rdf2.add(NAO.hasTag, objTag.getID());
                        RDFContainer rdfTag = objTag.getMetadata();
                        rdfTag.add(RDF.type, NAO.Tag);
                        this.addIfNotNull(rdfTag, NAO.prefLabel, tagValue);
                    }
                    switch (objectType) {
                        case NEW: {
                            for (DataObject dobj : dataObjects) {
                                this.reportNewDataObject(dobj);
                            }
                            continue block12;
                        }
                        case CHANGED: {
                            for (DataObject dobj : dataObjects) {
                                this.reportModifiedDataObject(dobj);
                            }
                            continue block12;
                        }
                        default: {
                            LOG.info("Unsupported ObjectType, assuming NEW: " + (Object)((Object)objectType));
                            for (DataObject dobj : dataObjects) {
                                this.reportNewDataObject(dobj);
                            }
                            continue block12;
                        }
                    }
                }
                ++page;
            } while (numEntries == 10 && !this.isStopRequested());
            if (this.isStopRequested()) {
                return ExitCode.STOP_REQUESTED;
            }
            return ExitCode.COMPLETED;
        }
        catch (IOException e) {
            return this.reportFatalErrorCause("Could not crawl Flickr datasource", e);
        }
        catch (FlickrException e) {
            return this.reportFatalErrorCause("Could not crawl Flickr datasource", e);
        }
        catch (SAXException e) {
            return this.reportFatalErrorCause("Could not crawl Flickr datasource", e);
        }
        catch (RuntimeException e) {
            return this.reportFatalErrorCause("Could not crawl Flickr datasource", e);
        }
    }

    private DataObject newDataObject(Collection<DataObject> dataObjects, String uriString) {
        URIImpl turi = new URIImpl(uriString);
        RDFContainer rdf = this.getRDFContainerFactory(uriString).getRDFContainer(turi);
        DataObjectBase dObj = new DataObjectBase(turi, this.source, rdf);
        dataObjects.add(dObj);
        return dObj;
    }

    private DataObject newFileDataObject(Collection<DataObject> dataObjects, File file) {
        String fileUri = file.toURI().toString();
        if (fileUri.startsWith("file:") && !fileUri.startsWith("file://")) {
            fileUri = "file://" + fileUri.substring("file:".length());
        }
        URIImpl turi = new URIImpl(fileUri);
        RDFContainer rdf = this.getRDFContainerFactory(fileUri).getRDFContainer(turi);
        FileDataObjectBase dObj = new FileDataObjectBase((URI)turi, this.source, rdf, file);
        RDFContainer md = dObj.getMetadata();
        md.add(NIE.url, turi);
        dataObjects.add(dObj);
        return dObj;
    }

    private void addIfNotNull(RDFContainer rdf, URI property, String value) {
        if (value != null) {
            rdf.add(property, value);
        }
    }

    private void addIfNotNull(RDFContainer rdf, URI property, Date value) {
        if (value != null) {
            rdf.add(property, value);
        }
    }

    private static class FlickrCredentials {
        private String secret;
        private String frob;
        private Flickr flickr;

        public FlickrCredentials(String apiKey) throws IOException, FlickrException, SAXException {
            this(apiKey, null);
        }

        public FlickrCredentials(String apiKey, String secret) throws IOException, FlickrException, SAXException {
            this.secret = secret;
            this.flickr = new Flickr(apiKey);
            if (secret != null && secret.length() != 0) {
                RequestContext.getRequestContext().setSharedSecret(secret);
            }
        }

        public Flickr getFlickrInterface() {
            return this.flickr;
        }

        public String getFrob() {
            return this.frob;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ObjectType {
        NEW,
        UNMODIFIED,
        CHANGED;

    }
}

