/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.websites;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tag
extends AbstractMap<String, String>
implements Comparable<Tag>,
Map<String, String> {
    public static final Logger log = LoggerFactory.getLogger(Tag.class);
    private Set<Map.Entry<String, String>> mapSet = null;
    private String uri;
    private String name;
    private String description;
    private String classUri;
    private String className;

    public Tag(Map<String, String> map) {
        this.putAll(map);
    }

    public Tag(String uri, String name, String classUri) {
        this.uri = uri;
        this.name = name;
        this.classUri = classUri;
        this.description = "";
    }

    public Tag(String uri, String name, String classUri, String className) {
        this.uri = uri;
        this.name = name;
        this.classUri = classUri;
        this.className = className;
        this.description = "";
    }

    @Override
    public int hashCode() {
        if (this.uri != null) {
            return this.uri.hashCode();
        }
        return super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Tag) {
            Tag tag = (Tag)o;
            return tag.getUri().equals(this.getUri());
        }
        return false;
    }

    public String getUri() {
        return this.uri;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getClassUri() {
        return this.classUri;
    }

    public String getClassName() {
        return this.className;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[(name," + this.name + ")");
        buffer.append("(uri," + this.uri + ")");
        buffer.append("(class," + this.classUri + ")]");
        return buffer.toString();
    }

    @Override
    public int compareTo(Tag tag) {
        if (this.equals(tag)) {
            return 0;
        }
        int result = this.getName().compareTo(tag.getName());
        if (result != 0) {
            return result;
        }
        result = this.getUri().compareTo(tag.getUri());
        return result;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        if (this.mapSet == null) {
            this.mapSet = new TreeSet<Map.Entry<String, String>>();
            if (this.getUri() != null) {
                this.mapSet.add(new TagEntryEntry("uri", this.getUri()));
            }
            if (this.getName() != null) {
                this.mapSet.add(new TagEntryEntry("name", this.getName()));
            }
            if (this.getDescription() != null) {
                this.mapSet.add(new TagEntryEntry("description", this.getDescription()));
            }
            if (this.getClassUri() != null) {
                this.mapSet.add(new TagEntryEntry("classuri", this.getClassUri()));
            }
            if (this.getClassName() != null) {
                this.mapSet.add(new TagEntryEntry("classname", this.getClassName()));
            }
        }
        return this.mapSet;
    }

    @Override
    public String put(String key, String value) {
        if ("uri".equals(key)) {
            this.uri = value;
        } else if ("name".equals(key)) {
            this.name = value;
        } else if ("description".equals(key)) {
            this.description = value;
        } else if ("classuri".equals(key)) {
            this.classUri = value;
        } else if ("classname".equals(key)) {
            this.className = value;
        } else {
            log.debug("trying to read an undefined parameter '" + key + "' with value '" + value + "'. Discarding this");
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TagEntryEntry
    implements Map.Entry<String, String>,
    Comparable<TagEntryEntry> {
        private final String key;
        private final String value;

        public TagEntryEntry(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String setValue(String value) {
            throw new UnsupportedOperationException("do not implement setting values in Tag via the map interface");
        }

        @Override
        public int compareTo(TagEntryEntry o) {
            int result = this.key.compareTo(o.key);
            if (result == 0) {
                result = this.value == null ? (o.value == null ? 0 : 1) : (o.value == null ? -1 : this.value.compareTo(o.value));
            }
            return result;
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof TagEntryEntry) {
                TagEntryEntry o = (TagEntryEntry)other;
                return this.key.equals(o.key) && (this.value == o.value || this.value != null && this.value.equals(o.value));
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.key.hashCode();
        }
    }
}

