/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.util;

import java.util.Arrays;

public class UtfUtil {
    public static final byte[] UTF8_BOM = new byte[]{-17, -69, -65};
    public static final byte[] UTF16BE_BOM = new byte[]{-2, -1};
    public static final byte[] UTF16LE_BOM = new byte[]{-1, -2};
    public static final byte[] UTF32BE_BOM = new byte[]{0, 0, -2, -1};
    public static final byte[] UTF32LE_BOM = new byte[]{-1, -2, 0, 0};
    public static final int MAX_BOM_LENGTH = 4;

    public static byte[] findMatchingBOM(byte[] bytes) {
        if (UtfUtil.startsWith(bytes, UTF8_BOM)) {
            return UTF8_BOM;
        }
        if (UtfUtil.startsWith(bytes, UTF16BE_BOM)) {
            return UTF16BE_BOM;
        }
        if (UtfUtil.startsWith(bytes, UTF16LE_BOM)) {
            return UTF16LE_BOM;
        }
        if (UtfUtil.startsWith(bytes, UTF32BE_BOM)) {
            return UTF32BE_BOM;
        }
        if (UtfUtil.startsWith(bytes, UTF32LE_BOM)) {
            return UTF32LE_BOM;
        }
        return null;
    }

    private static boolean startsWith(byte[] array, byte[] startBytes) {
        if (array == null || startBytes == null || array.length < startBytes.length) {
            return false;
        }
        for (int i = 0; i < startBytes.length; ++i) {
            if (array[i] == startBytes[i]) continue;
            return false;
        }
        return true;
    }

    public static String getCharsetName(byte[] byteOrderMark) {
        if (Arrays.equals(byteOrderMark, UTF8_BOM)) {
            return "UTF-8";
        }
        if (Arrays.equals(byteOrderMark, UTF16BE_BOM)) {
            return "UTF-16BE";
        }
        if (Arrays.equals(byteOrderMark, UTF16LE_BOM)) {
            return "UTF-16LE";
        }
        if (Arrays.equals(byteOrderMark, UTF32BE_BOM)) {
            return "UTF-32BE";
        }
        if (Arrays.equals(byteOrderMark, UTF32LE_BOM)) {
            return "UTF-32LE";
        }
        return null;
    }
}

