/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.util;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class ArrayMap
implements Map {
    private Object[] keys;
    private Object[] values;
    private int size;
    private int modCount;

    public ArrayMap() {
        this(0);
    }

    public ArrayMap(int initialCapacity) {
        this.keys = new Object[initialCapacity];
        this.values = new Object[initialCapacity];
        this.size = 0;
        this.modCount = 0;
    }

    public ArrayMap(Map map) {
        this.size = map.size();
        this.keys = new Object[this.size];
        this.values = new Object[this.size];
        Iterator entries = map.entrySet().iterator();
        for (int i = 0; i < this.size; ++i) {
            Map.Entry entry = entries.next();
            this.keys[i] = entry.getKey();
            this.values[i] = entry.getValue();
        }
        this.modCount = 0;
    }

    public void clear() {
        this.keys = new Object[0];
        this.values = new Object[0];
        this.size = 0;
        ++this.modCount;
    }

    public boolean containsKey(Object key) {
        return this.indexOf(key, this.keys, this.size) != -1;
    }

    public boolean containsValue(Object value) {
        return this.indexOf(value, this.values, this.size) != -1;
    }

    public Set entrySet() {
        return new AbstractSet(){

            public Iterator iterator() {
                return new EntryIterator();
            }

            public int size() {
                return ArrayMap.this.size;
            }

            public boolean contains(Object object) {
                if (object instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)object;
                    int pos = ArrayMap.this.indexOf(entry.getKey(), ArrayMap.this.keys, ArrayMap.this.size);
                    return pos != -1 && ArrayMap.this.values[pos] == entry.getValue();
                }
                return false;
            }

            public boolean remove(Object object) {
                Map.Entry entry;
                int pos;
                if (object instanceof Map.Entry && (pos = ArrayMap.this.indexOf((entry = (Map.Entry)object).getKey(), ArrayMap.this.keys, ArrayMap.this.size)) != -1 && ArrayMap.this.values[pos] == entry.getValue()) {
                    ArrayMap.this.remove(pos);
                    return true;
                }
                return false;
            }

            public void clear() {
                ArrayMap.this.clear();
            }
        };
    }

    public boolean equals(Object object) {
        if (object instanceof Map) {
            Set otherEntries = ((Map)object).entrySet();
            return ((Object)this.entrySet()).equals(otherEntries);
        }
        return false;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('{');
        Iterator i = this.entrySet().iterator();
        boolean hasNext = i.hasNext();
        while (hasNext) {
            Entry e = (Entry)i.next();
            Object key = e.getKey();
            if (key == this) {
                buffer.append("(this Map)");
            } else {
                buffer.append(key);
            }
            buffer.append('=');
            Object value = e.getValue();
            if (value == this) {
                buffer.append("(this Map)");
            } else {
                buffer.append(value);
            }
            if (!(hasNext = i.hasNext())) continue;
            buffer.append(", ");
        }
        buffer.append('}');
        return buffer.toString();
    }

    public Object get(Object key) {
        for (int i = 0; i < this.size; ++i) {
            if (this.keys[i] != key) continue;
            return this.values[i];
        }
        return null;
    }

    public int hashCode() {
        int hashCode = 0;
        for (int i = 0; i < this.size; ++i) {
            Object key = this.keys[i];
            Object value = this.values[i];
            int keyCode = key == null ? 0 : key.hashCode();
            int valueCode = value == null ? 0 : value.hashCode();
            hashCode = (int)((double)hashCode + Math.pow(keyCode, valueCode));
        }
        return hashCode;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Set keySet() {
        return new AbstractSet(){

            public Iterator iterator() {
                return new KeyIterator();
            }

            public int size() {
                return ArrayMap.this.size;
            }

            public boolean contains(Object object) {
                return ArrayMap.this.containsKey(object);
            }

            public boolean remove(Object object) {
                int oldSize = ArrayMap.this.size;
                ArrayMap.this.remove(object);
                return ArrayMap.this.size != oldSize;
            }

            public void clear() {
                ArrayMap.this.clear();
            }
        };
    }

    public Object put(Object key, Object value) {
        Object result = null;
        int index = this.indexOf(key, this.keys, this.size);
        if (index == -1) {
            if (this.keys.length == this.size) {
                this.keys = this.toLargerArray(this.keys);
                this.values = this.toLargerArray(this.values);
            }
            this.keys[this.size] = key;
            this.values[this.size] = value;
            ++this.size;
        } else {
            result = this.values[index];
            this.values[index] = value;
        }
        ++this.modCount;
        return result;
    }

    public void putAll(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object key) {
        int index = this.indexOf(key, this.keys, this.size);
        if (index == -1) {
            return null;
        }
        Object oldValue = this.values[index];
        this.remove(index);
        return oldValue;
    }

    public int size() {
        return this.size;
    }

    public Collection values() {
        return new AbstractCollection(){

            public Iterator iterator() {
                return new ValueIterator();
            }

            public int size() {
                return ArrayMap.this.size;
            }

            public boolean contains(Object object) {
                for (int i = 0; i < ArrayMap.this.size; ++i) {
                    if (ArrayMap.this.values[i] != object) continue;
                    return true;
                }
                return false;
            }

            public boolean remove(Object object) {
                int index = ArrayMap.this.indexOf(object, ArrayMap.this.values, ArrayMap.this.size);
                if (index == -1) {
                    return false;
                }
                ArrayMap.this.remove(index);
                return true;
            }

            public void clear() {
                ArrayMap.this.clear();
            }
        };
    }

    public Object getKey(int index) {
        if (index < 0 || index >= this.size) {
            throw new IllegalArgumentException("invalid index: " + index + ", size=" + this.size);
        }
        return this.keys[index];
    }

    public Object getValue(int index) {
        if (index < 0 || index >= this.size) {
            throw new IllegalArgumentException("invalid index: " + index + ", size=" + this.size);
        }
        return this.values[index];
    }

    private Object[] toLargerArray(Object[] array) {
        int oldSize = array.length;
        Object[] result = new Object[oldSize + 1];
        System.arraycopy(array, 0, result, 0, oldSize);
        return result;
    }

    private int indexOf(Object object, Object[] array, int length) {
        for (int i = 0; i < length; ++i) {
            if (array[i] != object) continue;
            return i;
        }
        return -1;
    }

    private void remove(int index) {
        int nextIndex = index + 1;
        int remainingLength = this.size - nextIndex;
        System.arraycopy(this.keys, nextIndex, this.keys, index, remainingLength);
        System.arraycopy(this.values, nextIndex, this.values, index, remainingLength);
        --this.size;
        this.keys[this.size] = null;
        this.values[this.size] = null;
        ++this.modCount;
    }

    private class ValueIterator
    extends ArrayIterator {
        public ValueIterator() {
            super(ArrayMap.this.values, ArrayMap.this.size);
        }
    }

    private class KeyIterator
    extends ArrayIterator {
        public KeyIterator() {
            super(ArrayMap.this.keys, ArrayMap.this.size);
        }
    }

    private class ArrayIterator
    implements Iterator {
        private Object[] array;
        private int length;
        private int index;
        private int expectedModCount;

        public ArrayIterator(Object[] array, int length) {
            this.array = array;
            this.length = length;
            this.index = 0;
            this.expectedModCount = ArrayMap.this.modCount;
        }

        public boolean hasNext() {
            return this.index < this.length;
        }

        public Object next() {
            if (this.index >= this.length) {
                throw new NoSuchElementException();
            }
            if (ArrayMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Object result = this.array[this.index];
            ++this.index;
            return result;
        }

        public void remove() {
            if (this.index == 0) {
                throw new IllegalStateException();
            }
            if (ArrayMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            ArrayMap.this.remove(this.index - 1);
            --this.length;
            ++this.expectedModCount;
        }
    }

    private class EntryIterator
    implements Iterator {
        private int index = 0;
        private int expectedModCount;

        public EntryIterator() {
            this.expectedModCount = ArrayMap.this.modCount;
        }

        public boolean hasNext() {
            return this.index < ArrayMap.this.size;
        }

        public Object next() {
            if (this.index >= ArrayMap.this.size) {
                throw new NoSuchElementException();
            }
            if (ArrayMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry result = new Entry(this.index);
            ++this.index;
            return result;
        }

        public void remove() {
            if (this.index == 0) {
                throw new IllegalStateException();
            }
            if (ArrayMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            ArrayMap.this.remove(this.index - 1);
            ++this.expectedModCount;
        }
    }

    public class Entry
    implements Map.Entry {
        private int index;

        public Entry(int index) {
            this.index = index;
        }

        public Object getKey() {
            return ArrayMap.this.keys[this.index];
        }

        public Object getValue() {
            return ArrayMap.this.values[this.index];
        }

        public Object setValue(Object object) {
            Object oldValue = ArrayMap.this.values[this.index];
            ((ArrayMap)ArrayMap.this).values[this.index] = object;
            return oldValue;
        }

        public boolean equals(Object object) {
            if (object instanceof Map.Entry) {
                boolean keyOK;
                Map.Entry entry = (Map.Entry)object;
                boolean bl = ArrayMap.this.keys[this.index] == null ? entry.getKey() == null : (keyOK = ArrayMap.this.keys[this.index] == entry.getKey());
                boolean valueOK = ArrayMap.this.values[this.index] == null ? entry.getValue() == null : ArrayMap.this.values[this.index] == entry.getValue();
                return keyOK && valueOK;
            }
            return false;
        }

        public int hashCode() {
            Object key = ArrayMap.this.keys[this.index];
            Object value = ArrayMap.this.values[this.index];
            int keyCode = key == null ? 0 : key.hashCode();
            int valueCode = value == null ? 0 : value.hashCode();
            return (int)Math.pow(keyCode, valueCode);
        }
    }
}

