/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.subcrawler.vcard;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.util.CompatibilityHints;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.GroupRegistry;
import net.fortuna.ical4j.vcard.Parameter;
import net.fortuna.ical4j.vcard.ParameterFactory;
import net.fortuna.ical4j.vcard.ParameterFactoryRegistry;
import net.fortuna.ical4j.vcard.Property;
import net.fortuna.ical4j.vcard.PropertyFactory;
import net.fortuna.ical4j.vcard.PropertyFactoryRegistry;
import net.fortuna.ical4j.vcard.VCard;
import net.fortuna.ical4j.vcard.VCardBuilder;
import net.fortuna.ical4j.vcard.VCardOutputter;
import net.fortuna.ical4j.vcard.parameter.Encoding;
import net.fortuna.ical4j.vcard.parameter.Type;
import net.fortuna.ical4j.vcard.property.Address;
import net.fortuna.ical4j.vcard.property.BDay;
import net.fortuna.ical4j.vcard.property.Email;
import net.fortuna.ical4j.vcard.property.Geo;
import net.fortuna.ical4j.vcard.property.Key;
import net.fortuna.ical4j.vcard.property.Logo;
import net.fortuna.ical4j.vcard.property.N;
import net.fortuna.ical4j.vcard.property.Nickname;
import net.fortuna.ical4j.vcard.property.Org;
import net.fortuna.ical4j.vcard.property.Photo;
import net.fortuna.ical4j.vcard.property.Revision;
import net.fortuna.ical4j.vcard.property.Sound;
import net.fortuna.ical4j.vcard.property.Telephone;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.net.QuotedPrintableCodec;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.ontoware.rdf2go.vocabulary.RDFS;
import org.ontoware.rdf2go.vocabulary.XSD;
import org.semanticdesktop.aperture.accessor.AccessData;
import org.semanticdesktop.aperture.accessor.RDFContainerFactory;
import org.semanticdesktop.aperture.accessor.base.DataObjectBase;
import org.semanticdesktop.aperture.accessor.base.FileDataObjectBase;
import org.semanticdesktop.aperture.datasource.DataSource;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.rdf.util.ModelUtil;
import org.semanticdesktop.aperture.subcrawler.SubCrawlerException;
import org.semanticdesktop.aperture.subcrawler.SubCrawlerHandler;
import org.semanticdesktop.aperture.subcrawler.SubCrawlerUtil;
import org.semanticdesktop.aperture.subcrawler.base.AbstractSubCrawler;
import org.semanticdesktop.aperture.subcrawler.vcard.VcardSubCrawlerFactory;
import org.semanticdesktop.aperture.util.DateUtil;
import org.semanticdesktop.aperture.util.IOUtil;
import org.semanticdesktop.aperture.util.StringUtil;
import org.semanticdesktop.aperture.vocabulary.GEO;
import org.semanticdesktop.aperture.vocabulary.NCO;
import org.semanticdesktop.aperture.vocabulary.NEXIF;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.semanticdesktop.aperture.vocabulary.NIE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VcardSubCrawler
extends AbstractSubCrawler {
    private static final String OBJECT_HASH_KEY = "contactHash";
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void subCrawl(URI id, InputStream stream, SubCrawlerHandler handler, DataSource dataSource, AccessData accessData, Charset charset, String mimeType, RDFContainer parentMetadata) throws SubCrawlerException {
        if (handler == null) {
            throw new SubCrawlerException("The SubCrawlerHandler cannot be null");
        }
        if (parentMetadata == null) {
            throw new SubCrawlerException("The parentMetadata cannot be null");
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtil.writeStream(stream, baos);
            byte[] bytes = baos.toByteArray();
            try {
                String fulltext = new String(bytes, "UTF-8");
                parentMetadata.add(NIE.plainTextContent, fulltext);
            }
            catch (Exception e) {
                this.logger.warn("Couldn't add the fulltext of the vcard file", e);
            }
            InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(bytes));
            GroupRegistry groupRegistry = new GroupRegistry();
            PropertyFactoryRegistry propReg = new PropertyFactoryRegistry();
            ParameterFactoryRegistry parReg = new ParameterFactoryRegistry();
            this.addTypeParamsToRegistry(parReg);
            this.addCardpicturePropertyToRegistry(propReg);
            CompatibilityHints.setHintEnabled((String)"ical4j.parsing.relaxed", (boolean)true);
            CompatibilityHints.setHintEnabled((String)"ical4j.unfolding.relaxed", (boolean)true);
            CompatibilityHints.setHintEnabled((String)"ical4j.validation.relaxed", (boolean)true);
            CompatibilityHints.setHintEnabled((String)"ical4j.compatibility.outlook", (boolean)true);
            CompatibilityHints.setHintEnabled((String)"ical4j.compatibility.notes", (boolean)true);
            VCardBuilder builder = new VCardBuilder((Reader)reader, groupRegistry, propReg, parReg);
            List cards = builder.buildAll();
            VCardOutputter outputter = new VCardOutputter(false);
            if (cards.size() == 1) {
                this.processContact((VCard)cards.get(0), parentMetadata, parentMetadata.getDescribedUri(), handler, accessData, dataSource, outputter);
            } else {
                this.processAddressBook(cards, parentMetadata, handler, outputter, accessData, dataSource);
            }
        }
        catch (Exception e) {
            this.logger.warn("Error while parsing vcard: " + parentMetadata.getDescribedUri(), e);
        }
    }

    private void addTypeParamsToRegistry(ParameterFactoryRegistry parReg) {
        for (final String name : new String[]{"HOME", "WORK", "MSG", "PREF", "VOICE", "FAX", "CELL", "VIDEO", "PAGER", "BBS", "MODEM", "CAR", "ISDN", "PCS", "INTERNET", "X400", "DOM", "INTL", "POSTAL", "PARCEL"}) {
            parReg.register(name, (ParameterFactory)new ParameterFactory<Parameter>(){

                public Parameter createParameter(String value) {
                    return new Type(name);
                }
            });
            parReg.register(name.toLowerCase(), (ParameterFactory)new ParameterFactory<Parameter>(){

                public Parameter createParameter(String value) {
                    return new Type(name);
                }
            });
        }
    }

    private void addCardpicturePropertyToRegistry(PropertyFactoryRegistry propReg) {
        propReg.register("X-MS-CARDPICTURE", (PropertyFactory)new PropertyFactory<Property>(){

            public Property createProperty(Group group, List<Parameter> params, String value) throws URISyntaxException, ParseException, DecoderException {
                return new XMsCardpictureProperty(group, params, value);
            }

            public Property createProperty(List<Parameter> params, String value) throws URISyntaxException, ParseException, DecoderException {
                return new XMsCardpictureProperty(null, params, value);
            }
        });
    }

    @Override
    public void stopSubCrawler() {
    }

    @Override
    public String getUriPrefix() {
        return VcardSubCrawlerFactory.VCARD_URI_PREFIX;
    }

    private void processAddressBook(List<VCard> contacts, RDFContainer parentMetadata, SubCrawlerHandler handler, VCardOutputter out, AccessData accessData, DataSource source) {
        parentMetadata.add(RDF.type, NCO.ContactList);
        for (VCard contact : contacts) {
            try {
                String contactHash = this.getContactHash(contact, out);
                URI contactUri = this.generateURIForContact(contact, parentMetadata, contactHash);
                RDFContainerFactory factory = handler.getRDFContainerFactory(contactUri.toString());
                RDFContainer container = factory.getRDFContainer(contactUri);
                this.processContact(contact, container, contactUri, handler, accessData, source, out);
                parentMetadata.add(NCO.containsContact, contactUri);
                container.add(RDF.type, NCO.ContactListDataObject);
                container.add(NIE.isPartOf, parentMetadata.getDescribedUri());
                this.passMetadataToHandler(container, handler, contactHash, accessData, source);
            }
            catch (Exception e) {
                this.logger.warn("Failed to process vcard", e);
            }
        }
    }

    private void passMetadataToHandler(RDFContainer container, SubCrawlerHandler handler, String objectHash, AccessData accessData, DataSource source) {
        URI uri = container.getDescribedUri();
        DataObjectBase object = new DataObjectBase(uri, source, container);
        if (accessData == null) {
            handler.objectNew(object);
        } else if (!accessData.isKnownId(uri.toString())) {
            accessData.put(uri.toString(), OBJECT_HASH_KEY, objectHash);
            handler.objectNew(object);
        } else {
            String oldHash = accessData.get(uri.toString(), OBJECT_HASH_KEY);
            if (oldHash == null || !oldHash.equals(objectHash)) {
                accessData.put(uri.toString(), OBJECT_HASH_KEY, objectHash);
                handler.objectChanged(object);
            } else {
                handler.objectNotModified(uri.toString());
            }
        }
    }

    private void passAttachmentToHandler(RDFContainer container, SubCrawlerHandler handler, String attachmentHash, AccessData accessData, DataSource source, byte[] bytes) {
        URI uri = container.getDescribedUri();
        FileDataObjectBase object = new FileDataObjectBase(uri, source, container, new ByteArrayInputStream(bytes));
        if (accessData == null) {
            handler.objectNew(object);
        } else if (!accessData.isKnownId(uri.toString())) {
            accessData.put(uri.toString(), OBJECT_HASH_KEY, attachmentHash);
            handler.objectNew(object);
        } else {
            String oldHash = accessData.get(uri.toString(), OBJECT_HASH_KEY);
            if (oldHash == null || !oldHash.equals(attachmentHash)) {
                accessData.put(uri.toString(), OBJECT_HASH_KEY, attachmentHash);
                handler.objectChanged(object);
            } else {
                handler.objectNotModified(uri.toString());
            }
        }
    }

    private void processContact(VCard contact, RDFContainer container, URI contactResource, SubCrawlerHandler handler, AccessData accessData, DataSource dataSource, VCardOutputter out) {
        Model model = container.getModel();
        model.addStatement(contactResource, RDF.type, NCO.Contact);
        this.processPersonalIdentity(contact, container, contactResource, handler, accessData, dataSource);
        Resource affiliationResource = this.processOrganizationIdentity(contact, container, contactResource, handler, accessData, dataSource);
        this.processCommonProperties(contact, container, contactResource, affiliationResource, handler, accessData, dataSource);
    }

    private void processPersonalIdentity(VCard vc, RDFContainer parentMetadata, URI contactResource, SubCrawlerHandler handler, AccessData accessData, DataSource dataSource) {
        String value;
        int i;
        Photo photo;
        Model model = parentMetadata.getModel();
        this.addStringProperty(model, contactResource, NCO.fullname, this.getPropertyValue(vc, Property.Id.FN));
        N name = (N)vc.getProperty(Property.Id.N);
        if (!(name == null || this.empty(name.getAdditionalNames()) && vc.getProperty(Property.Id.BDAY) == null && name.getGivenName() == null && name.getFamilyName() == null && this.empty(name.getPrefixes()) && this.empty(name.getSuffixes()))) {
            model.addStatement(contactResource, RDF.type, NCO.PersonContact);
        }
        if (name == null) {
            return;
        }
        for (int i2 = 0; i2 < this.length(name.getAdditionalNames()); ++i2) {
            String addName = name.getAdditionalNames()[i2];
            this.addStringProperty(model, contactResource, NCO.nameAdditional, addName);
        }
        BDay bday = (BDay)vc.getProperty(Property.Id.BDAY);
        if (bday != null) {
            this.addDateTimeProperty(model, contactResource, NCO.birthDate, (Date)bday.getDate());
        }
        this.addStringProperty(model, contactResource, NCO.nameGiven, name.getGivenName());
        this.addStringProperty(model, contactResource, NCO.nameFamily, name.getFamilyName());
        Nickname nickname = (Nickname)vc.getProperty(Property.Id.NICKNAME);
        if (nickname != null) {
            for (int i3 = 0; i3 < this.length(nickname.getNames()); ++i3) {
                model.addStatement(contactResource, NCO.nickname, nickname.getNames()[i3]);
            }
        }
        if ((photo = (Photo)vc.getProperty(Property.Id.PHOTO)) != null) {
            this.processImage(photo.getBinary(), parentMetadata, contactResource, NCO.photo, this.getParameterValue((Property)photo, Parameter.Id.TYPE), photo.getUri(), handler, accessData, dataSource);
        }
        for (i = 0; i < this.length(name.getPrefixes()); ++i) {
            String prefix = name.getPrefixes()[i];
            this.addStringProperty(model, contactResource, NCO.nameHonorificPrefix, prefix);
        }
        for (i = 0; i < this.length(name.getSuffixes()); ++i) {
            String suffix = name.getSuffixes()[i];
            this.addStringProperty(model, contactResource, NCO.nameHonorificSuffix, suffix);
        }
        Property prop = vc.getExtendedProperty("X-MS-CARDPICTURE");
        if (prop != null && (value = prop.getValue()) != null) {
            try {
                byte[] binary = Base64.decodeBase64(value.getBytes("UTF-8"));
                this.processImage(binary, parentMetadata, contactResource, NCO.photo, null, null, handler, accessData, dataSource);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Resource processOrganizationIdentity(VCard organizationalIdentity, RDFContainer parentMetadata, URI contactResource, SubCrawlerHandler handler, AccessData accessData, DataSource dataSource) {
        Org org;
        Model model = parentMetadata.getModel();
        if (organizationalIdentity == null) {
            return null;
        }
        if (organizationalIdentity.getProperty(Property.Id.AGENT) == null && organizationalIdentity.getProperty(Property.Id.ORG) == null && organizationalIdentity.getProperty(Property.Id.ROLE) == null && organizationalIdentity.getProperty(Property.Id.TITLE) == null) {
            return null;
        }
        model.addStatement(contactResource, RDF.type, NCO.PersonContact);
        Resource affiliationResource = ModelUtil.generateRandomResource(model);
        model.addStatement(contactResource, NCO.hasAffiliation, affiliationResource);
        model.addStatement(affiliationResource, RDF.type, NCO.Affiliation);
        this.addStringProperty(model, affiliationResource, NCO.role, this.getPropertyValue(organizationalIdentity, Property.Id.ROLE));
        this.addStringProperty(model, affiliationResource, NCO.title, this.getPropertyValue(organizationalIdentity, Property.Id.TITLE));
        if (organizationalIdentity.getProperty(Property.Id.AGENT) == null && organizationalIdentity.getProperty(Property.Id.ORG) == null) {
            return affiliationResource;
        }
        URI organizationResource = ModelUtil.generateRandomURI(model);
        model.addStatement(organizationResource, RDF.type, NCO.OrganizationContact);
        model.addStatement(affiliationResource, NCO.org, organizationResource);
        Logo logo = (Logo)organizationalIdentity.getProperty(Property.Id.LOGO);
        if (logo != null) {
            this.processImage(logo.getBinary(), parentMetadata, organizationResource, NCO.logo, this.getParameterValue((Property)logo, Parameter.Id.TYPE), logo.getUri(), handler, accessData, dataSource);
        }
        if ((org = (Org)organizationalIdentity.getProperty(Property.Id.ORG)) != null) {
            Object[] vals = org.getValues();
            if (this.length(vals) >= 1) {
                this.addStringProperty(model, organizationResource, NCO.fullname, (String)vals[0]);
            }
            for (int i = 1; i < this.length(vals); ++i) {
                this.addStringProperty(model, affiliationResource, NCO.department, (String)vals[i]);
            }
        }
        return affiliationResource;
    }

    private void processCommonProperties(VCard contact, RDFContainer parentMetadata, URI contactResource, Resource affiliationResource, SubCrawlerHandler handler, AccessData accessData, DataSource dataSource) {
        Property sound;
        List adrs = contact.getProperties(Property.Id.ADR);
        Model model = parentMetadata.getModel();
        for (Property address : adrs) {
            String type = this.getParameterValue(address, Parameter.Id.TYPE);
            if (type != null && type.contains("pref")) {
                this.processAddress(model, (Address)address, contactResource, affiliationResource, true);
                continue;
            }
            this.processAddress(model, (Address)address, contactResource, affiliationResource, false);
        }
        this.processCommunications(model, contact, contactResource, affiliationResource);
        this.processGeographicalInformation(model, contactResource, NCO.hasLocation, contact);
        Property key = contact.getProperty(Property.Id.KEY);
        if (key != null) {
            Key keyProp = (Key)key;
            this.processPublicKey(keyProp.getBinary(), parentMetadata, contactResource, NCO.key, this.getParameterValue(key, Parameter.Id.TYPE), handler, accessData, dataSource);
        }
        if ((sound = contact.getProperty(Property.Id.SOUND)) != null) {
            Sound soundProp = (Sound)sound;
            this.processSound(soundProp.getBinary(), parentMetadata, contactResource, NCO.sound, this.getParameterValue(key, Parameter.Id.TYPE), handler, accessData, dataSource);
        }
        this.addStringProperty(model, contactResource, NCO.contactUID, this.getPropertyValue(contact, Property.Id.UID));
        this.addUriProperty(model, contactResource, NCO.url, this.getPropertyValue(contact, Property.Id.URL));
        this.addStringProperty(model, contactResource, NCO.note, this.getPropertyValue(contact, Property.Id.NOTE));
        Revision rev = (Revision)contact.getProperty(Property.Id.REV);
        if (rev != null) {
            this.addDateTimeProperty(model, contactResource, NIE.contentLastModified, (Date)rev.getDate());
        }
    }

    private void processAddress(Model model, Address address, Resource contactResource, Resource affiliationResource, boolean preferred) {
        if (address != null) {
            Resource addressResource = ModelUtil.generateRandomResource(model);
            model.addStatement(addressResource, RDF.type, NCO.PostalAddress);
            this.addStringProperty(model, addressResource, NCO.locality, address.getLocality());
            this.addStringProperty(model, addressResource, NCO.country, address.getCountry());
            this.addStringProperty(model, addressResource, NCO.postalcode, address.getPostcode());
            this.addStringProperty(model, addressResource, NCO.pobox, address.getPoBox());
            this.addStringProperty(model, addressResource, NCO.region, address.getRegion());
            this.addStringProperty(model, addressResource, NCO.streetAddress, address.getStreet());
            this.addStringProperty(model, addressResource, NCO.extendedAddress, address.getExtended());
            String type = this.getParameterValue((Property)address, Parameter.Id.TYPE);
            if (type == null) {
                return;
            }
            if ((type = type.toLowerCase()).contains("dom")) {
                model.addStatement(addressResource, RDF.type, NCO.DomesticDeliveryAddress);
                this.addContactMediumProperty(model, contactResource, NCO.hasPostalAddress, addressResource, preferred);
            }
            if (type.contains("intl")) {
                model.addStatement(addressResource, RDF.type, NCO.InternationalDeliveryAddress);
                this.addContactMediumProperty(model, contactResource, NCO.hasPostalAddress, addressResource, preferred);
            }
            if (type.contains("parcel")) {
                model.addStatement(addressResource, RDF.type, NCO.ParcelDeliveryAddress);
                this.addContactMediumProperty(model, contactResource, NCO.hasPostalAddress, addressResource, preferred);
            }
            if (type.contains("work")) {
                if (affiliationResource != null) {
                    this.addContactMediumProperty(model, affiliationResource, NCO.hasPostalAddress, addressResource, preferred);
                } else {
                    affiliationResource = ModelUtil.generateRandomResource(model);
                    model.addStatement(affiliationResource, RDF.type, NCO.Affiliation);
                    model.addStatement(contactResource, NCO.hasAffiliation, affiliationResource);
                    this.addContactMediumProperty(model, contactResource, NCO.hasPostalAddress, addressResource, preferred);
                }
            }
            if (type.contains("home")) {
                this.addContactMediumProperty(model, contactResource, NCO.hasPostalAddress, addressResource, preferred);
            }
            if (type == null || type.trim().length() == 0) {
                this.addContactMediumProperty(model, contactResource, NCO.hasPostalAddress, addressResource, preferred);
            }
        }
    }

    private void processCommunications(Model model, VCard communications, Resource contactResource, Resource affiliationResource) {
        List mails = communications.getProperties(Property.Id.EMAIL);
        for (Property address : mails) {
            String type = this.getParameterValue(address, Parameter.Id.TYPE);
            if (type != null && type.toLowerCase().contains("pref")) {
                this.processEmailAddress(model, (Email)address, contactResource, affiliationResource, true);
                continue;
            }
            this.processEmailAddress(model, (Email)address, contactResource, affiliationResource, false);
        }
        List phones = communications.getProperties(Property.Id.TEL);
        for (Property number : phones) {
            this.processPhoneNumber(model, (Telephone)number, contactResource, affiliationResource);
        }
    }

    private void processPhoneNumber(Model model, Telephone number, Resource contactResource, Resource affiliationResource) {
        Resource numberResource = ModelUtil.generateRandomResource(model);
        model.addStatement(numberResource, RDF.type, NCO.PhoneNumber);
        this.addStringProperty(model, numberResource, NCO.phoneNumber, number.getValue());
        String type = this.getParameterValue((Property)number, Parameter.Id.TYPE);
        if (type == null) {
            return;
        }
        if ((type = type.toLowerCase()).contains("bbs")) {
            model.addStatement(numberResource, RDF.type, NCO.BbsNumber);
        }
        if (type.contains("car")) {
            model.addStatement(numberResource, RDF.type, NCO.CarPhoneNumber);
        }
        if (type.contains("cell")) {
            model.addStatement(numberResource, RDF.type, NCO.CellPhoneNumber);
        }
        if (type.contains("fax")) {
            model.addStatement(numberResource, RDF.type, NCO.FaxNumber);
        }
        if (type.contains("home")) {
            this.addContactMediumProperty(model, contactResource, NCO.hasPhoneNumber, numberResource, type.contains("pref"));
        }
        if (type.contains("isdn")) {
            model.addStatement(numberResource, RDF.type, NCO.IsdnNumber);
        }
        if (type.contains("msg")) {
            model.addStatement(numberResource, RDF.type, NCO.MessagingNumber);
        }
        if (type.contains("modem")) {
            model.addStatement(numberResource, RDF.type, NCO.ModemNumber);
        }
        if (type.contains("pager")) {
            model.addStatement(numberResource, RDF.type, NCO.PagerNumber);
        }
        if (type.contains("pcs")) {
            model.addStatement(numberResource, RDF.type, NCO.PcsNumber);
        }
        if (type.contains("video")) {
            model.addStatement(numberResource, RDF.type, NCO.VideoTelephoneNumber);
        }
        if (type.contains("voice")) {
            model.addStatement(numberResource, RDF.type, NCO.VoicePhoneNumber);
        }
        if (type.contains("work")) {
            if (affiliationResource != null) {
                this.addContactMediumProperty(model, affiliationResource, NCO.hasPhoneNumber, numberResource, type.contains("pref"));
            } else {
                affiliationResource = ModelUtil.generateRandomResource(model);
                model.addStatement(affiliationResource, RDF.type, NCO.Affiliation);
                model.addStatement(contactResource, NCO.hasAffiliation, affiliationResource);
                this.addContactMediumProperty(model, contactResource, NCO.hasPhoneNumber, numberResource, type.contains("pref"));
            }
        }
        if (!type.contains("home") && !type.contains("work")) {
            this.addContactMediumProperty(model, contactResource, NCO.hasPhoneNumber, numberResource, type.contains("pref"));
        }
    }

    private void processEmailAddress(Model model, Email address, Resource contactResource, Resource affiliationResource, boolean preferred) {
        String type = this.getParameterValue((Property)address, Parameter.Id.TYPE);
        if (address != null && (type == null || type.toLowerCase().contains("internet"))) {
            Resource addressResource = ModelUtil.generateRandomResource(model);
            model.addStatement(addressResource, RDF.type, NCO.EmailAddress);
            this.addStringProperty(model, addressResource, NCO.emailAddress, address.getValue());
            this.addContactMediumProperty(model, contactResource, NCO.hasEmailAddress, addressResource, preferred);
        }
    }

    private void processGeographicalInformation(Model model, Resource contactResource, URI property, VCard vc) {
        Geo geo = (Geo)vc.getProperty(Property.Id.GEO);
        if (geo != null) {
            Resource geoResource = ModelUtil.generateRandomResource(model);
            model.addStatement(geoResource, RDF.type, GEO.Point);
            model.addStatement(geoResource, GEO.lat, geo.getLatitude().toPlainString());
            model.addStatement(geoResource, GEO.long_, geo.getLongitude().toPlainString());
            model.addStatement(contactResource, property, geoResource);
        }
    }

    private void processImage(byte[] bytes, RDFContainer parentMetadata, URI contactResource, URI property, String mimeType, java.net.URI photoUri, SubCrawlerHandler handler, AccessData accessData, DataSource source) {
        if (photoUri != null) {
            URIImpl photoRDF2GoUri = new URIImpl(photoUri.toString());
            parentMetadata.add(property, photoRDF2GoUri);
        } else {
            String attachmentHash = StringUtil.sha1Hash(bytes);
            URI attachmentUri = this.generateURIForAttachment(contactResource, attachmentHash);
            RDFContainerFactory factory = handler.getRDFContainerFactory(attachmentUri.toString());
            RDFContainer container = factory.getRDFContainer(attachmentUri);
            parentMetadata.add(property, attachmentUri);
            container.add(NIE.isPartOf, contactResource);
            container.add(RDF.type, NCO.ContactListDataObject);
            container.add(RDF.type, NEXIF.Photo);
            container.add(RDF.type, NFO.Attachment);
            this.addStringProperty(container.getModel(), container.getDescribedUri(), NIE.mimeType, mimeType);
            this.passAttachmentToHandler(container, handler, attachmentHash, accessData, source, bytes);
        }
    }

    private URI generateURIForAttachment(URI contactResource, String attachmentHash) {
        if (!SubCrawlerUtil.isSubcrawledObjectUri(contactResource)) {
            return this.createChildUri(contactResource, attachmentHash);
        }
        return new URIImpl(contactResource.toString() + "/" + attachmentHash);
    }

    private void processSound(byte[] bytes, RDFContainer parentMetadata, URI contactResource, URI property, String mimeType, SubCrawlerHandler handler, AccessData accessData, DataSource source) {
        String attachmentHash = StringUtil.sha1Hash(bytes);
        URI attachmentUri = this.generateURIForAttachment(contactResource, attachmentHash);
        RDFContainerFactory factory = handler.getRDFContainerFactory(attachmentUri.toString());
        RDFContainer container = factory.getRDFContainer(attachmentUri);
        parentMetadata.add(property, attachmentUri);
        container.add(NIE.isPartOf, contactResource);
        container.add(RDF.type, NFO.Audio);
        container.add(RDF.type, NFO.Attachment);
        this.addStringProperty(container.getModel(), container.getDescribedUri(), NIE.mimeType, mimeType);
        this.passAttachmentToHandler(container, handler, attachmentHash, accessData, source, bytes);
    }

    private void processPublicKey(byte[] bytes, RDFContainer parentMetadata, URI contactResource, URI property, String mimeType, SubCrawlerHandler handler, AccessData accessData, DataSource source) {
        String attachmentHash = StringUtil.sha1Hash(bytes);
        URI attachmentUri = this.generateURIForAttachment(contactResource, attachmentHash);
        RDFContainerFactory factory = handler.getRDFContainerFactory(attachmentUri.toString());
        RDFContainer container = factory.getRDFContainer(attachmentUri);
        parentMetadata.add(property, attachmentUri);
        container.add(RDF.type, NIE.InformationElement);
        container.add(NIE.isPartOf, contactResource);
        container.add(RDF.type, NFO.Attachment);
        this.addStringProperty(container.getModel(), container.getDescribedUri(), NIE.mimeType, mimeType);
        this.passAttachmentToHandler(container, handler, attachmentHash, accessData, source, bytes);
    }

    private void addStringProperty(Model model, Resource resource, URI property, String value) {
        if (value != null && value.trim().length() > 0) {
            model.addStatement(resource, property, value);
        }
    }

    private void addDateTimeProperty(Model model, Resource resource, URI property, Date date) {
        if (date != null) {
            String dateString = DateUtil.dateTime2String(date);
            model.addStatement(resource, property, model.createDatatypeLiteral(dateString, XSD._dateTime));
        }
    }

    private void addUriProperty(Model model, Resource contactResource, URI property, String uriString) {
        if (uriString != null) {
            if (uriString.startsWith("www.")) {
                uriString = "http://" + uriString;
            }
            URI uri = null;
            try {
                uri = model.createURI(uriString);
                model.addStatement(contactResource, property, uri);
                model.addStatement(uri, RDF.type, RDFS.Resource);
            }
            catch (Exception e) {
                this.logger.warn("Couldn't add an uri property", e);
            }
        }
    }

    private void addContactMediumProperty(Model model, Resource subject, URI property, Resource object, boolean preferred) {
        model.addStatement(subject, property, object);
        if (preferred) {
            // empty if block
        }
    }

    private URI generateURIForContact(VCard contact, RDFContainer container, String contactHash) {
        String contactIdentifier = null;
        Property uid = contact.getProperty(Property.Id.UID);
        contactIdentifier = uid != null ? uid.getValue() : contactHash;
        return this.createChildUri(container.getDescribedUri(), contactIdentifier);
    }

    private String getContactHash(VCard contact, VCardOutputter outputter) throws IOException, ValidationException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        outputter.output(contact, (OutputStream)stream);
        return StringUtil.sha1Hash(stream.toByteArray());
    }

    private String getPropertyValue(VCard vc, Property.Id fn) {
        Property p = vc.getProperty(fn);
        if (p != null) {
            try {
                return this.getDecodedPropertyalue(p);
            }
            catch (DecoderException e) {
                return p.getValue();
            }
        }
        return null;
    }

    private String getParameterValue(Property photo, Parameter.Id type) {
        Parameter param = photo.getParameter(type);
        if (param != null) {
            return param.getValue();
        }
        return null;
    }

    private boolean empty(Object[] array) {
        return array == null || array.length == 0;
    }

    private int length(Object[] arr) {
        if (arr == null) {
            return 0;
        }
        return arr.length;
    }

    private String getDecodedPropertyalue(Property prop) throws DecoderException {
        Encoding enc = (Encoding)prop.getParameter(Parameter.Id.ENCODING);
        String val = prop.getValue();
        if (enc != null && enc.getValue().equalsIgnoreCase("QUOTED-PRINTABLE")) {
            if (val.endsWith("=")) {
                val = val.substring(0, val.length() - 1);
            }
            QuotedPrintableCodec codec = new QuotedPrintableCodec();
            return codec.decode(val);
        }
        return val;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class XMsCardpictureProperty
    extends Property {
        private static final long serialVersionUID = 6075807738019876132L;
        private String value;

        public XMsCardpictureProperty(Group group, List<Parameter> params, String value) {
            super(group, "X-MS-CARDPICTURE", params);
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void validate() throws ValidationException {
        }
    }
}

