/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.subcrawler.gzip;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.ontoware.rdf2go.model.node.URI;
import org.semanticdesktop.aperture.rdf.util.ModelUtil;
import org.semanticdesktop.aperture.subcrawler.base.AbstractCompressorSubCrawler;

public class GZipSubCrawler
extends AbstractCompressorSubCrawler {
    protected InputStream getUncompressedStream(InputStream stream) throws IOException {
        return new GZIPInputStream(stream);
    }

    protected URI getContentUri(URI archiveUri) {
        String name = ModelUtil.getFileName(archiveUri);
        if (name.endsWith(".gz")) {
            return this.createChildUri(archiveUri, name.substring(0, name.length() - 3));
        }
        if (name.endsWith(".tgz")) {
            return this.createChildUri(archiveUri, name.substring(0, name.length() - 3) + "tar");
        }
        return super.getContentUri(archiveUri);
    }

    public String getUriPrefix() {
        return "gzip";
    }
}

