/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.subcrawler.base;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.accessor.AccessData;
import org.semanticdesktop.aperture.accessor.RDFContainerFactory;
import org.semanticdesktop.aperture.accessor.base.FileDataObjectBase;
import org.semanticdesktop.aperture.datasource.DataSource;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.subcrawler.SubCrawlerException;
import org.semanticdesktop.aperture.subcrawler.SubCrawlerHandler;
import org.semanticdesktop.aperture.subcrawler.base.AbstractSubCrawler;
import org.semanticdesktop.aperture.vocabulary.NFO;

public abstract class AbstractCompressorSubCrawler
extends AbstractSubCrawler {
    protected abstract InputStream getUncompressedStream(InputStream var1) throws IOException;

    public void subCrawl(URI id, InputStream stream, SubCrawlerHandler handler, DataSource dataSource, AccessData accessData, Charset charset, String mimeType, RDFContainer parentMetadata) throws SubCrawlerException {
        if (stream == null) {
            throw new SubCrawlerException("The stream cannot be null");
        }
        if (handler == null) {
            throw new SubCrawlerException("The SubCrawlerHandler cannot be null");
        }
        if (parentMetadata == null) {
            throw new SubCrawlerException("The parentMetadata cannot be null");
        }
        InputStream uncompressedStream = null;
        try {
            URI contentUri = this.getContentUri(parentMetadata.getDescribedUri());
            uncompressedStream = this.getUncompressedStream(stream);
            parentMetadata.add(RDF.type, NFO.Archive);
            boolean newEntry = true;
            if (accessData != null && accessData.isKnownId(contentUri.toString())) {
                newEntry = false;
            }
            RDFContainerFactory fac = handler.getRDFContainerFactory(contentUri.toString());
            RDFContainer container = fac.getRDFContainer(contentUri);
            container.add(RDF.type, NFO.ArchiveItem);
            container.add(NFO.fileName, this.getFileName(contentUri));
            container.add(NFO.belongsToContainer, parentMetadata.getDescribedUri());
            FileDataObjectBase object = new FileDataObjectBase(container.getDescribedUri(), dataSource, container, new BufferedInputStream(uncompressedStream));
            if (newEntry) {
                handler.objectNew(object);
            } else {
                handler.objectChanged(object);
            }
        }
        catch (Exception e) {
            throw new SubCrawlerException(e);
        }
    }

    private void closeClosable(InputStream gzipStream) {
        if (gzipStream != null) {
            try {
                gzipStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected URI getContentUri(URI archiveUri) {
        String string = archiveUri.toString();
        int hashIndex = string.indexOf("/");
        if (hashIndex != -1) {
            return this.createChildUri(archiveUri, string.substring(hashIndex) + ".content");
        }
        return this.createChildUri(archiveUri, string + ".content");
    }

    private String getFileName(URI contentUri) {
        String name = contentUri.toString();
        String fileName = null;
        int lastSlash = name.lastIndexOf(47, name.length() - 1);
        fileName = lastSlash == -1 ? name : name.substring(lastSlash + 1, name.length());
        return fileName;
    }

    public void stopSubCrawler() {
    }
}

