/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.subcrawler.base;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Date;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.accessor.AccessData;
import org.semanticdesktop.aperture.accessor.DataObject;
import org.semanticdesktop.aperture.accessor.RDFContainerFactory;
import org.semanticdesktop.aperture.accessor.base.DataObjectBase;
import org.semanticdesktop.aperture.accessor.base.FileDataObjectBase;
import org.semanticdesktop.aperture.accessor.base.FolderDataObjectBase;
import org.semanticdesktop.aperture.datasource.DataSource;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.rdf.util.ModelUtil;
import org.semanticdesktop.aperture.subcrawler.PathNotFoundException;
import org.semanticdesktop.aperture.subcrawler.SubCrawlerException;
import org.semanticdesktop.aperture.subcrawler.SubCrawlerHandler;
import org.semanticdesktop.aperture.subcrawler.SubCrawlerUtil;
import org.semanticdesktop.aperture.subcrawler.base.AbstractSubCrawler;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.semanticdesktop.aperture.vocabulary.NIE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractArchiverSubCrawler
extends AbstractSubCrawler {
    private static final String LAST_MODIFIED_DATE = "lastModified";
    private boolean stopRequested = false;
    public static final int MAX_ZIP_BOMB_REPEAT_COUNT = 10;
    private Logger logger = LoggerFactory.getLogger(AbstractArchiverSubCrawler.class);

    protected abstract ArchiveInputStream getArchiveInputStream(InputStream var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subCrawl(URI id, InputStream stream, SubCrawlerHandler handler, DataSource dataSource, AccessData accessData, Charset charset, String mimeType, RDFContainer parentMetadata) throws SubCrawlerException {
        this.stopRequested = false;
        if (stream == null) {
            throw new SubCrawlerException("The stream cannot be null");
        }
        if (handler == null) {
            throw new SubCrawlerException("The SubCrawlerHandler cannot be null");
        }
        if (parentMetadata == null) {
            throw new SubCrawlerException("The parentMetadata cannot be null");
        }
        ArchiveInputStream archiveStream = null;
        try {
            archiveStream = this.getArchiveInputStream(stream);
            ArchiveEntry archiveEntry = null;
            parentMetadata.add(RDF.type, NFO.Archive);
            while ((archiveEntry = archiveStream.getNextEntry()) != null && !this.stopRequested) {
                try {
                    if (archiveEntry.isEncrypted()) {
                        parentMetadata.add(NFO.encryptionStatus, NFO.encryptedStatus);
                        return;
                    }
                    this.processSingleEntry(archiveStream, archiveEntry, handler, dataSource, accessData, parentMetadata);
                }
                finally {
                    archiveStream.closeEntry();
                }
            }
        }
        catch (Exception e) {
            throw new SubCrawlerException(e);
        }
        finally {
            this.closeClosable(archiveStream);
        }
    }

    public DataObject getDataObject(URI parentUri, String path, InputStream stream, DataSource dataSource, Charset charset, String mimeType, RDFContainerFactory factory) throws SubCrawlerException, PathNotFoundException {
        if (stream == null) {
            throw new SubCrawlerException("The stream cannot be null");
        }
        ArchiveInputStream archiveStream = null;
        try {
            archiveStream = this.getArchiveInputStream(stream);
            ArchiveEntry archiveEntry = null;
            DataObject result = null;
            while ((archiveEntry = archiveStream.getNextEntry()) != null) {
                if (("/" + archiveEntry.getPath()).equals(path)) {
                    result = this.convertEntryToDataObject(parentUri, path, archiveStream, archiveEntry, dataSource, factory, false);
                    break;
                }
                archiveStream.closeEntry();
            }
            if (result == null) {
                this.closeClosable(archiveStream);
                throw new PathNotFoundException(this.getClass().getName(), parentUri, path);
            }
            return result;
        }
        catch (Exception e) {
            throw new SubCrawlerException(e);
        }
    }

    private void processSingleEntry(ArchiveInputStream archiveStream, ArchiveEntry archiveEntry, SubCrawlerHandler handler, DataSource dataSource, AccessData accessData, RDFContainer parentMetadata) {
        String lastModifiedDateString;
        URI uri = this.createChildUri(parentMetadata.getDescribedUri(), archiveEntry.getPath());
        if (accessData != null && accessData.isTouched(uri.toString())) {
            return;
        }
        boolean newEntry = true;
        if (accessData != null && accessData.isKnownId(uri.toString())) {
            newEntry = false;
        }
        String string = lastModifiedDateString = accessData != null ? accessData.get(uri.toString(), LAST_MODIFIED_DATE) : null;
        if (!newEntry && lastModifiedDateString != null) {
            try {
                long lastModifiedDate = Long.parseLong(lastModifiedDateString);
                long currentModifiedDate = archiveEntry.getLastModificationTime();
                if (currentModifiedDate != -1L && lastModifiedDate == currentModifiedDate) {
                    handler.objectNotModified(uri.toString());
                    return;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        RDFContainerFactory fac = handler.getRDFContainerFactory(uri.toString());
        DataObject object = this.convertEntryToDataObject(parentMetadata.getDescribedUri(), archiveEntry.getPath(), archiveStream, archiveEntry, dataSource, fac, true);
        Date lastModificationDate = object.getMetadata().getDate(NFO.fileLastModified);
        if (lastModificationDate != null && accessData != null) {
            accessData.touch(uri.toString());
            accessData.put(uri.toString(), LAST_MODIFIED_DATE, String.valueOf(lastModificationDate.getTime()));
        }
        if (newEntry) {
            handler.objectNew(object);
        } else {
            handler.objectChanged(object);
        }
    }

    private DataObject convertEntryToDataObject(URI parentUri, String path, ArchiveInputStream archiveStream, ArchiveEntry archiveEntry, DataSource dataSource, RDFContainerFactory fac, boolean unclosable) {
        URI uri = this.createChildUri(parentUri, path.startsWith("/") ? path.substring(1) : path);
        RDFContainer container = fac.getRDFContainer(uri);
        container.add(RDF.type, NFO.ArchiveItem);
        container.add(NFO.fileName, this.getFileName(archiveEntry));
        String superfolder = this.getSuperfolder(archiveEntry);
        if (superfolder != null) {
            URI superfolderUri = this.createChildUri(parentUri, superfolder);
            container.add(NFO.belongsToContainer, superfolderUri);
        } else {
            container.add(NFO.belongsToContainer, parentUri);
        }
        if (archiveEntry.getComment() != null) {
            container.add(NIE.comment, archiveEntry.getComment());
        }
        if (archiveEntry.getCompressedSize() != -1L) {
            container.add(NFO.fileSize, archiveEntry.getCompressedSize());
        }
        if (archiveEntry.getCrc() != -1L) {
            Model model = container.getModel();
            Resource hashResource = ModelUtil.generateRandomResource(model);
            model.addStatement(hashResource, RDF.type, NFO.FileHash);
            model.addStatement(hashResource, NFO.hashAlgorithm, "CRC-32");
            model.addStatement(hashResource, NFO.hashValue, String.valueOf(archiveEntry.getCrc()));
            model.addStatement(container.getDescribedUri(), NFO.hasHash, hashResource);
        }
        if (archiveEntry.getLastModificationTime() != -1L) {
            container.add(NFO.fileLastModified, new Date(archiveEntry.getLastModificationTime()));
        }
        DataObjectBase object = null;
        if (archiveEntry.isDirectory()) {
            container.add(RDF.type, NFO.Folder);
            object = new FolderDataObjectBase(container.getDescribedUri(), dataSource, container);
        } else if (this.isZipBomb(parentUri, archiveEntry)) {
            this.logger.warn("Possible zip-bomb detected. Not crawling deeper. " + parentUri.toString());
            object = new DataObjectBase(container.getDescribedUri(), dataSource, container);
        } else {
            object = unclosable ? new FileDataObjectBase(container.getDescribedUri(), dataSource, container, new UnclosableStream(archiveStream)) : new FileDataObjectBase(container.getDescribedUri(), dataSource, container, archiveStream.markSupported() ? archiveStream : new BufferedInputStream(archiveStream));
        }
        return object;
    }

    private boolean isZipBomb(URI parentUri, ArchiveEntry archiveEntry) {
        String parentPath;
        int levels;
        String parentFileName;
        String entryName = this.getFileName(archiveEntry.getPath());
        if (!entryName.equals(parentFileName = this.getFileName(parentUri.toString()))) {
            return false;
        }
        URI currentParentUri = parentUri;
        for (levels = 1; levels < 10 && (parentPath = SubCrawlerUtil.getSubCrawledObjectPath(currentParentUri = SubCrawlerUtil.getParentObjectUri(currentParentUri))) != null && parentPath.length() > 1 && parentPath.substring(1).equals(archiveEntry.getPath()); ++levels) {
        }
        return levels >= 10;
    }

    private String getFileName(String st) {
        int index = st.lastIndexOf("/");
        if (index == -1 || index == st.length() - 1) {
            return st;
        }
        return st.substring(index + 1);
    }

    private void closeClosable(ArchiveInputStream zipStream) {
        if (zipStream != null) {
            try {
                zipStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String getFileName(ArchiveEntry entry) {
        int lastSlash;
        String path = entry.getPath();
        String fileName = null;
        fileName = path.equals("/") ? path : (path.endsWith("/") ? ((lastSlash = path.lastIndexOf(47, path.length() - 2)) == -1 ? path.substring(0, path.length() - 1) : path.substring(lastSlash + 1, path.length() - 1)) : ((lastSlash = path.lastIndexOf(47, path.length() - 1)) == -1 ? path : path.substring(lastSlash + 1, path.length())));
        return fileName;
    }

    private String getSuperfolder(ArchiveEntry entry) {
        int lastSlash;
        String path = entry.getPath();
        String superfolderName = null;
        superfolderName = path.equals("/") ? null : (path.endsWith("/") ? ((lastSlash = path.lastIndexOf(47, path.length() - 2)) == -1 ? null : path.substring(0, lastSlash + 1)) : ((lastSlash = path.lastIndexOf(47, path.length() - 1)) == -1 ? null : path.substring(0, lastSlash + 1)));
        return superfolderName;
    }

    public void stopSubCrawler() {
        this.stopRequested = true;
    }

    private static class UnclosableStream
    extends FilterInputStream {
        protected UnclosableStream(InputStream in) {
            super(in.markSupported() ? in : new BufferedInputStream(in));
        }

        public void close() {
        }
    }

    protected static abstract class ArchiveEntry {
        protected ArchiveEntry() {
        }

        public String getComment() {
            return null;
        }

        public long getCompressedSize() {
            return -1L;
        }

        public long getCrc() {
            return -1L;
        }

        public long getLastModificationTime() {
            return -1L;
        }

        public String getPath() {
            return null;
        }

        public boolean isDirectory() {
            return false;
        }

        public boolean isEncrypted() {
            return false;
        }
    }

    protected static abstract class ArchiveInputStream
    extends FilterInputStream {
        public ArchiveInputStream(InputStream in) {
            super(in);
        }

        public abstract ArchiveEntry getNextEntry() throws IOException;

        public abstract void closeEntry() throws IOException;
    }
}

