/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.security.trustmanager.standard;

import java.io.File;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.semanticdesktop.aperture.security.trustdecider.Decision;
import org.semanticdesktop.aperture.security.trustdecider.TrustDecider;
import org.semanticdesktop.aperture.security.trustmanager.standard.CertificateStore;
import org.semanticdesktop.aperture.security.trustmanager.standard.PersistentCertificateStore;
import org.semanticdesktop.aperture.security.trustmanager.standard.RootCertificateStore;
import org.semanticdesktop.aperture.security.trustmanager.standard.SessionCertificateStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardTrustManager
implements X509TrustManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String ROOT_CERTIFICATES_FILE_NAME;
    private static final String JSSE_ROOT_CERTIFICATES_FILE_NAME;
    private CertificateStore sessionCertificateStore = new SessionCertificateStore();
    private CertificateStore deniedCertificateStore = new SessionCertificateStore();
    private CertificateStore rootCertificateStore = new RootCertificateStore(ROOT_CERTIFICATES_FILE_NAME);
    private CertificateStore jsseRootCertificateStore = new RootCertificateStore(JSSE_ROOT_CERTIFICATES_FILE_NAME);
    private CertificateStore persistentCertificateStore;
    private X509TrustManager defaultTrustManager;
    private TrustDecider trustDecider;

    public StandardTrustManager() throws CertificateException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, IOException {
        this(null, null);
    }

    public StandardTrustManager(File pcsFile, char[] pcsPassword) throws CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException, NoSuchProviderException {
        this.persistentCertificateStore = pcsFile == null ? new SessionCertificateStore() : new PersistentCertificateStore(pcsFile, pcsPassword);
        this.sessionCertificateStore.load();
        this.deniedCertificateStore.load();
        this.rootCertificateStore.load();
        this.jsseRootCertificateStore.load();
        this.persistentCertificateStore.load();
        TrustManagerFactory factory = TrustManagerFactory.getInstance("SunX509", "SunJSSE");
        factory.init((KeyStore)null);
        TrustManager[] managers = factory.getTrustManagers();
        this.defaultTrustManager = (X509TrustManager)managers[0];
    }

    public void setTrustDecider(TrustDecider trustDecider) {
        this.trustDecider = trustDecider;
    }

    public TrustDecider getTrustDecider() {
        return this.trustDecider;
    }

    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkChain(chain, authType, true);
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkChain(chain, authType, false);
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.defaultTrustManager.getAcceptedIssuers();
    }

    private synchronized void checkChain(X509Certificate[] chain, String authType, boolean checkClient) throws CertificateException {
        boolean rootCANotValid = false;
        boolean timeNotValid = false;
        Decision decision = null;
        try {
            if (this.deniedCertificateStore.contains(chain[0])) {
                throw new CertificateException("certificate has been denied");
            }
            try {
                if (checkClient) {
                    this.defaultTrustManager.checkClientTrusted(chain, authType);
                } else {
                    this.defaultTrustManager.checkServerTrusted(chain, authType);
                }
                return;
            }
            catch (CertificateException e) {
                X509Certificate cert;
                if (this.sessionCertificateStore.contains(chain[0])) {
                    return;
                }
                if (this.persistentCertificateStore.contains(chain[0])) {
                    return;
                }
                for (int i = 0; i < chain.length; ++i) {
                    cert = chain[i];
                    if (!this.jsseRootCertificateStore.verify(cert) && !this.rootCertificateStore.verify(cert)) {
                        rootCANotValid = true;
                    }
                    try {
                        cert.checkValidity();
                        continue;
                    }
                    catch (CertificateExpiredException e2) {
                        timeNotValid = true;
                        continue;
                    }
                    catch (CertificateNotYetValidException e3) {
                        timeNotValid = true;
                    }
                }
                TrustDecider trustDecider = this.getTrustDecider();
                if (trustDecider == null) {
                    throw new CertificateException("trust could not be established");
                }
                decision = trustDecider.decide(chain, rootCANotValid, timeNotValid);
                cert = chain[0];
                if (Decision.TRUST_THIS_SESSION.equals(decision)) {
                    this.sessionCertificateStore.add(cert);
                    this.sessionCertificateStore.save();
                } else if (Decision.TRUST_ALWAYS.equals(decision)) {
                    this.persistentCertificateStore.add(cert);
                    this.persistentCertificateStore.save();
                } else {
                    this.deniedCertificateStore.add(cert);
                    this.deniedCertificateStore.save();
                }
            }
        }
        catch (CertificateException e) {
            throw e;
        }
        catch (Throwable e) {
            this.logger.error("Unexpected throwable while verifying certificate", e);
        }
        if (!Decision.TRUST_THIS_SESSION.equals(decision) && !Decision.TRUST_ALWAYS.equals(decision)) {
            throw new CertificateException("trust manager could not trust certificate chain");
        }
    }

    static {
        String securityPath = System.getProperty("java.home") + File.separator + "lib" + File.separator + "security" + File.separator;
        ROOT_CERTIFICATES_FILE_NAME = securityPath + "cacerts";
        JSSE_ROOT_CERTIFICATES_FILE_NAME = securityPath + "jssecacerts";
    }
}

