/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.security.trustmanager.standard;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import org.semanticdesktop.aperture.security.trustmanager.standard.CertificateStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentCertificateStore
implements CertificateStore {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private File certificatesFile;
    private KeyStore keyStore;
    private char[] password;

    public PersistentCertificateStore(File certificatesFile, char[] password) {
        this.certificatesFile = certificatesFile;
        this.password = password;
    }

    public void setPassword(char[] password) {
        this.password = password;
    }

    public char[] getPassword() {
        return this.password;
    }

    public void load() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
                    if (PersistentCertificateStore.this.keyStore == null) {
                        PersistentCertificateStore.this.keyStore = KeyStore.getInstance("JKS");
                        PersistentCertificateStore.this.keyStore.load(null, null);
                    }
                    if (PersistentCertificateStore.this.certificatesFile.exists()) {
                        FileInputStream stream = new FileInputStream(PersistentCertificateStore.this.certificatesFile);
                        BufferedInputStream buffer = new BufferedInputStream(stream);
                        PersistentCertificateStore.this.keyStore.load(buffer, PersistentCertificateStore.this.password);
                        buffer.close();
                        stream.close();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception ex = e.getException();
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            if (ex instanceof CertificateException) {
                throw (CertificateException)ex;
            }
            if (ex instanceof KeyStoreException) {
                throw (KeyStoreException)ex;
            }
            if (ex instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)ex;
            }
            this.logger.error("Unrecognized nested exception, ignoring", e);
        }
    }

    public void save() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
                    FileOutputStream stream = new FileOutputStream(PersistentCertificateStore.this.certificatesFile);
                    BufferedOutputStream buffer = new BufferedOutputStream(stream);
                    PersistentCertificateStore.this.keyStore.store(buffer, PersistentCertificateStore.this.password);
                    buffer.close();
                    stream.close();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception ex = e.getException();
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            if (ex instanceof CertificateException) {
                throw (CertificateException)ex;
            }
            if (ex instanceof KeyStoreException) {
                throw (KeyStoreException)ex;
            }
            if (ex instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)ex;
            }
            this.logger.error("Unrecognized nested exception, ignoring", e);
        }
    }

    public void add(Certificate certificate) throws KeyStoreException {
        if (!this.contains(certificate)) {
            Random rand = new Random();
            String alias = null;
            while (this.keyStore.getCertificate(alias = "pcscert" + rand.nextLong()) != null) {
            }
            this.keyStore.setCertificateEntry(alias, certificate);
        }
    }

    public void remove(Certificate certificate) throws KeyStoreException {
        String alias = this.keyStore.getCertificateAlias(certificate);
        if (alias != null) {
            this.keyStore.deleteEntry(alias);
        }
    }

    public boolean contains(Certificate certificate) throws KeyStoreException {
        String alias = this.keyStore.getCertificateAlias(certificate);
        return alias != null;
    }

    public boolean verify(Certificate certificate) throws KeyStoreException {
        return false;
    }

    public Iterator iterator() throws KeyStoreException {
        HashSet<Certificate> set = new HashSet<Certificate>();
        Enumeration<String> aliases = this.keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            set.add(this.keyStore.getCertificate(alias));
        }
        return set.iterator();
    }
}

