/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.security.trustdecider.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;

public class CertificateDialog {
    private JTable table;
    private JTextArea textArea;
    private Object[] msg;
    private Object[] options;

    public CertificateDialog(Certificate[] chain) {
        if (chain.length > 0 && chain[0] instanceof X509Certificate) {
            DefaultMutableTreeNode root = null;
            DefaultMutableTreeNode currentNode = null;
            for (int i = 0; i < chain.length; ++i) {
                DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(new CertificateInfo((X509Certificate)chain[i]));
                if (root == null) {
                    root = childNode;
                    currentNode = childNode;
                    continue;
                }
                currentNode.add(childNode);
                currentNode = childNode;
            }
            final JTree tree = new JTree(root);
            tree.getSelectionModel().setSelectionMode(1);
            tree.putClientProperty("JTree.lineStyle", "Angled");
            tree.addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent e) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
                    if (node != null) {
                        CertificateInfo certInfo = (CertificateInfo)node.getUserObject();
                        CertificateDialog.this.showCertificate(certInfo.getCertificate());
                    }
                }
            });
            JScrollPane treePane = new JScrollPane(tree);
            treePane.setPreferredSize(new Dimension(200, 100));
            JLabel label = new JLabel("Certificate chain:");
            label.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            JPanel treePanel = new JPanel();
            treePanel.setLayout(new BorderLayout());
            treePanel.add((Component)treePane, "Center");
            treePanel.add((Component)label, "North");
            this.table = new JTable();
            this.table.setSelectionMode(0);
            this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    int row = CertificateDialog.this.table.getSelectedRow();
                    if (row >= 0) {
                        String value = (String)CertificateDialog.this.table.getValueAt(row, 1);
                        CertificateDialog.this.textArea.setText(value);
                    }
                }
            });
            Dimension dim = this.table.getPreferredScrollableViewportSize();
            dim.setSize(dim.getWidth(), 120.0);
            this.table.setPreferredScrollableViewportSize(dim);
            JScrollPane tablePane = new JScrollPane(this.table);
            tablePane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0), tablePane.getBorder()));
            this.textArea = new JTextArea();
            this.textArea.setLineWrap(false);
            this.textArea.setEditable(false);
            this.textArea.setColumns(40);
            this.textArea.setFont(new Font("monospaced", 0, 12));
            JScrollPane textAreaPane = new JScrollPane(this.textArea);
            JLabel contentsLabel = new JLabel("Selected certificate contents:");
            contentsLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            JPanel infoPanel = new JPanel();
            infoPanel.setLayout(new BorderLayout());
            infoPanel.add((Component)tablePane, "Center");
            infoPanel.add((Component)textAreaPane, "South");
            infoPanel.add((Component)contentsLabel, "North");
            JPanel totalPanel = new JPanel();
            totalPanel.setLayout(new BorderLayout());
            totalPanel.add((Component)treePanel, "West");
            totalPanel.add(Box.createHorizontalStrut(25), "Center");
            totalPanel.add((Component)infoPanel, "East");
            this.msg = new Object[]{totalPanel};
            final JButton closeButton = new JButton("Close");
            closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Component c = (Component)e.getSource();
                    while (c != null) {
                        if (!((c = c.getParent()) instanceof JOptionPane)) continue;
                        ((JOptionPane)c).setValue(closeButton);
                        break;
                    }
                }
            });
            this.options = new Object[]{closeButton};
            this.showCertificate((X509Certificate)chain[0]);
        }
    }

    public void show(Component parent) {
        JOptionPane.showOptionDialog(parent, this.msg, "Certificate Info", -1, -1, null, this.options, this.options[0]);
    }

    private String formatDNString(String dnString) {
        int length = dnString.length();
        boolean inQuote = false;
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char c = dnString.charAt(i);
            if (c == '\"' || c == '\'') {
                boolean bl = inQuote = !inQuote;
            }
            if (c == ',' && !inQuote) {
                buffer.append(",\n");
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    private void showCertificate(X509Certificate cert) {
        String version = "V" + cert.getVersion();
        String serialNumber = "[" + cert.getSerialNumber() + "]";
        String sigAlg = "[" + cert.getSigAlgName() + "]";
        String issuer = this.formatDNString(((Object)cert.getIssuerDN()).toString());
        String validity = "[From: " + cert.getNotBefore() + ",\n To: " + cert.getNotAfter() + "]";
        String subject = this.formatDNString(((Object)cert.getSubjectDN()).toString());
        HexDumpEncoder encoder = new HexDumpEncoder();
        String sig = encoder.encodeBuffer(cert.getSignature());
        Object[][] data = new String[][]{{"Version", version}, {"Serial Number", serialNumber}, {"Signature Algorithm", sigAlg}, {"Issuer", issuer}, {"Validity", validity}, {"Subject", subject}, {"Signature", sig}};
        Object[] columnNames = new String[]{"Field", "Value"};
        this.table.setModel(new DefaultTableModel(data, columnNames){

            public boolean isCellEditable(int row, int col) {
                return false;
            }
        });
        this.table.setRowSelectionInterval(6, 6);
    }

    private static class CertificateInfo {
        private X509Certificate cert;

        CertificateInfo(X509Certificate cert) {
            this.cert = cert;
        }

        public X509Certificate getCertificate() {
            return this.cert;
        }

        private String extractAliasName(X509Certificate cert) {
            String subjectName = "Unknown subject";
            String issuerName = "Unknown issuer";
            try {
                Principal principal = cert.getSubjectDN();
                Principal principalIssuer = cert.getIssuerDN();
                String subjectDNName = principal.getName();
                String issuerDNName = principalIssuer.getName();
                subjectName = this.extractFromQuote(subjectDNName, "CN=");
                if (subjectName == null) {
                    subjectName = this.extractFromQuote(subjectDNName, "O=");
                }
                if (subjectName == null) {
                    subjectName = "Unknown subject";
                }
                if ((issuerName = this.extractFromQuote(issuerDNName, "CN=")) == null) {
                    issuerName = this.extractFromQuote(issuerDNName, "O=");
                }
                if (issuerName == null) {
                    issuerName = "Unknown issuer";
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return subjectName + " (" + issuerName + ")";
        }

        private String extractFromQuote(String s, String prefix) {
            if (s == null) {
                return null;
            }
            int x = s.indexOf(prefix);
            int y = 0;
            if (x >= 0) {
                if ((y = s.charAt(x += prefix.length()) == '\"' ? s.indexOf(34, ++x) : s.indexOf(44, x)) < 0) {
                    return s.substring(x);
                }
                return s.substring(x, y);
            }
            return null;
        }

        public String toString() {
            return this.extractAliasName(this.cert);
        }
    }

    private static class HexDumpEncoder {
        private static final int BYTES_PER_LINE = 16;
        private static final int BYTES_PER_ATOM = 1;
        private int offset;
        private int thisLineLength;
        private int currentByte;
        private byte[] thisLine = new byte[16];
        private PrintStream pStream;

        private HexDumpEncoder() {
        }

        public String encodeBuffer(byte[] aBuffer) {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            ByteArrayInputStream inStream = new ByteArrayInputStream(aBuffer);
            try {
                this.encodeBuffer(inStream, outStream);
            }
            catch (Exception IOException2) {
                throw new Error("encodeBuffer internal error");
            }
            return outStream.toString();
        }

        private void encodeBuffer(InputStream inStream, OutputStream outStream) throws IOException {
            int numBytes;
            byte[] tmpbuffer = new byte[16];
            this.encodeBufferPrefix(outStream);
            while ((numBytes = this.readFully(inStream, tmpbuffer)) != 0) {
                this.encodeLinePrefix(outStream, numBytes);
                for (int j = 0; j < numBytes; ++j) {
                    if (j + 1 <= numBytes) {
                        this.encodeAtom(outStream, tmpbuffer, j, 1);
                        continue;
                    }
                    this.encodeAtom(outStream, tmpbuffer, j, numBytes - j);
                }
                this.encodeLineSuffix(outStream);
                if (numBytes >= 16) continue;
                break;
            }
        }

        private void encodeBufferPrefix(OutputStream o) throws IOException {
            this.offset = 0;
            this.pStream = new PrintStream(o);
        }

        private int readFully(InputStream in, byte[] buffer) throws IOException {
            for (int i = 0; i < buffer.length; ++i) {
                int q = in.read();
                if (q == -1) {
                    return i;
                }
                buffer[i] = (byte)q;
            }
            return buffer.length;
        }

        private void encodeLinePrefix(OutputStream o, int len) throws IOException {
            this.hexDigit((byte)(this.offset >>> 8 & 0xFF));
            this.hexDigit((byte)(this.offset & 0xFF));
            this.pStream.print(": ");
            this.currentByte = 0;
            this.thisLineLength = len;
        }

        private void hexDigit(byte x) {
            char c = (char)(x >> 4 & 0xF);
            c = c > '\t' ? (char)(c - 10 + 65) : (char)(c + 48);
            this.pStream.write(c);
            c = (char)(x & 0xF);
            c = c > '\t' ? (char)(c - 10 + 65) : (char)(c + 48);
            this.pStream.write(c);
        }

        private void encodeAtom(OutputStream o, byte[] buf, int off, int len) throws IOException {
            this.thisLine[this.currentByte] = buf[off];
            this.hexDigit(buf[off]);
            this.pStream.print(" ");
            ++this.currentByte;
            if (this.currentByte == 8) {
                this.pStream.print("  ");
            }
        }

        private void encodeLineSuffix(OutputStream o) throws IOException {
            int i;
            if (this.thisLineLength < 16) {
                for (i = this.thisLineLength; i < 16; ++i) {
                    this.pStream.print("   ");
                    if (i != 7) continue;
                    this.pStream.print("  ");
                }
            }
            this.pStream.print(" ");
            for (i = 0; i < this.thisLineLength; ++i) {
                if (this.thisLine[i] < 32 || this.thisLine[i] > 122) {
                    this.pStream.print(".");
                    continue;
                }
                this.pStream.write(this.thisLine[i]);
            }
            this.pStream.println();
            this.offset += this.thisLineLength;
        }
    }
}

