/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.rdf.util;

import info.aduna.xml.XMLUtil;
import java.io.CharArrayWriter;
import java.io.Reader;
import java.io.Writer;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.Statement;
import org.ontoware.rdf2go.model.node.DatatypeLiteral;
import org.ontoware.rdf2go.model.node.LanguageTagLiteral;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.PlainLiteral;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.rdf.RDFContainerFactory;
import org.semanticdesktop.aperture.rdf.impl.RDFContainerImpl;
import org.semanticdesktop.aperture.rdf.util.XmlSafeModel;
import org.semanticdesktop.aperture.rdf.util.XmlSafeRDFContainer;
import org.semanticdesktop.aperture.rdf.util.XmlSafeRDFContainerFactory;
import org.semanticdesktop.aperture.rdf.util.XmlSafeReader;
import org.semanticdesktop.aperture.rdf.util.XmlSafeWriter;

public class XmlSafetyUtils {
    public static String makeXmlSafe(String s) {
        boolean hasInvalidChars = false;
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            if (XMLUtil.isValidCharacterDataChar((char)s.charAt(i))) continue;
            hasInvalidChars = true;
            break;
        }
        if (hasInvalidChars) {
            StringBuilder buffer = new StringBuilder(length);
            for (int i = 0; i < length; ++i) {
                char c = s.charAt(i);
                if (XMLUtil.isValidCharacterDataChar((char)c)) {
                    buffer.append(c);
                    continue;
                }
                buffer.append(' ');
            }
            return buffer.toString();
        }
        return s;
    }

    public static String makeXmlSafe(String in, int off, int len) {
        if (off == 0 && len == in.length()) {
            return XmlSafetyUtils.makeXmlSafe(in);
        }
        StringBuilder buffer = new StringBuilder(len);
        for (int i = off; i <= len + 1; ++i) {
            char c = in.charAt(i);
            if (XMLUtil.isValidCharacterDataChar((char)c)) {
                buffer.append(c);
                continue;
            }
            buffer.append(' ');
        }
        return buffer.toString();
    }

    public static char[] makeXmlSafe(char[] s) {
        return XmlSafetyUtils.makeXmlSafe(s, 0, s.length);
    }

    public static char[] makeXmlSafe(char[] s, int off, int len) {
        boolean hasInvalidChars = false;
        for (int i = off; i < len; ++i) {
            if (XMLUtil.isValidCharacterDataChar((char)s[i])) continue;
            hasInvalidChars = true;
            break;
        }
        if (hasInvalidChars) {
            CharArrayWriter buffer = new CharArrayWriter();
            for (int i = off; i < len; ++i) {
                char c = s[i];
                if (XMLUtil.isValidCharacterDataChar((char)c)) {
                    buffer.append(c);
                    continue;
                }
                buffer.append(' ');
            }
            return buffer.toCharArray();
        }
        return s;
    }

    public static Node makeXmlSafe(Model model, Node node) {
        if (node instanceof DatatypeLiteral) {
            String newValue;
            DatatypeLiteral dLit = (DatatypeLiteral)node;
            String oldValue = dLit.getValue();
            if (oldValue == (newValue = XmlSafetyUtils.makeXmlSafe(oldValue))) {
                return node;
            }
            return model.createDatatypeLiteral(newValue, dLit.getDatatype());
        }
        if (node instanceof LanguageTagLiteral) {
            String newValue;
            LanguageTagLiteral ltLit = (LanguageTagLiteral)node;
            String oldValue = ltLit.getValue();
            if (oldValue == (newValue = XmlSafetyUtils.makeXmlSafe(oldValue))) {
                return node;
            }
            return model.createLanguageTagLiteral(newValue, ltLit.getLanguageTag());
        }
        if (node instanceof PlainLiteral) {
            String newValue;
            PlainLiteral pLit = (PlainLiteral)node;
            String oldValue = pLit.getValue();
            if (oldValue == (newValue = XmlSafetyUtils.makeXmlSafe(oldValue))) {
                return node;
            }
            return model.createPlainLiteral(newValue);
        }
        return node;
    }

    public static Statement makeXmlSafe(Model model, Statement stmt) {
        Node newNode;
        Node oldNode = stmt.getObject();
        if (oldNode == (newNode = XmlSafetyUtils.makeXmlSafe(model, oldNode))) {
            return stmt;
        }
        return model.createStatement(stmt.getSubject(), stmt.getPredicate(), newNode);
    }

    public static Writer wrapXmlSafeWriter(Writer writer) {
        if (!(writer instanceof XmlSafeWriter)) {
            return new XmlSafeWriter(writer);
        }
        return writer;
    }

    public static Reader wrapXmlSafeReader(Reader reader) {
        if (!(reader instanceof XmlSafeReader)) {
            return new XmlSafeReader(reader);
        }
        return reader;
    }

    public static Model wrapXmlSafeModel(Model model) {
        if (!(model instanceof XmlSafeModel)) {
            return new XmlSafeModel(model);
        }
        return model;
    }

    public static RDFContainer wrapXmlSafeRDFContainer(RDFContainer container) {
        if (container instanceof XmlSafeRDFContainer) {
            return container;
        }
        if (container instanceof RDFContainerImpl) {
            return new XmlSafeRDFContainer(container.getModel(), container.getDescribedUri(), ((RDFContainerImpl)container).isModelShared());
        }
        return new XmlSafeRDFContainer(container.getModel(), container.getDescribedUri());
    }

    public static RDFContainerFactory wrapXmlSafeRDFContainerFactory(RDFContainerFactory factory) {
        return new XmlSafeRDFContainerFactory(factory);
    }
}

