/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.rdf.util;

import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import org.ontoware.aifbcommons.collection.ClosableIterator;
import org.ontoware.rdf2go.exception.ModelRuntimeException;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.Statement;
import org.ontoware.rdf2go.model.Syntax;
import org.ontoware.rdf2go.model.impl.DelegatingModel;
import org.ontoware.rdf2go.model.node.BlankNode;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.URI;
import org.semanticdesktop.aperture.rdf.util.XmlSafetyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XmlSafeModel
extends DelegatingModel {
    public XmlSafeModel(Model model) {
        super(model);
    }

    public void addAll(Iterator<? extends Statement> it) throws ModelRuntimeException {
        while (it.hasNext()) {
            Statement stmt = it.next();
            this.addStatement(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModel(Model modelToAdd) throws ModelRuntimeException {
        ClosableIterator iter = null;
        try {
            iter = modelToAdd.iterator();
            this.addAll((Iterator<? extends Statement>)iter);
        }
        finally {
            this.closeClosable((ClosableIterator<Statement>)iter);
        }
    }

    public Resource addReificationOf(Statement arg0, Resource arg1) {
        return this.getDelegatedModel().addReificationOf(XmlSafetyUtils.makeXmlSafe(this.getDelegatedModel(), arg0), arg1);
    }

    public BlankNode addReificationOf(Statement arg0) {
        return this.getDelegatedModel().addReificationOf(XmlSafetyUtils.makeXmlSafe(this.getDelegatedModel(), arg0));
    }

    public void addStatement(Resource arg0, URI arg1, Node arg2) throws ModelRuntimeException {
        this.getDelegatedModel().addStatement(arg0, arg1, XmlSafetyUtils.makeXmlSafe(this.getDelegatedModel(), arg2));
    }

    public void addStatement(Resource arg0, URI arg1, String arg2, String arg3) throws ModelRuntimeException {
        this.getDelegatedModel().addStatement(arg0, arg1, XmlSafetyUtils.makeXmlSafe(arg2), arg3);
    }

    public void addStatement(Resource arg0, URI arg1, String arg2, URI arg3) throws ModelRuntimeException {
        this.getDelegatedModel().addStatement(arg0, arg1, XmlSafetyUtils.makeXmlSafe(arg2), arg3);
    }

    public void addStatement(Resource arg0, URI arg1, String arg2) throws ModelRuntimeException {
        this.getDelegatedModel().addStatement(arg0, arg1, XmlSafetyUtils.makeXmlSafe(arg2));
    }

    public void addStatement(Statement stmt) throws ModelRuntimeException {
        Statement newStmt = XmlSafetyUtils.makeXmlSafe(this.getDelegatedModel(), stmt);
        if (newStmt == stmt) {
            this.getDelegatedModel().addStatement(stmt);
        } else {
            this.getDelegatedModel().addStatement(newStmt);
        }
    }

    public void addStatement(String arg0, URI arg1, String arg2, String arg3) throws ModelRuntimeException {
        this.getDelegatedModel().addStatement(arg0, arg1, XmlSafetyUtils.makeXmlSafe(arg2), arg3);
    }

    public void addStatement(String arg0, URI arg1, String arg2, URI arg3) throws ModelRuntimeException {
        this.getDelegatedModel().addStatement(arg0, arg1, XmlSafetyUtils.makeXmlSafe(arg2), arg3);
    }

    public void addStatement(String arg0, URI arg1, String arg2) throws ModelRuntimeException {
        this.getDelegatedModel().addStatement(arg0, arg1, XmlSafetyUtils.makeXmlSafe(arg2));
    }

    private void closeClosable(ClosableIterator<Statement> iter) {
        if (iter != null) {
            try {
                iter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void readFrom(Reader in, Syntax syntax, String baseURI) throws IOException, ModelRuntimeException {
        super.readFrom(XmlSafetyUtils.wrapXmlSafeReader(in), syntax, baseURI);
    }

    public void readFrom(Reader reader, Syntax syntax) throws ModelRuntimeException, IOException {
        super.readFrom(XmlSafetyUtils.wrapXmlSafeReader(reader), syntax);
    }

    public void readFrom(Reader r) throws IOException, ModelRuntimeException {
        super.readFrom(XmlSafetyUtils.wrapXmlSafeReader(r));
    }
}

