/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.rdf.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import org.ontoware.aifbcommons.collection.ClosableIterator;
import org.ontoware.rdf2go.exception.ModelException;
import org.ontoware.rdf2go.exception.ModelRuntimeException;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.Statement;
import org.ontoware.rdf2go.model.Syntax;
import org.ontoware.rdf2go.model.node.BlankNode;
import org.ontoware.rdf2go.model.node.Literal;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.Variable;
import org.ontoware.rdf2go.vocabulary.XSD;
import org.semanticdesktop.aperture.util.IOUtil;
import org.semanticdesktop.aperture.util.ResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelUtil {
    private static Logger log = LoggerFactory.getLogger(ModelUtil.class);

    public static Literal createLiteral(Model model, String label) throws ModelException {
        return model.createPlainLiteral(label);
    }

    public static Literal createLiteral(Model model, String label, URI datatype) throws ModelException {
        return model.createDatatypeLiteral(label, datatype);
    }

    public static Literal createLiteral(Model model, boolean value) throws ModelException {
        return model.createDatatypeLiteral(String.valueOf(value), XSD._boolean);
    }

    public static Literal createLiteral(Model model, long value) throws ModelException {
        return model.createDatatypeLiteral(String.valueOf(value), XSD._long);
    }

    public static Literal createLiteral(Model model, int value) throws ModelException {
        return model.createDatatypeLiteral(String.valueOf(value), XSD._integer);
    }

    public static Literal createLiteral(Model model, short value) throws ModelException {
        return model.createDatatypeLiteral(String.valueOf(value), XSD._short);
    }

    public static Literal createLiteral(Model model, byte value) throws ModelException {
        return model.createDatatypeLiteral(String.valueOf(value), XSD._byte);
    }

    public static Literal createLiteral(Model model, double value) throws ModelException {
        return model.createDatatypeLiteral(String.valueOf(value), XSD._double);
    }

    public static Literal createLiteral(Model model, float value) throws ModelException {
        return model.createDatatypeLiteral(String.valueOf(value), XSD._float);
    }

    public static Statement createStatement(Model model, Resource subject, URI predicate, Node object) {
        return model.createStatement(subject, predicate, object);
    }

    public static URI createURI(Model model, String uri) throws ModelException {
        return model.createURI(uri);
    }

    public static URI createURI(Model model, String namespaceUri, String localName) throws ModelException {
        return ModelUtil.createURI(model, namespaceUri + "#" + localName);
    }

    public static BlankNode createBlankNode(Model model) {
        return model.createBlankNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Statement> getCBD(Resource node, Model model, boolean backwards) throws ModelException {
        Vector<Statement> res = new Vector<Statement>();
        ClosableIterator i = null;
        try {
            Statement s;
            i = model.findStatements(node, Variable.ANY, Variable.ANY);
            while (i.hasNext()) {
                s = (Statement)i.next();
                res.add(s);
                if (!(s.getObject() instanceof BlankNode)) continue;
                res.addAll(ModelUtil.getCBD((Resource)s.getObject(), model, backwards));
            }
            i.close();
            if (backwards) {
                i = model.findStatements(Variable.ANY, Variable.ANY, node);
                while (i.hasNext()) {
                    s = (Statement)i.next();
                    res.add(s);
                    if (!(s.getSubject() instanceof BlankNode)) continue;
                    res.addAll(ModelUtil.getCBD((Resource)s.getObject(), model, backwards));
                }
                i.close();
            }
        }
        finally {
            if (i != null) {
                i.close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasStatement(Model model, Resource subject, URI predicate, Node object) throws ModelException {
        boolean result = false;
        ClosableIterator iterator = null;
        try {
            iterator = model.findStatements(subject, predicate, object);
            result = iterator.hasNext();
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Resource getSingleSubjectWithProperty(Model model, URI predicate, Node object) {
        Resource resource;
        if (model == null || predicate == null || object == null) {
            throw new NullPointerException("All parameters of the getSingleSubjectWithProperty method must be non-null");
        }
        ClosableIterator iterator = null;
        try {
            iterator = model.findStatements(Variable.ANY, predicate, object);
            if (!iterator.hasNext()) {
                throw new ModelException("There are no subjects for property: " + predicate + " object: " + object);
            }
            Statement statement = (Statement)iterator.next();
            if (iterator.hasNext()) {
                throw new ModelException("There are multiple subjects for the given property");
            }
            resource = statement.getSubject().asResource();
        }
        catch (ModelException me) {
            try {
                log.warn("Couldn't get the subject for the given property", me);
            }
            catch (Throwable throwable) {
                ModelUtil.closeClosable(iterator);
                throw throwable;
            }
            ModelUtil.closeClosable(iterator);
            return null;
        }
        ModelUtil.closeClosable(iterator);
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Resource> getAllSubjectsWithProperty(Model model, URI predicate, Node object) {
        LinkedList<Resource> linkedList;
        if (model == null || predicate == null || object == null) {
            throw new NullPointerException("All parameters of the getSingleSubjectWithProperty method must be non-null");
        }
        ClosableIterator iterator = null;
        LinkedList<Resource> result = new LinkedList<Resource>();
        try {
            iterator = model.findStatements(Variable.ANY, predicate, object);
            while (iterator.hasNext()) {
                Statement statement = (Statement)iterator.next();
                result.add(statement.getSubject());
            }
            linkedList = result;
        }
        catch (Throwable throwable) {
            ModelUtil.closeClosable(iterator);
            throw throwable;
        }
        ModelUtil.closeClosable(iterator);
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Node getPropertyValue(Model model, Resource subject, URI predicate) {
        Node node;
        ClosableIterator iterator;
        block6: {
            if (model == null || subject == null || predicate == null) {
                throw new NullPointerException("All arguments of the getPropertyValue method must be non-null");
            }
            iterator = null;
            iterator = model.findStatements(subject, predicate, Variable.ANY);
            if (iterator.hasNext()) break block6;
            Node node2 = null;
            ModelUtil.closeClosable(iterator);
            return node2;
        }
        try {
            Statement statement = (Statement)iterator.next();
            node = statement.getObject();
        }
        catch (ModelRuntimeException me) {
            try {
                log.warn("Couldn't get the subject for the given property", me);
            }
            catch (Throwable throwable) {
                ModelUtil.closeClosable(iterator);
                throw throwable;
            }
            ModelUtil.closeClosable(iterator);
            return null;
        }
        ModelUtil.closeClosable(iterator);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Node> getAllPropertyValues(Model model, Resource subject, URI predicate) {
        LinkedList<Node> resultList = new LinkedList<Node>();
        ClosableIterator iterator = null;
        try {
            iterator = model.findStatements(subject, predicate, Variable.ANY);
            while (iterator.hasNext()) {
                Statement statement = (Statement)iterator.next();
                resultList.add(statement.getObject());
            }
        }
        catch (ModelRuntimeException me) {
            try {
                log.warn("Couldn't get all property values", me);
            }
            catch (Throwable throwable) {
                ModelUtil.closeClosable(iterator);
                throw throwable;
            }
            ModelUtil.closeClosable(iterator);
        }
        ModelUtil.closeClosable(iterator);
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAllPropertyValues(Model model, Resource subject, URI predicate) {
        ClosableIterator iterator = null;
        LinkedList<Statement> statementsToRemove = new LinkedList<Statement>();
        try {
            iterator = model.findStatements(subject, predicate, Variable.ANY);
            while (iterator.hasNext()) {
                Statement statement = (Statement)iterator.next();
                statementsToRemove.add(statement);
            }
            iterator.close();
            for (Statement statement : statementsToRemove) {
                model.removeStatement(statement);
            }
        }
        catch (ModelRuntimeException me) {
            try {
                log.warn("Couldn't remove all property values", me);
            }
            catch (Throwable throwable) {
                ModelUtil.closeClosable(iterator);
                throw throwable;
            }
            ModelUtil.closeClosable(iterator);
        }
        ModelUtil.closeClosable(iterator);
    }

    private static void closeClosable(ClosableIterator iterator) {
        if (iterator != null) {
            iterator.close();
        }
    }

    public static Object convertNode(Node node, Class<?> clazz) {
        try {
            if (clazz.equals(String.class)) {
                return node.toString();
            }
            if (clazz.equals(Node.class)) {
                return node;
            }
            if (clazz.equals(Resource.class)) {
                return node;
            }
            if (clazz.equals(URI.class)) {
                return node;
            }
            if (clazz.equals(Literal.class)) {
                return node;
            }
            if (clazz.equals(Integer.class)) {
                return new Integer(node.toString());
            }
            if (clazz.equals(Long.class)) {
                return new Long(node.toString());
            }
            if (clazz.equals(Boolean.class)) {
                String string = node.toString();
                if (string.equals("1")) {
                    return Boolean.TRUE;
                }
                if (string.equals("0")) {
                    return Boolean.FALSE;
                }
                return Boolean.valueOf(node.toString());
            }
            if (clazz.equals(Byte.class)) {
                return new Byte(node.toString());
            }
            if (clazz.equals(Short.class)) {
                return new Short(node.toString());
            }
            if (clazz.equals(Float.class)) {
                return new Float(node.toString());
            }
            if (clazz.equals(Double.class)) {
                return new Double(node.toString());
            }
            log.warn("Unknown class to convert node: " + node + ", clazz: " + clazz.getName());
            return null;
        }
        catch (Exception e) {
            log.debug("Conversion failed. node: " + node + ", clazz: " + clazz.getName());
            return null;
        }
    }

    public static Resource generateRandomResource(Model model) {
        return ModelUtil.generateRandomURI(model);
    }

    public static URI generateRandomURI(Model model) {
        return model.createURI("urn:uuid:" + UUID.randomUUID().toString());
    }

    public static void readFileFromResource(Model model, String path, Syntax syntax) throws FileNotFoundException, IOException, ModelException {
        InputStream stream = ResourceUtil.getInputStream(path, IOUtil.class);
        if (stream == null) {
            throw new FileNotFoundException("couldn't find resource " + path);
        }
        model.readFrom(stream, syntax);
    }

    public static String getFileName(URI uri) {
        String string = uri.toString();
        if (string.contains("#")) {
            string = string.substring(0, string.indexOf("#"));
        }
        if (string.contains("/")) {
            string = string.substring(string.lastIndexOf("/") + 1);
        }
        return string;
    }

    public static String getLocalName(URI vx) {
        String fullUri = vx.toString();
        int splitIdx = fullUri.indexOf(35);
        if (splitIdx < 0) {
            splitIdx = fullUri.lastIndexOf(47);
        }
        if (splitIdx < 0) {
            splitIdx = fullUri.lastIndexOf(58);
        }
        if (splitIdx < 0) {
            throw new RuntimeException("Not a legal (absolute) URI: " + fullUri);
        }
        return fullUri.substring(splitIdx + 1);
    }
}

