/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.rdf.impl;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import org.ontoware.aifbcommons.collection.ClosableIterator;
import org.ontoware.rdf2go.exception.ModelException;
import org.ontoware.rdf2go.exception.ModelRuntimeException;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.Statement;
import org.ontoware.rdf2go.model.node.Literal;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.Variable;
import org.ontoware.rdf2go.vocabulary.XSD;
import org.semanticdesktop.aperture.rdf.MultipleValuesException;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.rdf.UpdateException;
import org.semanticdesktop.aperture.rdf.ValueFactory;
import org.semanticdesktop.aperture.rdf.impl.ValueFactoryImpl;
import org.semanticdesktop.aperture.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFContainerImpl
implements RDFContainer {
    private Logger logger = LoggerFactory.getLogger(RDFContainerImpl.class.getName());
    private ValueFactory valueFactory;
    private Model model;
    private URI describedUri;
    private boolean modelShared;
    private boolean disposed;

    public RDFContainerImpl(Model model, String describedUri) {
        this.init(model, false);
        try {
            this.describedUri = this.valueFactory.createURI(describedUri);
        }
        catch (ModelException e) {
            throw new RuntimeException(e);
        }
    }

    public RDFContainerImpl(Model model, URI describedUri) {
        this.init(model, false);
        this.describedUri = describedUri;
    }

    public RDFContainerImpl(Model model, URI describedUri, boolean modelShared) {
        this.init(model, modelShared);
        this.describedUri = describedUri;
    }

    public RDFContainerImpl(Model model, String describedUri, boolean modelShared) {
        this.init(model, modelShared);
        try {
            this.describedUri = this.valueFactory.createURI(describedUri);
        }
        catch (ModelException e) {
            throw new RuntimeException(e);
        }
    }

    private void init(Model model, boolean shared) {
        this.model = model;
        this.modelShared = shared;
        this.valueFactory = new ValueFactoryImpl(model);
        this.disposed = false;
    }

    public URI getDescribedUri() {
        return this.describedUri;
    }

    public Model getModel() {
        return this.model;
    }

    public void put(URI property, String value) {
        this.checkState();
        try {
            this.replaceInternal(property, this.valueFactory.createLiteral(value));
        }
        catch (ModelException e) {
            this.logger.error("ModelException while storing value, ignoring", e);
        }
    }

    public void put(URI property, Date value) {
        this.checkState();
        String date = DateUtil.dateTime2String(value);
        try {
            this.replaceInternal(property, this.valueFactory.createLiteral(date, XSD._dateTime));
        }
        catch (ModelException e) {
            this.logger.error("ModelException while storing value, ignoring", e);
        }
    }

    public void put(URI property, Calendar value) {
        this.checkState();
        this.put(property, value.getTime());
    }

    public void put(URI property, boolean value) {
        this.checkState();
        try {
            this.replaceInternal(property, this.valueFactory.createLiteral(value));
        }
        catch (ModelException e) {
            this.logger.error("ModelException while storing value, ignoring", e);
        }
    }

    public void put(URI property, int value) {
        this.checkState();
        try {
            this.replaceInternal(property, this.valueFactory.createLiteral(value));
        }
        catch (ModelException e) {
            this.logger.error("ModelException while storing value, ignoring", e);
        }
    }

    public void put(URI property, long value) {
        this.checkState();
        try {
            this.replaceInternal(property, this.valueFactory.createLiteral(value));
        }
        catch (ModelException e) {
            this.logger.error("ModelException while storing value, ignoring", e);
        }
    }

    public void put(URI property, Node value) {
        this.checkState();
        this.replaceInternal(property, value);
    }

    public void add(URI property, String value) {
        this.checkState();
        try {
            this.addInternal(property, this.valueFactory.createLiteral(value));
        }
        catch (ModelException e) {
            this.logger.error("ModelException while storing value, ignoring", e);
        }
    }

    public void add(URI property, Date value) {
        this.checkState();
        String date = DateUtil.dateTime2String(value);
        try {
            this.addInternal(property, this.valueFactory.createLiteral(date, XSD._dateTime));
        }
        catch (ModelException e) {
            this.logger.error("ModelException while storing value, ignoring", e);
        }
    }

    public void add(URI property, Calendar value) {
        this.checkState();
        this.add(property, value.getTime());
    }

    public void add(URI property, boolean value) {
        this.checkState();
        try {
            this.addInternal(property, this.valueFactory.createLiteral(value));
        }
        catch (ModelException e) {
            this.logger.error("ModelException while storing value, ignoring", e);
        }
    }

    public void add(URI property, int value) {
        this.checkState();
        try {
            this.addInternal(property, this.valueFactory.createLiteral(value));
        }
        catch (ModelException e) {
            this.logger.error("ModelException while storing value, ignoring", e);
        }
    }

    public void add(URI property, long value) {
        this.checkState();
        try {
            this.addInternal(property, this.valueFactory.createLiteral(value));
        }
        catch (ModelException e) {
            this.logger.error("ModelException while storing value, ignoring", e);
        }
    }

    public void add(URI property, Node node) {
        this.checkState();
        this.addInternal(property, node);
    }

    public String getString(URI property) {
        this.checkState();
        Node node = this.getInternal(property);
        if (node instanceof Literal) {
            return ((Literal)node).getValue();
        }
        return null;
    }

    public Date getDate(URI property) {
        this.checkState();
        String value = this.getString(property);
        if (value == null) {
            return null;
        }
        try {
            return DateUtil.string2DateTime(value);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public Calendar getCalendar(URI property) {
        this.checkState();
        Date date = this.getDate(property);
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public Boolean getBoolean(URI property) {
        this.checkState();
        String value = this.getString(property);
        if (value == null) {
            return null;
        }
        return Boolean.valueOf(value);
    }

    public Integer getInteger(URI property) {
        this.checkState();
        String value = this.getString(property);
        if (value == null) {
            return null;
        }
        try {
            return new Integer(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Long getLong(URI property) {
        this.checkState();
        String value = this.getString(property);
        if (value == null) {
            return null;
        }
        try {
            return new Long(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public URI getURI(URI property) {
        this.checkState();
        Node node = this.getInternal(property);
        if (node instanceof URI) {
            return node.asURI();
        }
        return null;
    }

    public Node getNode(URI property) {
        this.checkState();
        return this.getInternal(property);
    }

    public void remove(URI property) {
        this.checkState();
        Node node = this.getInternal(property);
        if (node != null) {
            try {
                this.model.removeStatement((Resource)this.describedUri, property, node);
            }
            catch (ModelRuntimeException me) {
                this.logger.error("Could not remove a statement from the model", me);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getAll(URI property) {
        this.checkState();
        ClosableIterator iterator = null;
        try {
            iterator = this.model.findStatements(this.describedUri, property, Variable.ANY);
            ArrayList<Node> result = new ArrayList<Node>();
            while (iterator.hasNext()) {
                Statement statement = (Statement)iterator.next();
                result.add(statement.getObject());
            }
            ArrayList<Node> arrayList = result;
            return arrayList;
        }
        catch (ModelRuntimeException me) {
            this.logger.error("Could not find statements", me);
            Collection collection = null;
            return collection;
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
        }
    }

    public void add(Statement statement) {
        this.checkState();
        try {
            this.model.addStatement(statement);
        }
        catch (ModelRuntimeException e) {
            this.logger.error("cannot add statement", e);
            throw new UpdateException("cannot add statement", e);
        }
    }

    public void remove(Statement statement) {
        this.checkState();
        try {
            this.model.removeStatement(statement);
        }
        catch (ModelRuntimeException e) {
            this.logger.error("cannot remove statement", e);
            throw new UpdateException("cannot remove statement", e);
        }
    }

    private void addInternal(URI property, Node object) {
        try {
            this.model.addStatement(this.describedUri, property, object);
        }
        catch (ModelRuntimeException e) {
            this.logger.error("cannot add statement", e);
            throw new UpdateException("cannot add statement", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceInternal(URI property, Node object) throws MultipleValuesException {
        try {
            ClosableIterator statements = this.model.findStatements(this.describedUri, property, Variable.ANY);
            Statement statementToRemove = null;
            try {
                if (statements.hasNext()) {
                    statementToRemove = (Statement)statements.next();
                    if (statements.hasNext()) {
                        throw new MultipleValuesException(this.describedUri, property);
                    }
                }
            }
            finally {
                statements.close();
            }
            if (statementToRemove != null) {
                this.model.removeStatement(statementToRemove);
            }
            this.model.addStatement(this.describedUri, property, object);
        }
        catch (ModelRuntimeException me) {
            this.logger.error("cannot update statement", me);
            throw new UpdateException("cannot update statement", me);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node getInternal(URI property) {
        ClosableIterator statements = null;
        try {
            statements = this.model.findStatements(this.describedUri, property, Variable.ANY);
            Node result = null;
            if (statements.hasNext()) {
                Statement firstStatement = (Statement)statements.next();
                if (statements.hasNext()) {
                    throw new MultipleValuesException(this.describedUri, property);
                }
                result = firstStatement.getObject();
            }
            Node node = result;
            return node;
        }
        catch (ModelRuntimeException me) {
            this.logger.error("Could not find statements", me);
            Node node = null;
            return node;
        }
        finally {
            if (statements != null) {
                statements.close();
            }
        }
    }

    public ValueFactory getValueFactory() {
        this.checkState();
        return this.valueFactory;
    }

    public void dispose() {
        this.disposed = true;
        if (!this.modelShared) {
            this.model.close();
        }
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public boolean isModelShared() {
        return this.modelShared;
    }

    private void checkState() {
        if (this.disposed) {
            throw new IllegalStateException("Trying to perform an operation after disposal");
        }
    }
}

