/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.outlook;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class VariantDate {
    private double mValue;

    public VariantDate(double value) {
        this.mValue = value;
    }

    public VariantDate() {
        this.set(new GregorianCalendar());
    }

    public VariantDate(GregorianCalendar cal) {
        this.set(cal);
    }

    public VariantDate(Date dt) {
        this.setDate(dt);
    }

    public void set(GregorianCalendar cal) {
        this.set(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14));
    }

    public synchronized String toString() {
        DateFormat f = DateFormat.getDateTimeInstance(2, 2);
        return f.format(this.get().getTime());
    }

    public synchronized double getValue() {
        return this.mValue;
    }

    public synchronized void setValue(double newValue) {
        this.mValue = newValue;
    }

    public Date getDate() {
        GregorianCalendar cal = this.get();
        return new Date(cal.getTime().getTime());
    }

    public Date getDate(Calendar cal) {
        this.initCalendar(cal);
        return new Date(cal.getTime().getTime());
    }

    public synchronized void setDate(Date dt) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(dt);
        this.set(cal);
    }

    public synchronized void set(int y, int m, int d, int h, int i, int s, int l) {
        if (m > 2) {
            m -= 3;
        } else {
            m += 9;
            --y;
        }
        int c = y / 100;
        int ya = y - 100 * c;
        int vDate = (146097 * c >> 2) + (1461 * ya >> 2) + (153 * m + 2) / 5 + d - 693900;
        this.mValue = h * 3600000 + i * 60000 + s * 1000 + l;
        this.mValue /= 8.64E7;
        this.mValue += (double)vDate;
    }

    public GregorianCalendar get() {
        GregorianCalendar cal = new GregorianCalendar();
        this.initCalendar(cal);
        return cal;
    }

    public synchronized void initCalendar(Calendar cal) {
        int j = (int)this.mValue;
        double r = Math.round((this.mValue - (double)j) * 8.64E7);
        int y = (((j += 693900) << 2) - 1) / 146097;
        j = (j << 2) - 1 - 146097 * y;
        int d = j >> 2;
        j = ((d << 2) + 3) / 1461;
        d = (d << 2) + 3 - 1461 * j;
        d = d + 4 >> 2;
        int m = (5 * d - 3) / 153;
        d = 5 * d - 3 - 153 * m;
        d = (d + 5) / 5;
        y = 100 * y + j;
        if (m < 10) {
            m += 3;
        } else {
            m -= 9;
            ++y;
        }
        int h = (int)r / 3600000;
        int i = (int)(r -= (double)(h * 3600000)) / 60000;
        int s = (int)(r -= (double)(i * 60000)) / 1000;
        int l = (int)r - s * 1000;
        cal.set(y, m - 1, d, h, i, s);
        cal.set(14, l);
    }
}

