/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.outlook;

import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.ComFailException;
import com.jacob.com.Dispatch;
import com.jacob.com.Variant;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.ontoware.rdf2go.exception.ModelException;
import org.ontoware.rdf2go.exception.ModelRuntimeException;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.ontoware.rdf2go.vocabulary.RDFS;
import org.ontoware.rdf2go.vocabulary.XSD;
import org.semanticdesktop.aperture.accessor.AccessData;
import org.semanticdesktop.aperture.accessor.DataObject;
import org.semanticdesktop.aperture.accessor.RDFContainerFactory;
import org.semanticdesktop.aperture.accessor.UrlNotFoundException;
import org.semanticdesktop.aperture.datasource.DataSource;
import org.semanticdesktop.aperture.outlook.OutlookCrawler;
import org.semanticdesktop.aperture.outlook.VariantDate;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.rdf.ValueFactory;
import org.semanticdesktop.aperture.rdf.util.ModelUtil;
import org.semanticdesktop.aperture.util.DateUtil;
import org.semanticdesktop.aperture.vocabulary.NAO;
import org.semanticdesktop.aperture.vocabulary.NCAL;
import org.semanticdesktop.aperture.vocabulary.NCO;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.semanticdesktop.aperture.vocabulary.NIE;
import org.semanticdesktop.aperture.vocabulary.NMO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OutlookResource {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private OutlookCrawler crawler;
    private String itemType;
    private Dispatch resource = null;
    private String uri;

    private static String createUri(OutlookCrawler crawler, Dispatch resource, String itemType) {
        if (crawler == null) {
            throw new RuntimeException("passed in a null crawler for createUri");
        }
        if (resource == null) {
            throw new RuntimeException("passed in a null resource for createUri");
        }
        return crawler.getUriPrefix() + itemType + "/" + Dispatch.get((Dispatch)resource, (String)"EntryID").getString();
    }

    public static OutlookResource createWrapperFor(OutlookCrawler crawler, Dispatch resource, Logger logger) {
        try {
            int classID = Dispatch.get((Dispatch)resource, (String)"Class").toInt();
            switch (classID) {
                case 26: {
                    return new Appointment(crawler, resource);
                }
                case 40: {
                    return new Contact(crawler, resource);
                }
                case 69: {
                    return new DistList(crawler, resource);
                }
                case 41: {
                    return new Document(crawler, resource);
                }
                case 2: {
                    return OutlookResource.createWrapperForFolder(crawler, resource);
                }
                case 43: {
                    return new Mail(crawler, resource);
                }
                case 1: {
                    return new RootFolder(crawler);
                }
                case 44: {
                    return new Note(crawler, resource);
                }
                case 48: {
                    return new Task(crawler, resource);
                }
                case 42: {
                    return null;
                }
                case 53: {
                    return null;
                }
                case 0: {
                    return null;
                }
            }
            throw new UrlNotFoundException("no RDF mapping defined for Outlook.classID '" + Integer.toString(classID) + "'. Item Ignored.");
        }
        catch (UrlNotFoundException ex) {
            logger.info("Outlook Cannot wrap resource: " + ex);
            return null;
        }
        catch (Exception ex) {
            logger.warn("Error creating Resourcewrapper: " + ex);
            return null;
        }
    }

    public static OutlookResource createWrapperFor(OutlookCrawler crawler, String uri, Logger logger) {
        block11: {
            String itemIdentity;
            String itemType;
            String uriPrefix = crawler.getUriPrefix();
            try {
                if (!uri.startsWith(uriPrefix)) {
                    throw new Exception("uri '" + uri + "' is not starting with '" + uriPrefix + "'");
                }
                String pathS = uri.substring(uriPrefix.length());
                String[] path = pathS.split("/");
                itemType = path[0];
                itemIdentity = path.length > 1 ? path[1] : null;
            }
            catch (Exception ex) {
                if (logger.isInfoEnabled()) {
                    logger.info("uri '" + uri + "' cannot be parsed." + ex.toString());
                }
                return null;
            }
            try {
                if (itemType.equals(Appointment.ITEMTYPE) || itemType.equals("contact") || itemType.equals("distlist") || itemType.equals("document") || itemType.equals("mail") || itemType.equals("note") || itemType.equals("task")) {
                    Variant variant = Dispatch.call((Dispatch)crawler.getOutlookMapi(), (String)"GetItemFromID", (Object)itemIdentity);
                    if (variant == null) {
                        throw new Exception("GetItemFromID returned null for id " + itemIdentity);
                    }
                    Dispatch item = variant.toDispatch();
                    OutlookResource wrapper = OutlookResource.createWrapperFor(crawler, item, logger);
                    return wrapper;
                }
                if (itemType.equals("root")) {
                    return new RootFolder(crawler);
                }
                if (itemType.equals("folder") || itemType.equals("calendar")) {
                    return OutlookResource.createWrapperForFolder(crawler, itemIdentity, itemType, logger);
                }
            }
            catch (ComFailException ex) {
                crawler.crashChecker(ex);
            }
            catch (Exception ex) {
                if (!logger.isInfoEnabled()) break block11;
                logger.info("Cannot resolve outlook uri '" + uri + "': " + ex.toString(), ex);
            }
        }
        return null;
    }

    public static Folder createWrapperForFolder(OutlookCrawler crawler, Dispatch folder) {
        int defaultItemType = Dispatch.get((Dispatch)folder, (String)"DefaultItemType").toInt();
        if (defaultItemType == 1) {
            return new Calendar(crawler, folder);
        }
        return new Folder(crawler, folder);
    }

    public static Folder createWrapperForFolder(OutlookCrawler crawler, String itemId, String expectedItemType, Logger logger) throws Exception {
        Variant variant = Dispatch.call((Dispatch)crawler.getOutlookMapi(), (String)"GetItemFromID", (Object)itemId);
        if (variant == null) {
            throw new Exception("GetItemFromID returned null for id " + itemId);
        }
        Dispatch item = variant.toDispatch();
        Folder folder = OutlookResource.createWrapperForFolder(crawler, item);
        if (!expectedItemType.equals(folder.getItemType())) {
            String msg = "created wrapper for item " + itemId + "  expected " + expectedItemType + " but got " + folder.getItemType();
            logger.warn(msg);
            throw new Exception(msg);
        }
        return folder;
    }

    protected OutlookResource(OutlookCrawler crawler, Dispatch resource, String itemType) {
        this(crawler, OutlookResource.createUri(crawler, resource, itemType), resource, itemType);
    }

    protected OutlookResource(OutlookCrawler crawler, String uri, Dispatch resource, String itemType) {
        if (crawler == null) {
            throw new RuntimeException("crawler must not be null for OutlookResource");
        }
        this.crawler = crawler;
        this.uri = uri;
        this.resource = resource;
        this.itemType = itemType;
    }

    public void addData(RDFContainer rdf) throws IOException {
        String entryid;
        try {
            Variant entryidv = Dispatch.get((Dispatch)this.resource, (String)"EntryID");
            entryid = entryidv != null ? entryidv.getString() : null;
        }
        catch (Exception x) {
            entryid = null;
        }
        if (entryid == null) {
            if (!(this instanceof RootFolder)) {
                this.logger.error("cannot get id of " + this.getUri() + ", it is null. type " + this.getType());
            }
        } else {
            rdf.add(NAO.identifier, "outlookitemid:" + entryid);
        }
        this.addDetailData(rdf);
    }

    protected abstract void addDetailData(RDFContainer var1) throws IOException;

    protected void addDateIfNotNull(RDFContainer rdf, URI property, Dispatch resource, String dispName) {
        Date date = this.getDateOf(resource, dispName);
        if (date != null) {
            rdf.add(property, date);
        }
    }

    protected void addNcalDateTimeIfNotNull(RDFContainer rdf, URI property, Dispatch resource, String dispName) {
        Date date = this.getDateOf(resource, dispName);
        if (date != null) {
            Resource ncalDateTimeResource = ModelUtil.generateRandomResource(rdf.getModel());
            rdf.add(property, ncalDateTimeResource);
            this.addStatement(rdf, ncalDateTimeResource, RDF.type, NCAL.NcalDateTime);
            this.addStatement(rdf, ncalDateTimeResource, NCAL.dateTime, DateUtil.dateTime2String(date), XSD._dateTime);
        }
    }

    protected void addEmailAddressIfNotNull(Model model, Resource parentNode, Dispatch resource, String dispName) {
        String addressString = this.getLiteralOf(resource, dispName);
        if (addressString != null) {
            Resource emailAddressNode = ModelUtil.generateRandomResource(model);
            model.addStatement(parentNode, NCO.hasEmailAddress, emailAddressNode);
            model.addStatement(emailAddressNode, RDF.type, NCO.EmailAddress);
            model.addStatement(emailAddressNode, NCO.emailAddress, addressString);
        }
    }

    protected void addTelephoneNumberIfNotNull(Model model, Resource parentNode, Dispatch resource, String dispName, String comment, URI type) {
        String telephoneString = this.getLiteralOf(resource, dispName);
        if (telephoneString != null) {
            Resource telephoneNumberNode = ModelUtil.generateRandomResource(model);
            model.addStatement(parentNode, NCO.hasPhoneNumber, telephoneNumberNode);
            model.addStatement(telephoneNumberNode, RDF.type, type);
            model.addStatement(telephoneNumberNode, NCO.phoneNumber, telephoneString);
            if (comment != null) {
                model.addStatement(telephoneNumberNode, NCO.contactMediumComment, comment);
            }
        }
    }

    protected void addPropertyIfNotNull(RDFContainer rdf, URI property, Dispatch disp, String dispName) {
        String s = this.getLiteralOf(disp, dispName);
        if (s != null) {
            rdf.add(property, s);
        }
    }

    protected void addStatement(RDFContainer rdf, Resource subject, URI predicate, String label, URI datatype) {
        this.addStatement(rdf, subject, predicate, rdf.getModel().createDatatypeLiteral(label, datatype));
    }

    protected void addStatement(RDFContainer rdf, Resource subject, URI predicate, String label) {
        this.addStatement(rdf, subject, predicate, rdf.getModel().createPlainLiteral(label));
    }

    protected void addStatement(RDFContainer rdf, Resource subject, URI predicate, Node object) {
        rdf.getModel().addStatement(subject, predicate, object);
    }

    protected void addRecipientsIfNotNull(RDFContainer rdf, Dispatch resource, String dispName, OutlookResource parentResource) {
        if (parentResource == null) {
            throw new NullPointerException("Error: parentResource=null");
        }
        Variant recipients = Dispatch.get((Dispatch)resource, (String)dispName);
        ValueFactory vf = rdf.getValueFactory();
        if (recipients != null) {
            Dispatch recipientsD = recipients.toDispatch();
            try {
                int count = Dispatch.get((Dispatch)recipientsD, (String)"Count").toInt();
                this.logger.info("adding e-mail, found recipients: " + count);
                for (int i = 1; i <= count; ++i) {
                    try {
                        Dispatch recipient = Dispatch.invoke((Dispatch)recipientsD, (String)"Item", (int)2, (Object[])new Object[]{new Integer(i)}, (int[])new int[1]).toDispatch();
                        String type = this.getLiteralOf(recipient, "Type");
                        String name = this.getLiteralOf(recipient, "Name");
                        String mailbox = this.getLiteralOf(recipient, "Address");
                        if (name == null && mailbox == null) continue;
                        URI rec = vf.createURI(this.getUri() + "_recipient" + i);
                        rdf.add(vf.createStatement(rec, RDF.type, NCO.Contact));
                        if (name != null) {
                            rdf.add(vf.createStatement(rec, NCO.fullname, vf.createLiteral(name)));
                        }
                        if (mailbox != null) {
                            Resource emailAddressResource = ModelUtil.generateRandomResource(rdf.getModel());
                            this.addStatement(rdf, (Resource)rec, NCO.hasEmailAddress, emailAddressResource);
                            this.addStatement(rdf, emailAddressResource, RDF.type, NCO.EmailAddress);
                            this.addStatement(rdf, emailAddressResource, NCO.emailAddress, vf.createLiteral(mailbox));
                        }
                        if (parentResource instanceof Mail) {
                            if (type.equals(Integer.toString(1))) {
                                rdf.add(NMO.to, rec);
                                continue;
                            }
                            if (type.equals(Integer.toString(2))) {
                                rdf.add(NMO.cc, rec);
                                continue;
                            }
                            if (type.equals(Integer.toString(3))) {
                                rdf.add(NMO.bcc, rec);
                                continue;
                            }
                            this.logger.warn("cannot connect mail recipient type '" + type + "', using NMO.to instead");
                            rdf.add(NMO.to, rec);
                            continue;
                        }
                        if (parentResource instanceof Appointment) {
                            if (type.equals(Integer.toString(2))) {
                                rdf.add(NCAL.attendee, rec);
                                rdf.add(vf.createStatement(rec, RDF.type, NCAL.Attendee));
                                rdf.add(vf.createStatement(rec, NCAL.role, NCAL.optParticipantRole));
                                continue;
                            }
                            if (type.equals(Integer.toString(0))) {
                                rdf.add(NCAL.attendee, rec);
                                rdf.add(NCAL.organizer, rec);
                                rdf.add(vf.createStatement(rec, RDF.type, NCAL.Attendee));
                                rdf.add(vf.createStatement(rec, RDF.type, NCAL.Organizer));
                                rdf.add(vf.createStatement(rec, NCAL.role, NCAL.chairRole));
                                continue;
                            }
                            if (type.equals(Integer.toString(1))) {
                                rdf.add(NCAL.attendee, rec);
                                rdf.add(vf.createStatement(rec, RDF.type, NCAL.Attendee));
                                rdf.add(vf.createStatement(rec, NCAL.role, NCAL.reqParticipantRole));
                                continue;
                            }
                            if (type.equals(Integer.toString(3))) {
                                rdf.add(NCAL.attendee, rec);
                                rdf.add(vf.createStatement(rec, RDF.type, NCAL.Attendee));
                                rdf.add(vf.createStatement(rec, RDFS.comment, vf.createLiteral("resource")));
                                continue;
                            }
                            this.logger.warn("cannot connect Appointment recipient type '" + type + "', using NCAL.attendee instead");
                            rdf.add(NCAL.attendee, rec);
                            rdf.add(vf.createStatement(rec, RDF.type, NCAL.Attendee));
                            continue;
                        }
                        this.logger.warn("cannot add recipients for type '" + parentResource.getClass() + "': I only understand OutlookResource.Appointment or OutlookResource.Mail. " + "Using connection NIE:hasLogicalPart to connect " + rdf.getDescribedUri() + " to " + rec);
                        rdf.add(NIE.hasLogicalPart, rec);
                        continue;
                    }
                    catch (Exception ex) {
                        this.logger.warn("error reading recipient " + i + " of dispatch " + resource + ": " + ex, ex);
                    }
                }
            }
            catch (Exception ex) {
                this.logger.warn("cannot read recipients of dispatch " + resource + ": " + ex, ex);
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this.resource != null) {
            this.logger.warn("This resource was not released, but in finalize: " + this.getUri());
            this.release();
        }
        super.finalize();
    }

    public DataObject getDataObjectIfModified(String url, DataSource source, AccessData accessData, Map params, RDFContainerFactory containerFactory) throws UrlNotFoundException, IOException {
        return null;
    }

    protected Date getDateOf(Dispatch disp, String dispName) {
        try {
            Variant var = Dispatch.get((Dispatch)disp, (String)dispName);
            if (var == null || var.isNull()) {
                return null;
            }
            if (var.getvt() == 7) {
                VariantDate vDat = new VariantDate(var.toDate());
                Date dDat = vDat.getDate();
                return dDat;
            }
            throw new RuntimeException("cannot read " + dispName + " from dispatch, does not return a Date-Value");
        }
        catch (ComFailException x) {
            this.logger.warn("Error on com for dispname " + dispName + ": " + (Object)((Object)x));
            return null;
        }
    }

    public String getItemType() {
        return this.itemType;
    }

    public long getLastModified() {
        Variant var;
        try {
            var = Dispatch.get((Dispatch)this.resource, (String)"LastModificationTime");
        }
        catch (ComFailException x) {
            this.logger.warn("cannot read last-modification time of " + this.getUri() + " of type " + this.getItemType());
            return 0L;
        }
        if (var == null || var.isNull()) {
            this.logger.warn("cannot read LastModificationTime, no value");
            return 0L;
        }
        if (var.getvt() == 7) {
            double d = var.getDate();
            VariantDate vDat = new VariantDate(var.toDate());
            if (this.logger.isInfoEnabled()) {
                this.logger.info("This has lastModified: " + DateUtil.dateTime2String(vDat.getDate()) + " with double " + Double.toString(d));
            }
            return vDat.getDate().getTime();
        }
        this.logger.warn("cannot read LastModificationTime, type is not date but: " + var.getvt());
        return 0L;
    }

    protected String getLiteralOf(Dispatch disp, String dispName) {
        try {
            String s = null;
            Variant var = Dispatch.get((Dispatch)disp, (String)dispName);
            if (var == null || var.isNull()) {
                s = null;
            } else if (var.getvt() == 7) {
                VariantDate vDat = new VariantDate(var.toDate());
                Date dDat = vDat.getDate();
                s = DateUtil.dateTime2String(dDat);
            } else {
                s = var.toString();
            }
            if (s != null && s.length() == 0) {
                s = null;
            }
            return s;
        }
        catch (ComFailException x) {
            this.logger.warn("Error on com for dispname " + dispName + ": " + (Object)((Object)x));
            return null;
        }
    }

    public OutlookCrawler getOLCrawler() {
        return this.crawler;
    }

    public Dispatch getResource() {
        return this.resource;
    }

    public abstract URI getType();

    public String getUri() {
        return this.uri;
    }

    public boolean isFolder() {
        return false;
    }

    public void release() {
        if (this.resource != null) {
            this.resource.safeRelease();
        }
        this.resource = null;
    }

    public static class Task
    extends OutlookResourceSave {
        public static final String ITEMTYPE = "task";

        public Task(OutlookCrawler crawler, Dispatch resource) {
            super(crawler, resource, ITEMTYPE);
            this.saveRedemptionClass = "Redemption.SafeTaskItem";
        }

        protected void addDetailData(RDFContainer rdf) throws IOException {
            Dispatch resource = this.getSaveResource();
            this.addPropertyIfNotNull(rdf, NIE.title, resource, "Subject");
            this.addPropertyIfNotNull(rdf, NIE.plainTextContent, resource, "Body");
            this.addDateIfNotNull(rdf, NCAL.completed, resource, "DateCompleted");
            this.addNcalDateTimeIfNotNull(rdf, NCAL.due, resource, "DueDate");
        }

        public URI getType() {
            return NCAL.Todo;
        }
    }

    public static class RootFolder
    extends OutlookResource {
        public static final String ITEMTYPE = "root";

        public RootFolder(OutlookCrawler crawler) {
            super(crawler, crawler.getUriPrefix() + ITEMTYPE, crawler.getOutlookMapi(), ITEMTYPE);
        }

        protected void addDetailData(RDFContainer rdf) throws IOException {
            rdf.add(NIE.title, "Outlook root folder");
        }

        public long getLastModified() {
            return 0L;
        }

        public URI getType() {
            return NFO.Folder;
        }

        public boolean isFolder() {
            return true;
        }
    }

    public static abstract class OutlookResourceSave
    extends OutlookResource {
        protected Logger logger = LoggerFactory.getLogger(this.getClass());
        protected String saveRedemptionClass = null;
        private Dispatch saveResource = null;

        protected OutlookResourceSave(OutlookCrawler crawler, Dispatch resource, String itemtype) {
            super(crawler, resource, itemtype);
        }

        public OutlookResourceSave(OutlookCrawler crawler, String url, Dispatch resource, String itemtype) {
            super(crawler, url, resource, itemtype);
        }

        public Dispatch getSaveResource() {
            if (this.saveResource == null) {
                if (this.getOLCrawler().hasRedemption()) {
                    try {
                        this.saveResource = new ActiveXComponent(this.saveRedemptionClass);
                    }
                    catch (ComFailException x) {
                        this.logger.warn("Redemption error, cannot get redemption object for " + this.saveRedemptionClass);
                        return null;
                    }
                    Dispatch.put((Dispatch)this.saveResource, (String)"Item", (Object)this.getResource());
                } else {
                    return this.getResource();
                }
            }
            return this.saveResource;
        }

        public void release() {
            if (this.saveResource != null) {
                this.saveResource.safeRelease();
            }
            super.release();
        }
    }

    public static class Note
    extends OutlookResource {
        public static final String ITEMTYPE = "note";

        public Note(OutlookCrawler crawler, Dispatch resource) {
            super(crawler, resource, ITEMTYPE);
        }

        protected void addDetailData(RDFContainer rdf) throws IOException {
            Dispatch resource = this.getResource();
            this.addPropertyIfNotNull(rdf, NIE.title, resource, "Subject");
            this.addPropertyIfNotNull(rdf, NIE.plainTextContent, resource, "Body");
        }

        public URI getType() {
            return NFO.TextDocument;
        }
    }

    public static class Mail
    extends OutlookResourceSave {
        public static final String ITEMTYPE = "mail";

        public Mail(OutlookCrawler crawler, Dispatch resource) {
            super(crawler, resource, ITEMTYPE);
            this.saveRedemptionClass = "Redemption.SafeMailItem";
        }

        protected void addDetailData(RDFContainer rdf) throws IOException {
            Dispatch resource = this.getSaveResource();
            ValueFactory vf = rdf.getValueFactory();
            this.addPropertyIfNotNull(rdf, NMO.messageSubject, resource, "Subject");
            this.addDateIfNotNull(rdf, NMO.receivedDate, resource, "ReceivedTime");
            this.addDateIfNotNull(rdf, NMO.sentDate, resource, "SentOn");
            this.addPropertyIfNotNull(rdf, NMO.plainTextMessageContent, resource, "Body");
            String name = this.getLiteralOf(this.getSaveResource(), "SenderName");
            String mailbox = this.getLiteralOf(this.getSaveResource(), "SenderEmailAddress");
            if (name != null || mailbox != null) {
                try {
                    URI from = vf.createURI(this.getUri() + "_FROM");
                    rdf.add(vf.createStatement(from, RDF.type, NCO.Contact));
                    if (name != null) {
                        rdf.add(vf.createStatement(from, NCO.fullname, vf.createLiteral(name)));
                    }
                    if (mailbox != null) {
                        Resource emailAddressResource = ModelUtil.generateRandomResource(rdf.getModel());
                        this.addStatement(rdf, (Resource)from, NCO.hasEmailAddress, emailAddressResource);
                        this.addStatement(rdf, emailAddressResource, RDF.type, NCO.EmailAddress);
                        this.addStatement(rdf, emailAddressResource, NCO.emailAddress, vf.createLiteral(mailbox));
                    }
                    rdf.add(NMO.from, from);
                }
                catch (ModelException e) {
                    this.logger.error("ModelException while adding statements", e);
                }
            }
            this.addRecipientsIfNotNull(rdf, this.getResource(), "Recipients", this);
        }

        public URI getType() {
            return NMO.Email;
        }
    }

    public static class Folder
    extends OutlookResource {
        public static final String ITEMTYPE = "folder";

        public Folder(OutlookCrawler crawler, Dispatch resource) {
            super(crawler, resource, ITEMTYPE);
        }

        public Folder(OutlookCrawler crawler, Dispatch resource, String itemtype) {
            super(crawler, resource, itemtype);
        }

        public Folder(OutlookCrawler crawler, String uri, Dispatch resource, String itemType) {
            super(crawler, uri, resource, itemType);
        }

        protected void addDetailData(RDFContainer rdf) throws IOException {
            this.addPropertyIfNotNull(rdf, NIE.title, this.getResource(), "Name");
        }

        public long getLastModified() {
            return new Date().getTime();
        }

        public URI getType() {
            return NFO.Folder;
        }

        public int getDefaultItemType() {
            int result = Dispatch.get((Dispatch)this.getResource(), (String)"DefaultItemType").toInt();
            return result;
        }

        public String getDefaultMessageClass() {
            Variant v = Dispatch.get((Dispatch)this.getResource(), (String)"DefaultMessageClass");
            return v.toString();
        }

        public String getName() {
            String s = this.getLiteralOf(this.getResource(), "Name");
            return s;
        }

        public boolean isFolder() {
            return true;
        }
    }

    public static class Document
    extends OutlookResource {
        public static final String ITEMTYPE = "document";

        public Document(OutlookCrawler crawler, Dispatch resource) {
            super(crawler, resource, ITEMTYPE);
        }

        protected void addDetailData(RDFContainer rdf) throws IOException {
            Dispatch resource = this.getResource();
            this.addPropertyIfNotNull(rdf, NIE.title, resource, "Subject");
            this.addPropertyIfNotNull(rdf, NIE.plainTextContent, resource, "Body");
        }

        public URI getType() {
            return NFO.TextDocument;
        }
    }

    public static class DistList
    extends OutlookResourceSave {
        public static final String ITEMTYPE = "distlist";

        public DistList(OutlookCrawler crawler, Dispatch resource) {
            super(crawler, resource, ITEMTYPE);
            this.saveRedemptionClass = "Redemption.SafeDistList";
        }

        protected void addDetailData(RDFContainer rdf) throws IOException {
        }

        public URI getType() {
            return NCO.ContactGroup;
        }
    }

    public static class Contact
    extends OutlookResourceSave {
        public static final String ITEMTYPE = "contact";

        public Contact(OutlookCrawler crawler, Dispatch resource) {
            super(crawler, resource, ITEMTYPE);
            this.saveRedemptionClass = "Redemption.SafeContactItem";
        }

        protected void addDetailData(RDFContainer rdf) throws IOException {
            Dispatch resource = this.getSaveResource();
            this.addPropertyIfNotNull(rdf, NIE.title, resource, "Subject");
            Model model = rdf.getModel();
            URI uri = rdf.getDescribedUri();
            this.addEmailAddressIfNotNull(model, uri, resource, "Email1Address");
            this.addEmailAddressIfNotNull(model, uri, resource, "Email2Address");
            this.addEmailAddressIfNotNull(model, uri, resource, "Email3Address");
            this.addPropertyIfNotNull(rdf, NCO.websiteUrl, resource, "WebPage");
            this.addPropertyIfNotNull(rdf, NCO.nameFamily, resource, "LastName");
            this.addPropertyIfNotNull(rdf, NCO.nameGiven, resource, "FirstName");
            this.addPropertyIfNotNull(rdf, NCO.nameAdditional, resource, "Title");
            this.addPropertyIfNotNull(rdf, NCO.fullname, resource, "Fullname");
            this.addPropertyIfNotNull(rdf, NCO.title, resource, "Title");
            this.addPropertyIfNotNull(rdf, NCO.note, this.getSaveResource(), "Body");
            this.addTelephoneNumberIfNotNull(model, uri, resource, "BusinessTelephoneNumber", "work", NCO.PhoneNumber);
            this.addTelephoneNumberIfNotNull(model, uri, resource, "HomeTelephoneNumber", "home", NCO.PhoneNumber);
            this.addTelephoneNumberIfNotNull(model, uri, resource, "MobileTelephoneNumber", "cell", NCO.CellPhoneNumber);
            this.readAddress(resource, "BusinessAddress", rdf, "work");
            this.readAddress(resource, "HomeAddress", rdf, "home");
            this.readAddress(resource, "MailingAddress", rdf, "mailing");
            this.readAddress(resource, "OtherAddress", rdf, "other");
            String companies = this.getLiteralOf(resource, "Companies");
            String companyName = this.getLiteralOf(resource, "CompanyName");
            String jobTitle = this.getLiteralOf(resource, "JobTitle");
            if (companyName != null || jobTitle != null || companies != null) {
                try {
                    URI affiliationResource = rdf.getValueFactory().createURI(this.getUri() + "_" + "Affiliation");
                    this.addStatement(rdf, (Resource)uri, NCO.hasAffiliation, affiliationResource);
                    this.addStatement(rdf, (Resource)affiliationResource, RDF.type, NCO.Affiliation);
                    if (jobTitle != null) {
                        this.addStatement(rdf, (Resource)affiliationResource, NCO.title, jobTitle);
                    }
                    if (companyName != null || companies != null) {
                        URI organizationContactResource = rdf.getValueFactory().createURI(this.getUri() + "_" + "Organization");
                        this.addStatement(rdf, (Resource)affiliationResource, NCO.org, organizationContactResource);
                        this.addStatement(rdf, (Resource)organizationContactResource, RDF.type, NCO.OrganizationContact);
                        if (companies != null) {
                            this.addStatement(rdf, (Resource)organizationContactResource, NCO.fullname, companies);
                        }
                        if (companyName != null) {
                            this.addStatement(rdf, (Resource)organizationContactResource, NCO.fullname, companyName);
                        }
                    }
                }
                catch (ModelException e) {
                    throw new ModelRuntimeException(e);
                }
            }
        }

        public URI getType() {
            return NCO.Contact;
        }

        public void readAddress(Dispatch d, String prefix, RDFContainer rdf, String comment) {
            String street;
            Variant var = Dispatch.get((Dispatch)d, (String)(prefix + "City"));
            ValueFactory vf = rdf.getValueFactory();
            String city = var == null ? null : var.getString();
            var = Dispatch.get((Dispatch)d, (String)(prefix + "Country"));
            String country = var == null ? null : var.getString();
            var = Dispatch.get((Dispatch)d, (String)(prefix + "PostOfficeBox"));
            String pobox = var == null ? null : var.getString();
            var = Dispatch.get((Dispatch)d, (String)(prefix + "PostalCode"));
            String plz = var == null ? null : var.getString();
            var = Dispatch.get((Dispatch)d, (String)(prefix + "State"));
            String state = var == null ? null : var.getString();
            var = Dispatch.get((Dispatch)d, (String)(prefix + "Street"));
            String string = street = var == null ? null : var.getString();
            if (city != null && city.length() == 0) {
                city = null;
            }
            if (country != null && country.length() == 0) {
                country = null;
            }
            if (pobox != null && pobox.length() == 0) {
                pobox = null;
            }
            if (plz != null && plz.length() == 0) {
                plz = null;
            }
            if (state != null && state.length() == 0) {
                state = null;
            }
            if (street != null && street.length() == 0) {
                street = null;
            }
            if (city != null || country != null || pobox != null || plz != null || state != null || street != null) {
                try {
                    URI address = rdf.getValueFactory().createURI(this.getUri() + "_" + prefix);
                    rdf.add(vf.createStatement(address, RDF.type, NCO.PostalAddress));
                    if (city != null) {
                        rdf.add(vf.createStatement(address, NCO.locality, vf.createLiteral(city)));
                    }
                    if (country != null) {
                        rdf.add(vf.createStatement(address, NCO.country, vf.createLiteral(country)));
                    }
                    if (pobox != null) {
                        rdf.add(vf.createStatement(address, NCO.pobox, vf.createLiteral(pobox)));
                    }
                    if (plz != null) {
                        rdf.add(vf.createStatement(address, NCO.postalcode, vf.createLiteral(plz)));
                    }
                    if (state != null) {
                        rdf.add(vf.createStatement(address, NCO.region, vf.createLiteral(state)));
                    }
                    if (street != null) {
                        rdf.add(vf.createStatement(address, NCO.streetAddress, vf.createLiteral(street)));
                    }
                    if (comment != null) {
                        this.addStatement(rdf, (Resource)address, NCO.contactMediumComment, comment);
                    }
                    rdf.add(NCO.hasPostalAddress, address);
                }
                catch (ModelException e) {
                    this.logger.error("ModelException while adding statements", e);
                }
            }
        }
    }

    public static class Calendar
    extends Folder {
        public static final String ITEMTYPE = "calendar";

        public Calendar(OutlookCrawler crawler, Dispatch resource) {
            super(crawler, resource, ITEMTYPE);
        }
    }

    public static class Appointment
    extends OutlookResourceSave {
        public static String ITEMTYPE = "appointment";

        public Appointment(OutlookCrawler crawler, Dispatch resource) {
            super(crawler, resource, ITEMTYPE);
            this.saveRedemptionClass = "Redemption.SafeAppointmentItem";
        }

        protected void addDetailData(RDFContainer rdf) throws IOException {
            Dispatch resource = this.getSaveResource();
            this.addPropertyIfNotNull(rdf, NIE.title, resource, "Subject");
            this.addPropertyIfNotNull(rdf, NIE.plainTextContent, resource, "Body");
            this.addDateIfNotNull(rdf, NCAL.dtstamp, resource, "CreationTime");
            this.addDateIfNotNull(rdf, NCAL.lastModified, resource, "LastModificationTime");
            this.addNcalDateTimeIfNotNull(rdf, NCAL.dtstart, resource, "Start");
            this.addNcalDateTimeIfNotNull(rdf, NCAL.dtend, resource, "End");
            this.addPropertyIfNotNull(rdf, NCAL.location, resource, "Location");
            String organizer = this.getLiteralOf(resource, "Organizer");
            if (organizer != null) {
                URI organizerUri = rdf.getModel().createURI(rdf.getDescribedUri() + "-organizer");
                rdf.add(NCAL.organizer, organizerUri);
                rdf.getModel().addStatement(organizerUri, RDF.type, NCAL.Organizer);
                rdf.getModel().addStatement(organizerUri, NCO.fullname, organizer);
            }
            String optionalAttendees = this.getLiteralOf(resource, "OptionalAttendees");
            this.logger.debug("optional: " + optionalAttendees);
            this.addRecipientsIfNotNull(rdf, this.getResource(), "Recipients", this);
        }

        public URI getType() {
            return NCAL.Event;
        }
    }
}

