/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.outlook;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ontoware.rdf2go.RDF2Go;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.node.URI;
import org.semanticdesktop.aperture.detector.DataSourceDescription;
import org.semanticdesktop.aperture.detector.DataSourceDetector;
import org.semanticdesktop.aperture.outlook.OUTLOOKDS;
import org.semanticdesktop.aperture.outlook.OutlookCrawler;
import org.semanticdesktop.aperture.outlook.OutlookDataSource;
import org.semanticdesktop.aperture.rdf.impl.RDFContainerImpl;
import org.semanticdesktop.aperture.rdf.util.ModelUtil;
import org.semanticdesktop.aperture.util.OSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutlookDataSourceDetector
implements DataSourceDetector {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DataSourceDescription> detect() throws Exception {
        if (!OSUtils.isWindows()) {
            return Collections.emptyList();
        }
        OutlookDataSource ds = new OutlookDataSource();
        Model m = RDF2Go.getModelFactory().createModel();
        m.open();
        URI id = ModelUtil.generateRandomURI(m);
        ds.setConfiguration(new RDFContainerImpl(m, id));
        ds.setName("Microsoft Outlook");
        ds.setComment("Your emails, appointments, contacts and other elements from Outlook.");
        ds.setRootUrl("outlook://");
        boolean outlookIsThere = false;
        OutlookCrawler crawler = new OutlookCrawler();
        try {
            try {
                crawler.setDataSource(ds);
                crawler.beginCall();
                outlookIsThere = true;
                crawler.endCall();
            }
            catch (Throwable t) {
                try {
                    this.logger.debug("Outlook is not there, this is ok: " + t, t);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    crawler.endCall();
                }
            }
        }
        catch (Throwable t) {
            this.logger.debug("cannot detect Outlook: " + t, t);
        }
        finally {
            crawler.release();
        }
        if (!outlookIsThere) {
            return Collections.emptyList();
        }
        ArrayList<DataSourceDescription> result = new ArrayList<DataSourceDescription>(1);
        result.add(new DataSourceDescription(ds));
        return result;
    }

    @Override
    public URI getSupportedType() {
        return OUTLOOKDS.OutlookDataSource;
    }
}

