/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.opener.file;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.semanticdesktop.aperture.opener.DataOpener;
import org.semanticdesktop.aperture.util.OSUtils;

public class FileOpener
implements DataOpener {
    public void open(org.ontoware.rdf2go.model.node.URI uri) throws IOException {
        if (OSUtils.isMac()) {
            this.macopen(uri);
        } else if (OSUtils.isLinux()) {
            this.linuxopen(uri);
        } else if (OSUtils.isWindows()) {
            this.windowsopen(uri);
        } else {
            throw new IOException("Unsupported OS:" + System.getProperty("os.name"));
        }
    }

    private void macopen(org.ontoware.rdf2go.model.node.URI url) throws IOException {
        try {
            Class<?> macopener = Class.forName("com.apple.eio.FileManager");
            Method m = macopener.getMethod("openURL", String.class);
            m.invoke(null, url.toString());
        }
        catch (Exception e) {
            throw new IOException("Could not open file: " + url + " - " + e);
        }
    }

    private File URI2File(org.ontoware.rdf2go.model.node.URI uri) throws IOException {
        File f;
        try {
            String st = uri.toString();
            int ind = st.indexOf(35);
            if (ind > -1) {
                st = st.substring(0, ind);
            }
            f = new File(new URI(st));
        }
        catch (URISyntaxException e) {
            throw new IOException("Could not parse URI: " + uri.toString() + " - " + e);
        }
        return f;
    }

    private void windowsopen(org.ontoware.rdf2go.model.node.URI uri) throws IOException {
        File f = this.URI2File(uri);
        if (f.isDirectory()) {
            Runtime.getRuntime().exec(new String[]{"cmd", "/c", "explorer", f.toString()});
        } else {
            Runtime.getRuntime().exec(new String[]{"cmd", "/c", f.toString()});
        }
    }

    private void linuxopen(org.ontoware.rdf2go.model.node.URI uri) throws IOException {
        File f = this.URI2File(uri);
        if (System.getenv("DESKTOP_SESSION").toLowerCase().contains("kde")) {
            Runtime.getRuntime().exec(new String[]{"kfmclient", "exec", f.toString()});
        } else {
            Runtime.getRuntime().exec(new String[]{"gnome-open", uri.toString()});
        }
    }

    public static void main(String[] args) throws IOException {
        FileOpener f = new FileOpener();
        if (OSUtils.isMac()) {
            f.open(URIImpl.createURIWithoutChecking("file:///Users/"));
            f.open(URIImpl.createURIWithoutChecking("file:///Users/"));
        } else if (OSUtils.isWindows()) {
            f.open(URIImpl.createURIWithoutChecking("file:/c:"));
            f.open(URIImpl.createURIWithoutChecking("file:/c:/windows/win.ini"));
        } else if (OSUtils.isLinux()) {
            f.open(URIImpl.createURIWithoutChecking("file:///tmp"));
            f.open(URIImpl.createURIWithoutChecking("file:///etc/bash.bashrc"));
        } else {
            throw new Error("What weirdass OS are you running?");
        }
    }
}

