/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.mime.identifier.magic;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.ontoware.rdf2go.model.node.URI;
import org.semanticdesktop.aperture.mime.identifier.MimeTypeIdentifier;
import org.semanticdesktop.aperture.mime.identifier.magic.MagicNumber;
import org.semanticdesktop.aperture.mime.identifier.magic.MagicString;
import org.semanticdesktop.aperture.mime.identifier.magic.MimeTypeDescription;
import org.semanticdesktop.aperture.util.ResourceUtil;
import org.semanticdesktop.aperture.util.UtfUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MagicMimeTypeIdentifier
implements MimeTypeIdentifier {
    private static final String MIME_TYPES_RESOURCE = "org/semanticdesktop/aperture/mime/identifier/magic/mimetypes.xml";
    private static final int PLAIN_TEXT_TEST_ARRAY_LENGTH = 100;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ArrayList mimeTypeDescriptions;
    private int minArrayLength;

    public MagicMimeTypeIdentifier() {
        this(MIME_TYPES_RESOURCE);
    }

    public MagicMimeTypeIdentifier(String definitionsResource) {
        this.readDescriptions(definitionsResource);
        this.setRequiringTypes();
        this.determineMinArrayLength();
    }

    private void readDescriptions(String definitionsResource) {
        Document document;
        DocumentBuilder docBuilder;
        InputStream stream = ResourceUtil.getInputStream(definitionsResource, MagicMimeTypeIdentifier.class);
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setValidating(false);
        docBuilderFactory.setExpandEntityReferences(true);
        try {
            docBuilder = docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("unable to instantiate DocumentBuilder", e);
        }
        try {
            document = docBuilder.parse(stream);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Element documentRoot = document.getDocumentElement();
        NodeList descriptionElements = documentRoot.getElementsByTagName("description");
        int nrDescriptions = descriptionElements.getLength();
        this.mimeTypeDescriptions = new ArrayList(nrDescriptions);
        for (int i = 0; i < nrDescriptions; ++i) {
            Element descriptionElement = (Element)descriptionElements.item(i);
            MimeTypeDescription description = this.createMimeTypeDescription(descriptionElement);
            if (description == null) continue;
            this.mimeTypeDescriptions.add(description);
        }
    }

    private MimeTypeDescription createMimeTypeDescription(Element descriptionElement) {
        String mimeType = null;
        String parentType = null;
        ArrayList<String> extensions = new ArrayList<String>();
        ArrayList magicStrings = new ArrayList();
        ArrayList magicNumbers = new ArrayList();
        boolean allowsLeadingWhiteSpace = false;
        NodeList childNodes = descriptionElement.getChildNodes();
        int nrNodes = childNodes.getLength();
        for (int i = 0; i < nrNodes; ++i) {
            Node valueNode;
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 1) continue;
            String tagName = childNode.getNodeName();
            if ("mimeType".equals(tagName) && (valueNode = childNode.getFirstChild()) != null) {
                mimeType = valueNode.getNodeValue().trim();
            }
            if ("parentType".equals(tagName)) {
                valueNode = childNode.getFirstChild();
                if (valueNode == null) continue;
                parentType = valueNode.getNodeValue().trim();
                continue;
            }
            if ("extensions".equals(tagName)) {
                valueNode = childNode.getFirstChild();
                if (valueNode == null) continue;
                String extensionsString = valueNode.getNodeValue().trim();
                StringTokenizer tokenizer = new StringTokenizer(extensionsString, ", ", false);
                while (tokenizer.hasMoreTokens()) {
                    extensions.add(tokenizer.nextToken().toLowerCase());
                }
                continue;
            }
            if ("allowsLeadingWhiteSpace".equals(tagName)) {
                valueNode = childNode.getFirstChild();
                if (valueNode == null) continue;
                String text = valueNode.getNodeValue().trim();
                allowsLeadingWhiteSpace = Boolean.parseBoolean(text);
                continue;
            }
            if ("magicNumber".equals(tagName)) {
                this.createMagicNumber((Element)childNode, mimeType, magicNumbers);
                continue;
            }
            if (!"magicString".equals(tagName)) continue;
            this.createMagicString((Element)childNode, mimeType, magicStrings, magicNumbers);
        }
        if (mimeType == null) {
            return null;
        }
        return new MimeTypeDescription(mimeType, parentType, extensions, magicStrings, magicNumbers, allowsLeadingWhiteSpace);
    }

    private void createMagicNumber(Element element, String mimeType, ArrayList magicNumbers) {
        byte[] magicBytes = null;
        Node firstChild = element.getFirstChild();
        if (firstChild == null) {
            this.logger.warn("missing magicNumber content in " + mimeType + " description");
            return;
        }
        String numberString = firstChild.getNodeValue();
        String encodingString = element.getAttribute("encoding").trim();
        String offsetString = element.getAttribute("offset").trim();
        int offset = 0;
        if (offsetString.length() > 0) {
            try {
                offset = Integer.parseInt(offsetString);
            }
            catch (NumberFormatException e) {
                this.logger.warn("illegal offset: " + offsetString + ", ignoring magic number");
                return;
            }
        }
        if ("string".equals(encodingString)) {
            try {
                magicBytes = numberString.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        } else if ("hex".equals(encodingString)) {
            numberString = numberString.trim();
            numberString = numberString.replaceAll(" ", "");
            numberString = numberString.toLowerCase();
            int nrChars = numberString.length();
            magicBytes = new byte[nrChars / 2];
            int cumulative = 0;
            for (int j = 0; j < nrChars; ++j) {
                char c = numberString.charAt(j);
                int decimalValue = 0;
                if (c >= '0' && c <= '9') {
                    decimalValue = c - 48;
                } else if (c >= 'a' && c <= 'f') {
                    decimalValue = c - 97 + 10;
                } else {
                    this.logger.warn("illegal hexadecimal char: " + c);
                    return;
                }
                if (j % 2 == 0) {
                    cumulative = 16 * decimalValue;
                    continue;
                }
                magicBytes[j / 2] = (byte)(cumulative += decimalValue);
            }
        } else {
            this.logger.warn("unknown or empty encoding: " + encodingString);
            return;
        }
        magicNumbers.add(new MagicNumber(magicBytes, offset));
    }

    private void createMagicString(Element element, String mimeType, ArrayList magicStrings, ArrayList magicNumbers) {
        Node firstChild = element.getFirstChild();
        if (firstChild == null) {
            this.logger.warn("missing magicString content in " + mimeType + " description");
            return;
        }
        String magicString = firstChild.getNodeValue();
        boolean caseSensitive = Boolean.parseBoolean(element.getAttribute("caseSensitive"));
        magicStrings.add(new MagicString(magicString.toCharArray(), caseSensitive));
        try {
            byte[] bytes = magicString.getBytes("UTF-8");
            byte[] bom = UtfUtil.findMatchingBOM(bytes);
            if (bom != null) {
                int remainingLength = bytes.length - bom.length;
                byte[] newBytes = new byte[remainingLength];
                System.arraycopy(bytes, bom.length, newBytes, 0, remainingLength);
                bytes = newBytes;
            }
            magicNumbers.add(new MagicNumber(bytes, 0));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private void setRequiringTypes() {
        MimeTypeDescription description;
        HashMap<String, MimeTypeDescription> descriptionMap = new HashMap<String, MimeTypeDescription>();
        int nrDescriptions = this.mimeTypeDescriptions.size();
        for (int i = 0; i < nrDescriptions; ++i) {
            description = (MimeTypeDescription)this.mimeTypeDescriptions.get(i);
            descriptionMap.put(description.getMimeType(), description);
        }
        Iterator iterator = this.mimeTypeDescriptions.iterator();
        while (iterator.hasNext()) {
            description = (MimeTypeDescription)iterator.next();
            String parentType = description.getParentType();
            if (parentType == null) continue;
            iterator.remove();
            MimeTypeDescription parentDescription = (MimeTypeDescription)descriptionMap.get(parentType);
            if (parentDescription == null) {
                this.logger.warn("unable to retrieve parent type description for " + description.getMimeType());
                continue;
            }
            parentDescription.addRequiringType(description);
        }
    }

    private void determineMinArrayLength() {
        this.minArrayLength = 100;
        int nrDescriptions = this.mimeTypeDescriptions.size();
        for (int i = 0; i < nrDescriptions; ++i) {
            MimeTypeDescription description = (MimeTypeDescription)this.mimeTypeDescriptions.get(i);
            ArrayList numbers = description.getMagicNumbers();
            int nrNumbers = numbers.size();
            for (int j = 0; j < nrNumbers; ++j) {
                MagicNumber number = (MagicNumber)numbers.get(j);
                this.minArrayLength = Math.max(this.minArrayLength, number.getMinimumLength());
            }
            ArrayList strings = description.getMagicStrings();
            int nrStrings = strings.size();
            for (int j = 0; j < nrStrings; ++j) {
                MagicString string = (MagicString)strings.get(j);
                this.minArrayLength = Math.max(this.minArrayLength, string.getMinimumLength() * 2 + 2);
            }
        }
    }

    protected ArrayList getMimeTypeDescriptions() {
        return this.mimeTypeDescriptions;
    }

    public String identify(byte[] firstBytes, String fileName, URI uri) {
        String mimeType;
        String extension;
        char[] firstChars = null;
        byte[] realBom = null;
        if (firstBytes != null) {
            int bomLength;
            byte[] tmpBom;
            realBom = UtfUtil.findMatchingBOM(firstBytes);
            if (realBom == null) {
                tmpBom = UtfUtil.UTF8_BOM;
                bomLength = 0;
            } else {
                tmpBom = realBom;
                bomLength = tmpBom.length;
            }
            int contentLength = firstBytes.length - bomLength;
            if ((contentLength & 1) == 1) {
                --contentLength;
            }
            byte[] contentBytes = new byte[contentLength];
            System.arraycopy(firstBytes, bomLength, contentBytes, 0, contentLength);
            String charset = UtfUtil.getCharsetName(tmpBom);
            if (charset != null) {
                try {
                    String string = new String(contentBytes, charset);
                    firstChars = string.toCharArray();
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
            }
        }
        if ((extension = fileName) == null && uri != null && !(extension = uri.toString()).contains("!/") && !extension.contains("?/")) {
            extension = this.removeFragment('?', extension);
            extension = this.removeFragment('#', extension);
        }
        if (extension != null) {
            int lastDotIndex = extension.lastIndexOf(46);
            if (lastDotIndex > 0 && lastDotIndex < extension.length() - 1) {
                extension = extension.substring(lastDotIndex + 1);
            }
            extension = extension.toLowerCase();
        }
        if ((mimeType = this.identify(firstChars, firstBytes, extension, this.mimeTypeDescriptions)) == null && realBom != null) {
            return "text/plain";
        }
        if (mimeType == null && this.isReadableASCII(firstBytes)) {
            return "text/plain";
        }
        return mimeType;
    }

    private String removeFragment(char separatorChar, String input) {
        int index;
        String result = input;
        if (input != null && (index = input.indexOf(separatorChar)) >= 0 && index < input.length() - 1) {
            return input.substring(0, index);
        }
        return result;
    }

    private String identify(char[] firstChars, byte[] firstBytes, String extension, ArrayList descriptions) {
        MimeTypeDescription description;
        int i;
        int nrDescriptions;
        if (firstChars != null) {
            nrDescriptions = descriptions.size();
            for (i = 0; i < nrDescriptions; ++i) {
                description = (MimeTypeDescription)descriptions.get(i);
                if (!description.matches(firstChars)) continue;
                ArrayList requiringTypes = description.getRequiringTypes();
                String overrulingResult = this.identify(firstChars, firstBytes, extension, requiringTypes);
                return overrulingResult == null ? description.getMimeType() : overrulingResult;
            }
        }
        if (firstBytes != null) {
            nrDescriptions = descriptions.size();
            for (i = 0; i < nrDescriptions; ++i) {
                description = (MimeTypeDescription)descriptions.get(i);
                if (!description.matches(firstBytes)) continue;
                ArrayList requiringTypes = description.getRequiringTypes();
                String overrulingResult = this.identify(firstChars, firstBytes, extension, requiringTypes);
                return overrulingResult == null ? description.getMimeType() : overrulingResult;
            }
        }
        if (extension != null) {
            nrDescriptions = descriptions.size();
            for (i = 0; i < nrDescriptions; ++i) {
                description = (MimeTypeDescription)descriptions.get(i);
                if (!description.containsExtension(extension)) continue;
                return description.getMimeType();
            }
        }
        return null;
    }

    public int getMinArrayLength() {
        return this.minArrayLength;
    }

    public List getExtensionsFor(String mimeType) {
        return this.getExtensionsFor(mimeType, this.mimeTypeDescriptions);
    }

    private List getExtensionsFor(String mimeType, ArrayList descriptions) {
        int nrExtensions = descriptions.size();
        for (int i = 0; i < nrExtensions; ++i) {
            MimeTypeDescription description = (MimeTypeDescription)descriptions.get(i);
            if (description.getMimeType().equals(mimeType)) {
                return description.getExtensions();
            }
            List result = this.getExtensionsFor(mimeType, description.getRequiringTypes());
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private boolean isReadableASCII(byte[] bytes) {
        if (bytes == null) {
            return false;
        }
        for (int i = 0; i < bytes.length; ++i) {
            if (this.isReadableASCII(bytes[i])) continue;
            return false;
        }
        return true;
    }

    private boolean isReadableASCII(int b) {
        return b == 9 || b == 10 || b == 13 || b >= 32 && b <= 126;
    }
}

