/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.xmp;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.Syntax;
import org.ontoware.rdf2go.model.node.URI;
import org.semanticdesktop.aperture.extractor.Extractor;
import org.semanticdesktop.aperture.extractor.ExtractorException;
import org.semanticdesktop.aperture.rdf.RDFContainer;

public class XMPExtractor
implements Extractor {
    private static final byte[] PACKET_HEADER;
    private static final byte[] PACKET_HEADER_END;
    private static final byte[] PACKET_TRAILER;
    private static final byte[] XML_HEADER;

    public void extract(URI uri, InputStream in, Charset charset, String mimeType, RDFContainer result) throws ExtractorException {
        ByteArrayOutputStream baout;
        boolean foundXMP;
        if (!in.markSupported()) {
            in = new BufferedInputStream(in);
        }
        if (!(foundXMP = XMPExtractor.skipAfter(in, PACKET_HEADER))) {
            return;
        }
        if (!XMPExtractor.skipAfter(in, PACKET_HEADER_END)) {
            throw new ExtractorException("Invalid XMP packet header!");
        }
        try {
            if (!XMPExtractor.skipAfter(in, ">".getBytes("UTF-8"))) {
                return;
            }
            baout = new ByteArrayOutputStream();
            baout.write(XML_HEADER);
        }
        catch (IOException e) {
            throw new ExtractorException(e);
        }
        if (!XMPExtractor.skipAfter(in, PACKET_TRAILER, baout)) {
            throw new ExtractorException("XMP packet not properly terminated!");
        }
        Model model = result.getModel();
        try {
            model.readFrom(new ByteArrayInputStream(baout.toByteArray()), Syntax.RdfXml, uri.toString());
        }
        catch (IOException e) {
            throw new ExtractorException(e);
        }
    }

    private static boolean skipAfter(InputStream in, byte[] match) throws ExtractorException {
        return XMPExtractor.skipAfter(in, match, null);
    }

    private static boolean skipAfter(InputStream in, byte[] match, OutputStream out) throws ExtractorException {
        int found = 0;
        int len = match.length;
        try {
            int b;
            while ((b = in.read()) >= 0) {
                if (b == match[found]) {
                    if (++found != len) continue;
                    return true;
                }
                if (out != null) {
                    if (found > 0) {
                        out.write(match, 0, found);
                    }
                    out.write(b);
                }
                found = 0;
            }
        }
        catch (IOException e) {
            throw new ExtractorException(e);
        }
        return false;
    }

    static {
        try {
            PACKET_HEADER = "<?xpacket begin=".getBytes("UTF-8");
            PACKET_HEADER_END = "?>".getBytes("UTF-8");
            PACKET_TRAILER = "</x:xmpmeta>".getBytes("UTF-8");
            XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

