/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.powerpoint;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.extractor.Extractor;
import org.semanticdesktop.aperture.extractor.ExtractorException;
import org.semanticdesktop.aperture.extractor.microsoft.util.PoiUtil;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PowerPointExtractor
implements Extractor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void extract(URI id, InputStream stream, Charset charset, String mimeType, RDFContainer result) throws ExtractorException {
        PoiUtil.extractAll(stream, new PowerPointTextExtractor(), result, this.logger);
        result.add(RDF.type, NFO.Presentation);
    }

    public static String getText(DirectoryNode dir, POIFSFileSystem fs) throws IOException {
        org.apache.poi.hslf.extractor.PowerPointExtractor extractor = new org.apache.poi.hslf.extractor.PowerPointExtractor(dir, fs);
        return extractor.getText(true, true);
    }

    private static class PowerPointTextExtractor
    implements PoiUtil.TextExtractor {
        private PowerPointTextExtractor() {
        }

        public String getText(DirectoryNode dir, POIFSFileSystem fs) throws IOException {
            return PowerPointExtractor.getText(dir, fs);
        }
    }
}

