/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.poiooxml;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.StringTokenizer;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.POIXMLDocument;
import org.apache.poi.POIXMLProperties;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xslf.XSLFSlideShow;
import org.apache.poi.xslf.extractor.XSLFPowerPointExtractor;
import org.apache.poi.xssf.extractor.XSSFExcelExtractor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xwpf.extractor.XWPFWordExtractor;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.openxmlformats.schemas.officeDocument.x2006.extendedProperties.CTProperties;
import org.semanticdesktop.aperture.extractor.Extractor;
import org.semanticdesktop.aperture.extractor.ExtractorException;
import org.semanticdesktop.aperture.extractor.microsoft.util.PoiUtil;
import org.semanticdesktop.aperture.extractor.openxml.OpenXmlExtractor;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.rdf.util.ModelUtil;
import org.semanticdesktop.aperture.vocabulary.APERTURE_NIE_EXTENSIONS;
import org.semanticdesktop.aperture.vocabulary.NCO;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.semanticdesktop.aperture.vocabulary.NIE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoiOOXmlExtractor
implements Extractor {
    private static final String EXTENDED_PROPERTIES_NS = "http://schemas.openxmlformats.org/officeDocument/2006/extended-properties/";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Type type;
    private boolean cacheDocument = false;
    private POIXMLDocument document = null;

    public PoiOOXmlExtractor(Type type) {
        this.type = type;
        this.cacheDocument = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extract(URI id, InputStream stream, Charset charset, String mimeType, RDFContainer container) throws ExtractorException {
        String text = null;
        XWPFDocument document = null;
        XWPFWordExtractor extractor = null;
        OPCPackage pack = null;
        int bufferSize = PoiUtil.getBufferSize();
        if (!stream.markSupported()) {
            stream = new BufferedInputStream(stream, bufferSize);
        }
        stream = new UncloseableInputStream(stream);
        stream.mark(bufferSize);
        try {
            pack = OPCPackage.open((InputStream)stream);
            switch (this.type) {
                case WORD: {
                    document = new XWPFDocument(pack);
                    this.extractWordMetadata(document, container);
                    extractor = new XWPFWordExtractor(document);
                    break;
                }
                case EXCEL: {
                    document = new XSSFWorkbook(pack);
                    this.extractExcelMetadata((XSSFWorkbook)document, container);
                    extractor = new XSSFExcelExtractor((XSSFWorkbook)document);
                    break;
                }
                case POWERPOINT: {
                    document = new XSLFSlideShow(pack);
                    this.extractPowerpointMetadata((XSLFSlideShow)document, container);
                    extractor = new XSLFPowerPointExtractor((XSLFSlideShow)document);
                }
            }
            text = extractor.getText();
        }
        catch (EncryptedDocumentException e) {
            return;
        }
        catch (Exception e) {
            this.tryWithOldOpenXmlExtractor(id, stream, charset, mimeType, container);
        }
        finally {
            if (this.cacheDocument) {
                this.document = document;
            } else {
                this.closeOPCPackage(pack);
            }
        }
        if (text != null && (text = text.trim()).length() > 0) {
            container.add(NIE.plainTextContent, text);
        }
        container.add(RDF.type, NFO.PaginatedTextDocument);
    }

    public boolean isCacheDocument() {
        return this.cacheDocument;
    }

    public void setCacheDocument(boolean cacheDocument) {
        this.cacheDocument = cacheDocument;
    }

    public POIXMLDocument getDocument() {
        return this.document;
    }

    private void closeOPCPackage(OPCPackage pack) {
        if (pack != null) {
            try {
                pack.close();
            }
            catch (IOException e) {
                this.logger.warn("Couldn't close the package: ", e);
            }
        }
    }

    private void extractCommonMetadta(POIXMLProperties.CoreProperties props, RDFContainer container) {
        this.addDateProperty(container, NIE.contentCreated, props.getCreated());
        this.addContactProperty(container, NCO.creator, props.getCreator());
        this.addStringProperty(container, NIE.description, props.getDescription());
        this.addStringProperty(container, NIE.identifier, props.getIdentifier());
        this.addDateProperty(container, APERTURE_NIE_EXTENSIONS.contentLastPrinted, props.getLastPrinted());
        this.addDateProperty(container, NIE.contentLastModified, props.getModified());
        this.addStringProperty(container, NIE.version, props.getRevision());
        this.addStringProperty(container, NIE.subject, props.getSubject());
        this.addStringProperty(container, NIE.title, props.getTitle());
        String keywords = props.getKeywords();
        if (keywords != null) {
            StringTokenizer tokenizer = new StringTokenizer(keywords, " \t.,;|/\\", false);
            while (tokenizer.hasMoreTokens()) {
                String keyword = tokenizer.nextToken();
                container.add(NIE.keyword, keyword);
            }
        }
    }

    private void extractExtendedProperties(POIXMLProperties.ExtendedProperties props, RDFContainer container) {
        CTProperties ctProps = props.getUnderlyingProperties();
        this.addExtendedProperty(container, "Application", ctProps.getApplication());
        this.addStringProperty(container, NIE.generator, ctProps.getApplication());
        this.addExtendedProperty(container, "AppVersion", ctProps.getAppVersion());
        if (ctProps.isSetCharacters()) {
            this.addExtendedIntProperty(container, "Characters", ctProps.getCharacters());
        }
        if (ctProps.isSetCharactersWithSpaces()) {
            this.addExtendedIntProperty(container, "CharactersWithSpaces", ctProps.getCharactersWithSpaces());
            container.add(NFO.characterCount, ctProps.getCharactersWithSpaces());
        }
        this.addExtendedProperty(container, "Company", ctProps.getCompany());
        if (ctProps.isSetDocSecurity()) {
            this.addExtendedIntProperty(container, "DocSecurity", ctProps.getDocSecurity());
        }
        if (ctProps.isSetHiddenSlides()) {
            this.addExtendedIntProperty(container, "HiddenSlides", ctProps.getHiddenSlides());
        }
        this.addExtendedProperty(container, "linkBase", ctProps.getHyperlinkBase());
        if (ctProps.isSetHyperlinksChanged()) {
            this.addExtendedBooleanProperty(container, "HyperlinksChanged", ctProps.getHyperlinksChanged());
        }
        if (ctProps.isSetLines()) {
            this.addExtendedIntProperty(container, "Lines", ctProps.getLines());
        }
        if (ctProps.isSetLinksUpToDate()) {
            this.addExtendedBooleanProperty(container, "LinksUpToDate", ctProps.getLinksUpToDate());
        }
        if (ctProps.isSetManager()) {
            URI uri = container.getModel().createURI("http://schemas.openxmlformats.org/officeDocument/2006/extended-properties/Manager");
            this.addContactProperty(container, uri, ctProps.getManager());
            this.addContactProperty(container, NCO.contributor, ctProps.getManager());
        }
        if (ctProps.isSetMMClips()) {
            this.addExtendedIntProperty(container, "MMClips", ctProps.getMMClips());
        }
        if (ctProps.isSetNotes()) {
            this.addExtendedIntProperty(container, "Notes", ctProps.getNotes());
        }
        if (ctProps.isSetPages()) {
            this.addExtendedIntProperty(container, "Pages", ctProps.getPages());
            container.add(RDF.type, NFO.PaginatedTextDocument);
            container.add(NFO.pageCount, ctProps.getPages());
        }
        if (ctProps.isSetParagraphs()) {
            this.addExtendedIntProperty(container, "Paragraphs", ctProps.getParagraphs());
        }
        this.addExtendedProperty(container, "PresentationFormat", ctProps.getPresentationFormat());
        if (ctProps.isSetScaleCrop()) {
            this.addExtendedBooleanProperty(container, "ScaleCrop", ctProps.getScaleCrop());
        }
        if (ctProps.isSetSharedDoc()) {
            this.addExtendedBooleanProperty(container, "SharedDoc", ctProps.getSharedDoc());
        }
        if (ctProps.isSetSlides()) {
            this.addExtendedIntProperty(container, "Slides", ctProps.getSlides());
        }
        this.addExtendedProperty(container, "Template", ctProps.getTemplate());
        this.addStringProperty(container, APERTURE_NIE_EXTENSIONS.template, ctProps.getTemplate());
        if (ctProps.isSetTotalTime()) {
            this.addExtendedIntProperty(container, "TotalTime", ctProps.getTotalTime());
            container.add(APERTURE_NIE_EXTENSIONS.editTime, (long)ctProps.getTotalTime() * 60L * 1000L);
        }
        if (ctProps.isSetWords()) {
            this.addExtendedIntProperty(container, "Words", ctProps.getWords());
            container.add(NFO.wordCount, ctProps.getWords());
        }
    }

    private void addExtendedProperty(RDFContainer container, String propertyName, String value) {
        if (value != null) {
            URI uri = container.getModel().createURI(EXTENDED_PROPERTIES_NS + propertyName);
            container.add(uri, value);
        }
    }

    private void addExtendedIntProperty(RDFContainer container, String propertyName, int value) {
        URI uri = container.getModel().createURI(EXTENDED_PROPERTIES_NS + propertyName);
        container.add(uri, value);
    }

    private void addExtendedBooleanProperty(RDFContainer container, String propertyName, boolean value) {
        URI uri = container.getModel().createURI(EXTENDED_PROPERTIES_NS + propertyName);
        container.add(uri, value);
    }

    private void tryWithOldOpenXmlExtractor(URI id, InputStream stream, Charset charset, String mimeType, RDFContainer container) throws ExtractorException {
        OpenXmlExtractor ex = new OpenXmlExtractor();
        try {
            stream.reset();
            ex.extract(id, stream, charset, mimeType, container);
        }
        catch (ExtractorException e) {
            throw e;
        }
        catch (IOException e) {
            this.logger.warn("Couldn't use the fall-back OpenXmlExtractor", e);
        }
    }

    private void addStringProperty(RDFContainer container, URI predicate, String value) {
        if (value != null) {
            container.add(predicate, value);
        }
    }

    private void addContactProperty(RDFContainer container, URI predicate, String fullname) {
        if (fullname != null) {
            Model model = container.getModel();
            Resource contactResource = ModelUtil.generateRandomResource(model);
            model.addStatement(container.getDescribedUri(), predicate, contactResource);
            model.addStatement(contactResource, RDF.type, NCO.Contact);
            model.addStatement(contactResource, NCO.fullname, fullname);
        }
    }

    private void addDateProperty(RDFContainer container, URI predicate, Date created) {
        if (created != null) {
            container.add(predicate, created);
        }
    }

    private void extractWordMetadata(XWPFDocument document, RDFContainer container) {
        this.extractCommonMetadta(document.getProperties().getCoreProperties(), container);
        this.extractExtendedProperties(document.getProperties().getExtendedProperties(), container);
    }

    private void extractExcelMetadata(XSSFWorkbook document, RDFContainer container) {
        this.extractCommonMetadta(document.getProperties().getCoreProperties(), container);
        this.extractExtendedProperties(document.getProperties().getExtendedProperties(), container);
    }

    private void extractPowerpointMetadata(XSLFSlideShow document, RDFContainer container) {
        this.extractCommonMetadta(document.getProperties().getCoreProperties(), container);
        this.extractExtendedProperties(document.getProperties().getExtendedProperties(), container);
    }

    private static class UncloseableInputStream
    extends FilterInputStream {
        protected UncloseableInputStream(InputStream in) {
            super(in);
        }

        public void close() throws IOException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        WORD,
        EXCEL,
        POWERPOINT;

    }
}

