/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.opendocument;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.semanticdesktop.aperture.extractor.Extractor;
import org.semanticdesktop.aperture.extractor.ExtractorFactory;
import org.semanticdesktop.aperture.extractor.opendocument.OpenDocumentExtractor;

public class OpenDocumentExtractorFactory
implements ExtractorFactory {
    private static final Set MIME_TYPES;

    private static void add(String baseType, Set set) {
        set.add("application/" + baseType);
        set.add("application/" + baseType + "-template");
        set.add("application/x-" + baseType);
        set.add("application/x-" + baseType + "-template");
    }

    public Extractor get() {
        return new OpenDocumentExtractor();
    }

    public Set getSupportedMimeTypes() {
        return MIME_TYPES;
    }

    static {
        HashSet<String> set = new HashSet<String>();
        OpenDocumentExtractorFactory.add("vnd.oasis.opendocument.text", set);
        OpenDocumentExtractorFactory.add("vnd.oasis.opendocument.spreadsheet", set);
        OpenDocumentExtractorFactory.add("vnd.oasis.opendocument.graphics", set);
        OpenDocumentExtractorFactory.add("vnd.oasis.opendocument.presentation", set);
        OpenDocumentExtractorFactory.add("vnd.oasis.opendocument.image", set);
        OpenDocumentExtractorFactory.add("vnd.oasis.opendocument.formula", set);
        OpenDocumentExtractorFactory.add("vnd.oasis.opendocument.chart", set);
        set.add("application/vnd.oasis.opendocument.text-master");
        set.add("application/vnd.oasis.opendocument.text-web");
        set.add("application/x-vnd.oasis.opendocument.text-master");
        set.add("application/x-vnd.oasis.opendocument.text-web");
        set.add("application/vnd.sun.xml.writer");
        set.add("application/vnd.sun.xml.writer.template");
        set.add("application/vnd.sun.xml.writer.global");
        set.add("application/vnd.sun.xml.calc");
        set.add("application/vnd.sun.xml.calc.template");
        set.add("application/vnd.sun.xml.draw");
        set.add("application/vnd.sun.xml.draw.template");
        set.add("application/vnd.sun.xml.impress");
        set.add("application/vnd.sun.xml.impress.template");
        set.add("application/vnd.sun.xml.math");
        set.add("application/x-soffice");
        MIME_TYPES = Collections.unmodifiableSet(set);
    }
}

