/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.opendocument;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.ontoware.rdf2go.exception.ModelException;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.extractor.Extractor;
import org.semanticdesktop.aperture.extractor.ExtractorException;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.rdf.util.ModelUtil;
import org.semanticdesktop.aperture.util.DateUtil;
import org.semanticdesktop.aperture.util.IOUtil;
import org.semanticdesktop.aperture.util.ResourceUtil;
import org.semanticdesktop.aperture.vocabulary.NCO;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.semanticdesktop.aperture.vocabulary.NIE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OpenDocumentExtractor
implements Extractor {
    private static final String END_OF_LINE = System.getProperty("line.separator", "\n");
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String SYSTEM_ID = ResourceUtil.getURL("org/semanticdesktop/aperture/extractor/opendocument/office.dtd", OpenDocumentExtractor.class).toString();

    public void extract(URI id, InputStream stream, Charset charset, String mimeType, RDFContainer result) throws ExtractorException {
        byte[] contentBytes = null;
        byte[] metadataBytes = null;
        try {
            ZipInputStream zipStream = new ZipInputStream(stream);
            ZipEntry entry = null;
            while ((entry = zipStream.getNextEntry()) != null) {
                String entryName = entry.getName();
                if ("content.xml".equals(entryName)) {
                    contentBytes = IOUtil.readBytes(zipStream);
                } else if ("meta.xml".equals(entryName)) {
                    metadataBytes = IOUtil.readBytes(zipStream);
                }
                zipStream.closeEntry();
            }
            zipStream.close();
        }
        catch (IOException e) {
            throw new ExtractorException(e);
        }
        result.add(RDF.type, NFO.Document);
        if (contentBytes != null) {
            this.extractFullText(contentBytes, result);
        }
        if (metadataBytes != null) {
            this.extractMetadata(metadataBytes, result);
        }
    }

    private void extractFullText(byte[] bytes, RDFContainer result) throws ExtractorException {
        SAXParser parser = null;
        try {
            parser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (Exception e) {
            throw new RuntimeException("unable to instantiate SAXParser", e);
        }
        ContentExtractor contentExtractor = new ContentExtractor();
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        try {
            parser.parse((InputStream)stream, contentExtractor, SYSTEM_ID);
        }
        catch (SAXException e) {
            throw new ExtractorException(e);
        }
        catch (IOException e) {
            throw new ExtractorException(e);
        }
        String contents = contentExtractor.getContents();
        if (contents != null && !contents.equals("")) {
            result.add(NIE.plainTextContent, contents);
        }
    }

    private void extractMetadata(byte[] bytes, RDFContainer result) throws ExtractorException {
        Document doc;
        DocumentBuilder docBuilder;
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);
        docBuilderFactory.setValidating(false);
        docBuilderFactory.setExpandEntityReferences(false);
        try {
            docBuilder = docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("unable to instantiate DocumentBuilder", e);
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        try {
            doc = docBuilder.parse(stream, SYSTEM_ID);
        }
        catch (SAXException e) {
            throw new ExtractorException(e);
        }
        catch (IOException e) {
            throw new ExtractorException(e);
        }
        Element rootelement = doc.getDocumentElement();
        Node metaNode = rootelement.getFirstChild();
        NodeList metaChildren = metaNode.getChildNodes();
        int nrChildren = metaChildren.getLength();
        for (int i = 0; i < nrChildren; ++i) {
            Node metaChild = metaChildren.item(i);
            this.addOasisMetadataPropertyToRdfContainer(metaChild, result);
            this.mapToApertureProperty(metaChild, result);
        }
    }

    private void addOasisMetadataPropertyToRdfContainer(Node node, RDFContainer result) {
        String nameSpace = node.getNamespaceURI();
        if (nameSpace != null) {
            if (!nameSpace.endsWith("/")) {
                nameSpace = nameSpace + "/";
            }
            try {
                String uriString = nameSpace + node.getLocalName();
                String text = this.getText(node);
                URI predicate = result.getValueFactory().createURI(uriString);
                if (text != null) {
                    result.add(predicate, text);
                }
            }
            catch (ModelException e) {
                this.logger.error("ModelException while adding statement, ignoring", e);
            }
        }
    }

    private String getText(Node node) {
        if (node instanceof Attr) {
            return ((Attr)node).getValue();
        }
        Node child = node.getFirstChild();
        if (child instanceof Text) {
            return ((Text)child).getWholeText();
        }
        return null;
    }

    private void mapToApertureProperty(Node metaChild, RDFContainer result) {
        block3: {
            NamedNodeMap attributes;
            String name;
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block8: {
                                        block7: {
                                            block6: {
                                                block5: {
                                                    block4: {
                                                        block2: {
                                                            name = metaChild.getNodeName();
                                                            if (!"dc:creator".equals(name)) break block2;
                                                            this.addContactStatement(NCO.creator, metaChild.getFirstChild().getNodeValue(), result);
                                                            break block3;
                                                        }
                                                        if (!"meta:initial-creator".equals(name)) break block4;
                                                        this.addContactStatement(NCO.creator, metaChild.getFirstChild().getNodeValue(), result);
                                                        break block3;
                                                    }
                                                    if (!"dc:title".equals(name)) break block5;
                                                    this.addStatement(NIE.title, metaChild.getFirstChild(), result);
                                                    break block3;
                                                }
                                                if (!"dc:description".equals(name)) break block6;
                                                this.addStatement(NIE.description, metaChild.getFirstChild(), result);
                                                break block3;
                                            }
                                            if (!"dc:subject".equals(name)) break block7;
                                            this.addStatement(NIE.subject, metaChild.getFirstChild(), result);
                                            break block3;
                                        }
                                        if (!"dc:date".equals(name)) break block8;
                                        this.addDateStatement(NIE.informationElementDate, metaChild.getFirstChild(), result);
                                        break block3;
                                    }
                                    if (!"meta:creation-date".equals(name)) break block9;
                                    this.addDateStatement(NIE.contentCreated, metaChild.getFirstChild(), result);
                                    break block3;
                                }
                                if (!"meta:print-date".equals(name)) break block10;
                                this.addDateStatement(NIE.informationElementDate, metaChild.getFirstChild(), result);
                                break block3;
                            }
                            if (!"dc:language".equals(name)) break block11;
                            this.addStatement(NIE.language, metaChild.getFirstChild(), result);
                            break block3;
                        }
                        if (!"meta:generator".equals(name)) break block12;
                        this.addStatement(NIE.generator, metaChild.getFirstChild(), result);
                        break block3;
                    }
                    if ("meta:user-defined".equals(name)) break block3;
                    if (!"meta:keywords".equals(name)) break block13;
                    NodeList keywordNodes = metaChild.getChildNodes();
                    int nrKeywordNodes = keywordNodes.getLength();
                    for (int j = 0; j < nrKeywordNodes; ++j) {
                        Node keywordNode = keywordNodes.item(j);
                        if (!"meta:keyword".equals(keywordNode.getNodeName())) continue;
                        this.addStatement(NIE.keyword, keywordNode.getFirstChild(), result);
                    }
                    break block3;
                }
                if (!"meta:keyword".equals(name)) break block14;
                this.addStatement(NIE.keyword, metaChild.getFirstChild(), result);
                break block3;
            }
            if (!"meta:document-statistic".equals(name) || (attributes = metaChild.getAttributes()) == null) break block3;
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node node = attributes.item(i);
                this.addOasisMetadataPropertyToRdfContainer(node, result);
                if (!(node instanceof Attr)) continue;
                this.mapStatisticsAttributeToApertureProperty((Attr)node, result);
            }
        }
    }

    private void mapStatisticsAttributeToApertureProperty(Attr statisticsAttribute, RDFContainer result) {
        String pageNodeValue;
        String name = statisticsAttribute.getNodeName();
        if ("meta:page-count".equals(name) && (pageNodeValue = statisticsAttribute.getValue()) != null) {
            try {
                int pageCount = Integer.parseInt(pageNodeValue);
                result.add(RDF.type, NFO.PaginatedTextDocument);
                result.add(NFO.pageCount, pageCount);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    private void addStatement(URI uri, Node node, RDFContainer container) {
        if (node != null) {
            this.addStatement(uri, node.getNodeValue(), container);
        }
    }

    private void addStatement(URI uri, String value, RDFContainer container) {
        if (value != null) {
            container.add(uri, value);
        }
    }

    private void addDateStatement(URI uri, Node node, RDFContainer container) {
        String value;
        if (node != null && (value = node.getNodeValue()) != null) {
            try {
                Date date = DateUtil.string2DateTime(value);
                container.add(uri, date);
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
    }

    private void addContactStatement(URI uri, String fullname, RDFContainer container) {
        Model model = container.getModel();
        Resource contactResource = ModelUtil.generateRandomResource(model);
        model.addStatement(contactResource, RDF.type, NCO.Contact);
        model.addStatement(contactResource, NCO.fullname, fullname);
        container.add(uri, contactResource);
    }

    private static class ContentExtractor
    extends DefaultHandler {
        private static final String OFFICE_BODY = "office:body";
        private static final String MATH_MATH = "math:math";
        private static final String TEXT_P = "text:p";
        private static final String TEXT_H = "text:h";
        private final StringBuilder contents = new StringBuilder(4096);
        private boolean insideBody = false;

        private ContentExtractor() {
        }

        public String getContents() {
            return this.contents.toString();
        }

        public void startElement(String uri, String localName, String tagName, Attributes attributes) throws SAXException {
            if (OFFICE_BODY.equals(tagName) || MATH_MATH.equals(tagName)) {
                this.insideBody = true;
            } else if (this.insideBody && TEXT_H.equals(tagName)) {
                this.contents.append(END_OF_LINE);
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.contents.append(ch, start, length);
        }

        public void endElement(String uri, String localName, String tagName) throws SAXException {
            if (OFFICE_BODY.equals(tagName) || MATH_MATH.equals(tagName)) {
                this.insideBody = false;
            } else if (this.insideBody) {
                if (TEXT_H.equals(tagName)) {
                    this.contents.append(END_OF_LINE).append(END_OF_LINE);
                } else if (TEXT_P.equals(tagName)) {
                    this.contents.append(END_OF_LINE);
                }
            }
        }
    }
}

