/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.mp3;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.TimeZone;
import org.jaudiotagger.tag.id3.AbstractID3v2Tag;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.framebody.FrameBodyAPIC;
import org.jaudiotagger.tag.id3.framebody.FrameBodyCOMM;
import org.jaudiotagger.tag.id3.framebody.FrameBodyGEOB;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTALB;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTBPM;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTCOM;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTCON;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTCOP;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTDAT;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTDRC;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTENC;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTEXT;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTFLT;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTIT1;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTIT2;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTIT3;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTKEY;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTLAN;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTLEN;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTMED;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTOAL;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTOFN;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTOLY;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTOPE;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTORY;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTOWN;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTPE1;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTPE2;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTPE3;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTPE4;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTPOS;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTPUB;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTRCK;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTRDA;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTRSN;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTRSO;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTSRC;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTSSE;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTXXX;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTYER;
import org.jaudiotagger.tag.id3.framebody.FrameBodyUFID;
import org.jaudiotagger.tag.id3.framebody.FrameBodyUSLT;
import org.jaudiotagger.tag.id3.framebody.FrameBodyWCOM;
import org.jaudiotagger.tag.id3.framebody.FrameBodyWCOP;
import org.jaudiotagger.tag.id3.framebody.FrameBodyWOAF;
import org.jaudiotagger.tag.id3.framebody.FrameBodyWOAR;
import org.jaudiotagger.tag.id3.framebody.FrameBodyWOAS;
import org.jaudiotagger.tag.id3.framebody.FrameBodyWORS;
import org.jaudiotagger.tag.id3.framebody.FrameBodyWPAY;
import org.jaudiotagger.tag.id3.framebody.FrameBodyWPUB;
import org.jaudiotagger.tag.id3.framebody.FrameBodyWXXX;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.ontoware.rdf2go.vocabulary.RDFS;
import org.ontoware.rdf2go.vocabulary.XSD;
import org.semanticdesktop.aperture.extractor.mp3.Genre;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.rdf.util.ModelUtil;
import org.semanticdesktop.aperture.vocabulary.NCO;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.semanticdesktop.aperture.vocabulary.NID3;
import org.semanticdesktop.aperture.vocabulary.NIE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FrameIdentifier {
    AENC("Audio encryption", false),
    APIC("Attached picture", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            FrameBodyAPIC apic = (FrameBodyAPIC)body;
            Model model = result.getModel();
            Resource resource = ModelUtil.generateRandomResource(model);
            model.addStatement(resource, RDF.type, NFO.Attachment);
            model.addStatement(resource, RDF.type, NFO.Image);
            if (apic.getMimeType() != null && apic.getMimeType().length() > 0) {
                model.addStatement(resource, NIE.mimeType, apic.getMimeType());
            }
            model.addStatement(result.getDescribedUri(), NID3.attachedPicture, resource);
        }
    }
    ,
    COMM("Comments", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            String description = ((FrameBodyCOMM)body).getDescription();
            boolean addDescription = description != null && description.length() > 0;
            String text = ((FrameBodyCOMM)body).getText();
            boolean addText = text != null && text.length() > 0;
            String resultString = (addDescription ? description : "") + (addDescription && addText ? "\n" : "") + (addText ? text : "");
            result.add(NID3.comments, resultString);
            id3v1props.remove(NID3.comments);
        }
    }
    ,
    COMR("Commercial frame", false),
    ENCR("Encryption method registration", false),
    ETCO("Event timing codes", false),
    GEOB("General encapsulated object", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            FrameBodyGEOB apic = (FrameBodyGEOB)body;
            Model model = result.getModel();
            Resource resource = ModelUtil.generateRandomResource(model);
            model.addStatement(resource, RDF.type, NFO.Attachment);
            model.addStatement(resource, RDF.type, NIE.InformationElement);
            model.addStatement(result.getDescribedUri(), NID3.generalEncapsulatedObject, resource);
        }
    }
    ,
    GRID("Group identification registration", false),
    LINK("Linked information", false),
    MCDI("Music CD identifier", false){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
        }
    }
    ,
    MLLT("MPEG location lookup table", false),
    OWNE("Ownership frame", false),
    PRIV("Private frame", false),
    PCNT("Play counter", false),
    POPM("Popularimeter", false),
    POSS("Position synchronisation frame", false),
    RBUF("Recommended buffer size", false),
    RVRB("Reverb", false),
    SYLT("Synchronised lyric/text", false),
    SYTC("Synchronised tempo codes", false),
    TALB("Album/Movie/Show title", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            result.add(NID3.albumTitle, ((FrameBodyTALB)body).getFirstTextValue());
            id3v1props.remove(NID3.albumTitle);
        }
    }
    ,
    TBPM("BPM (beats per minute)", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            result.add(NID3.beatsPerMinute, result.getModel().createDatatypeLiteral(((FrameBodyTBPM)body).getFirstTextValue(), XSD._integer));
        }
    }
    ,
    TCOM("Composer", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            this.addSimpleContact(NID3.composer, ((FrameBodyTCOM)body).getFirstTextValue(), result);
        }
    }
    ,
    TCON("Content type", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            int end;
            String value = ((FrameBodyTCON)body).getFirstTextValue();
            boolean ok = false;
            if (value.startsWith("(") && (end = value.indexOf(41)) != -1) {
                String integerString = value.substring(1, end);
                try {
                    int intValue = Integer.parseInt(integerString);
                    Genre genre = Genre.getGenreByIntId(intValue);
                    if (genre != null) {
                        result.add(NID3.contentType, genre.getName());
                        ok = true;
                    }
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if (!ok) {
                result.add(NID3.contentType, value);
            }
            id3v1props.remove(NID3.contentType);
        }
    }
    ,
    TCOP("Copyright message", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            result.add(NID3.copyrightMessage, ((FrameBodyTCOP)body).getFirstTextValue());
        }
    }
    ,
    TDLY("Playlist delay", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            result.add(NID3.playlistDelay, result.getModel().createDatatypeLiteral(((FrameBodyTBPM)body).getFirstTextValue(), XSD._integer));
        }
    }
    ,
    TENC("Encoded by", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            this.addSimpleContact(NID3.encodedBy, ((FrameBodyTENC)body).getFirstTextValue(), result);
        }
    }
    ,
    TEXT("Lyricist/Text writer", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            this.addSimpleContact(NID3.textWriter, ((FrameBodyTEXT)body).getFirstTextValue(), result);
        }
    }
    ,
    TFLT("File type", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            result.add(NID3.fileType, ((FrameBodyTFLT)body).getFirstTextValue());
        }
    }
    ,
    TIT1("Content group description", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            result.add(NID3.contentGroupDescription, ((FrameBodyTIT1)body).getFirstTextValue());
        }
    }
    ,
    TIT2("Title/songname/content description", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            result.add(NID3.title, ((FrameBodyTIT2)body).getFirstTextValue());
            id3v1props.remove(NID3.title);
        }
    }
    ,
    TIT3("Subtitle/Description refinement", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            result.add(NID3.subtitle, ((FrameBodyTIT3)body).getFirstTextValue());
        }
    }
    ,
    TKEY("Initial key", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            result.add(NID3.initialKey, ((FrameBodyTKEY)body).getFirstTextValue());
        }
    }
    ,
    TLAN("Language(s)", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            result.add(NID3.language, ((FrameBodyTLAN)body).getFirstTextValue());
        }
    }
    ,
    TLEN("Length", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            result.add(NID3.length, ((FrameBodyTLEN)body).getFirstTextValue());
        }
    }
    ,
    TMED("Media type", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            result.add(NID3.mediaType, ((FrameBodyTMED)body).getFirstTextValue());
        }
    }
    ,
    TOAL("Original album/movie/show title", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            result.add(NID3.originalAlbumTitle, ((FrameBodyTOAL)body).getFirstTextValue());
        }
    }
    ,
    TOFN("Original filename", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            result.add(NID3.originalFilename, ((FrameBodyTOFN)body).getFirstTextValue());
        }
    }
    ,
    TOLY("Original lyricist(s)/text writer(s)", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            this.addSimpleContact(NID3.originalTextWriter, ((FrameBodyTOLY)body).getFirstTextValue(), result);
        }
    }
    ,
    TOPE("Original artist(s)/performer(s)", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            this.addSimpleContact(NID3.originalArtist, ((FrameBodyTOPE)body).getFirstTextValue(), result);
        }
    }
    ,
    TOWN("File owner/licensee", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            this.addSimpleContact(NID3.fileOwner, ((FrameBodyTOWN)body).getFirstTextValue(), result);
        }
    }
    ,
    TPE1("Lead performer(s)/Soloist(s)", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            this.addSimpleContact(NID3.leadArtist, ((FrameBodyTPE1)body).getFirstTextValue(), result);
            id3v1props.remove(NID3.leadArtist);
        }
    }
    ,
    TPE2("Band/orchestra/accompaniment", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            this.addSimpleContact(NID3.backgroundArtist, ((FrameBodyTPE2)body).getFirstTextValue(), result);
        }
    }
    ,
    TPE3("Conductor/performer refinement", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            this.addSimpleContact(NID3.conductor, ((FrameBodyTPE3)body).getFirstTextValue(), result);
        }
    }
    ,
    TPE4("Interpreted, remixed, or otherwise modified by", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            this.addSimpleContact(NID3.interpretedBy, ((FrameBodyTPE4)body).getFirstTextValue(), result);
        }
    }
    ,
    TPOS("Part of a set", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            result.add(NID3.partOfSet, ((FrameBodyTPOS)body).getFirstTextValue());
        }
    }
    ,
    TPUB("Publisher", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            this.addSimpleContact(NID3.publisher, ((FrameBodyTPUB)body).getFirstTextValue(), result);
        }
    }
    ,
    TRCK("Track number/Position in set", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            result.add(NID3.trackNumber, ((FrameBodyTRCK)body).getFirstTextValue());
            id3v1props.remove(NID3.trackNumber);
        }
    }
    ,
    TRSN("Internet radio station name", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            result.add(NID3.internetRadioStationName, ((FrameBodyTRSN)body).getFirstTextValue());
        }
    }
    ,
    TRSO("Internet radio station owner", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            this.addSimpleContact(NID3.internetRadioStationOwner, ((FrameBodyTRSO)body).getFirstTextValue(), result);
        }
    }
    ,
    TSRC("ISRC (international standard recording code)", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            result.add(NID3.internationalStandardRecordingCode, ((FrameBodyTSRC)body).getFirstTextValue());
        }
    }
    ,
    TSSE("Software/Hardware and settings used for encoding", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            result.add(NID3.encodingSettings, ((FrameBodyTSSE)body).getFirstTextValue());
        }
    }
    ,
    TXXX("User defined text information frame", false){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            FrameBodyTXXX txxx = (FrameBodyTXXX)body;
            String description = txxx.getDescription();
            String text = txxx.getText();
            Model model = result.getModel();
            Resource resource = ModelUtil.generateRandomResource(model);
            model.addStatement(resource, RDF.type, NID3.UserDefinedFrame);
            model.addStatement(resource, NID3.userDefinedFrameDescription, description);
            model.addStatement(resource, NID3.userDefinedFrameValue, text);
            model.addStatement(result.getDescribedUri(), NID3.userDefinedFrame, resource);
        }
    }
    ,
    UFID("Unique file identifier", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            result.add(NID3.uniqueFileIdentifier, ((FrameBodyUFID)body).getOwner() + "/" + ((FrameBodyUFID)body).getIdentifier());
        }
    }
    ,
    USER("Terms of use", false),
    USLT("Unsynchronised lyric/text transcription", false){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            result.add(NID3.unsynchronizedTextContent, ((FrameBodyUSLT)body).getLyric());
        }
    }
    ,
    WCOM("Commercial information", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            URI resource = result.getModel().createURI(((FrameBodyWCOM)body).getUrlLink());
            result.add(NID3.commercialInformationURL, resource);
            result.getModel().addStatement(resource, RDF.type, RDFS.Resource);
        }
    }
    ,
    WCOP("Copyright/Legal information", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            URI resource = result.getModel().createURI(((FrameBodyWCOP)body).getUrlLink());
            result.add(NID3.copyrightInformationURL, resource);
            result.getModel().addStatement(resource, RDF.type, RDFS.Resource);
        }
    }
    ,
    WOAF("Official audio file webpage", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            URI resource = result.getModel().createURI(((FrameBodyWOAF)body).getUrlLink());
            result.add(NID3.officialFileWebpage, resource);
            result.getModel().addStatement(resource, RDF.type, RDFS.Resource);
        }
    }
    ,
    WOAR("Official artist/performer webpage", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            URI resource = result.getModel().createURI(((FrameBodyWOAR)body).getUrlLink());
            result.add(NID3.officialArtistWebpage, resource);
            result.getModel().addStatement(resource, RDF.type, RDFS.Resource);
        }
    }
    ,
    WOAS("Official audio source webpage", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            URI resource = result.getModel().createURI(((FrameBodyWOAS)body).getUrlLink());
            result.add(NID3.officialAudioSourceWebpage, resource);
            result.getModel().addStatement(resource, RDF.type, RDFS.Resource);
        }
    }
    ,
    WORS("Official Internet radio station homepage", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            URI resource = result.getModel().createURI(((FrameBodyWORS)body).getUrlLink());
            result.add(NID3.officialInternetRadioStationHomepage, resource);
            result.getModel().addStatement(resource, RDF.type, RDFS.Resource);
        }
    }
    ,
    WPAY("Payment", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            URI resource = result.getModel().createURI(((FrameBodyWPAY)body).getUrlLink());
            result.add(NID3.paymentURL, resource);
            result.getModel().addStatement(resource, RDF.type, RDFS.Resource);
        }
    }
    ,
    WPUB("Publishers official webpage", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            URI resource = result.getModel().createURI(((FrameBodyWPUB)body).getUrlLink());
            result.add(NID3.publishersWebpage, resource);
            result.getModel().addStatement(resource, RDF.type, RDFS.Resource);
        }
    }
    ,
    WXXX("User defined URL link frame", false){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            FrameBodyWXXX txxx = (FrameBodyWXXX)body;
            String description = txxx.getDescription();
            String text = txxx.getUrlLink();
            Model model = result.getModel();
            Resource resource = ModelUtil.generateRandomResource(model);
            model.addStatement(resource, RDF.type, NID3.UserDefinedURLFrame);
            model.addStatement(resource, NID3.userDefinedFrameDescription, description);
            model.addStatement(resource, NID3.userDefinedFrameValue, text);
            model.addStatement(result.getDescribedUri(), NID3.userDefinedFrame, resource);
        }
    }
    ,
    ASPI("Audio seek point index", false),
    EQU2("Equalisation (2)", false),
    RVA2("Relative volume adjustment (2)", false),
    SEEK("Seek frame", false),
    SIGN("Signature frame", false),
    TDEN("Encoding time", false),
    TDOR("Original release time", false),
    TDRC("Recording time", false){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            FrameBodyTDRC tdrc = (FrameBodyTDRC)body;
            Date date = this.id3v24timestampToDate(tdrc.getFirstTextValue());
            result.add(NID3.date, date);
        }
    }
    ,
    TDRL("Release time", false),
    TDTG("Tagging time", false),
    TIPL("Involved people list", false),
    TMCL("Musician credits list", false),
    TMOO("Mood", false),
    TPRO("Produced notice", false),
    TSOA("Album sort order", false),
    TSOP("Performer sort order", false),
    TSOT("Title sort order", false),
    TSST("Set subtitle", false),
    EQUA("Equalization", false),
    IPLS("Involved people list", false),
    RVAD("Relative volume adjustment", false),
    TDAT("Date", false){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            FrameBodyTDAT tdat = (FrameBodyTDAT)body;
            String text = tdat.getFirstTextValue();
            if (text.length() == 4) {
                try {
                    int day = Integer.parseInt(text.substring(0, 2));
                    int month = Integer.parseInt(text.substring(2, 4)) - 1;
                    String yearString = id3v2.getFirst(TYER.toString());
                    if (yearString.length() > 0) {
                        int year = Integer.parseInt(yearString);
                        String time = id3v2.getFirst(TIME.toString());
                        if (time.length() > 0) {
                            int hour = Integer.parseInt(text.substring(0, 2));
                            int minute = Integer.parseInt(text.substring(2, 4));
                            GregorianCalendar calendar = new GregorianCalendar(year, month, day, hour, minute);
                            result.add(NID3.date, calendar.getTime());
                        } else {
                            GregorianCalendar calendar = new GregorianCalendar(year, month, day);
                            result.add(NID3.date, calendar.getTime());
                        }
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }
    ,
    TIME("Time", false),
    TORY("Original release year", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            result.add(NID3.originalReleaseYear, result.getModel().createDatatypeLiteral(((FrameBodyTORY)body).getFirstTextValue(), XSD._integer));
        }
    }
    ,
    TRDA("Recording dates", false){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            result.add(NID3.recordingDate, ((FrameBodyTRDA)body).getFirstTextValue());
        }
    }
    ,
    TSIZ("Size", false),
    TYER("Year", true){

        @Override
        public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
            result.add(NID3.recordingYear, result.getModel().createDatatypeLiteral(((FrameBodyTYER)body).getFirstTextValue(), XSD._integer));
            id3v1props.remove(NID3.recordingYear);
        }
    }
    ,
    BUF("Recommended buffer size", false),
    CNT("Play counter", false),
    COM("Comments", false),
    CRA("Audio encryption", false),
    CRM("Encrypted meta frame", false),
    ETC("Event timing codes", false),
    EQU("Equalization", false),
    GEO("General encapsulated object", false),
    IPL("Involved people list", false),
    LNK("Linked information", false),
    MCI("Music CD Identifier", false),
    MLL("MPEG location lookup table", false),
    PIC("Attached picture", false),
    POP("Popularimeter", false),
    REV("Reverb", false),
    RVA("Relative volume adjustment", false),
    SLT("Synchronized lyric/text", false),
    STC("Synced tempo codes", false),
    TAL("Album/Movie/Show title", false),
    TBP("BPM (Beats Per Minute)", false),
    TCM("Composer", false),
    TCO("Content type", false),
    TCR("Copyright message", false),
    TDA("Date", false),
    TDY("Playlist delay", false),
    TEN("Encoded by", false),
    TFT("File type", false),
    TIM("Time", false),
    TKE("Initial key", false),
    TLA("Language(s)", false),
    TLE("Length", false),
    TMT("Media type", false),
    TOA("Original artist(s)/performer(s)", false),
    TOF("Original filename", false),
    TOL("Original Lyricist(s)/text writer(s)", false),
    TOR("Original release year", false),
    TOT("Original album/Movie/Show title", false),
    TP1("Lead artist(s)/Lead performer(s)/Soloist(s)/Performing group", false),
    TP2("Band/Orchestra/Accompaniment", false),
    TP3("Conductor/Performer refinement", false),
    TP4("Interpreted, remixed, or otherwise modified by", false),
    TPA("Part of a set", false),
    TPB("Publisher", false),
    TRC("ISRC (International Standard Recording Code)", false),
    TRD("Recording dates", false),
    TRK("Track number/Position in set", false),
    TSI("Size", false),
    TSS("Software/hardware and settings used for encoding", false),
    TT1("Content group description", false),
    TT2("Title/Songname/Content description", false),
    TT3("Subtitle/Description refinement", false),
    TXT("Lyricist/text writer", false),
    TXX("User defined text information frame", false),
    TYE("Year", false),
    UFI("Unique file identifier", false),
    ULT("Unsychronized lyric/text transcription", false),
    WAF("Official audio file webpage", false),
    WAR("Official artist/performer webpage", false),
    WAS("Official audio source webpage", false),
    WCM("Commercial information", false),
    WCP("Copyright/Legal information", false),
    WPB("Publishers official webpage", false),
    WXX("User defined URL link frame", false);

    private String name;
    private boolean isSupported;

    private FrameIdentifier(String name, boolean isSupported) {
        this.name = name;
        this.isSupported = isSupported;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSupported() {
        return this.isSupported;
    }

    public void process(AbstractTagFrameBody body, AbstractID3v2Tag id3v2, HashMap<URI, String> id3v1props, RDFContainer result) {
    }

    protected void addSimpleContact(URI property, String fullname, RDFContainer container) {
        Model model = container.getModel();
        Resource resource = ModelUtil.generateRandomResource(model);
        model.addStatement(resource, RDF.type, NCO.Contact);
        model.addStatement(resource, NCO.fullname, fullname);
        model.addStatement(container.getDescribedUri(), property, resource);
    }

    protected Date id3v24timestampToDate(String timestamp) {
        GregorianCalendar result = new GregorianCalendar(TimeZone.getTimeZone("asdfasdfasd"));
        result.set(0, 0, 1, 0, 0, 0);
        result.set(1, Integer.parseInt(timestamp.substring(0, 4)));
        if (timestamp.length() == 4) {
            return result.getTime();
        }
        result.set(2, Integer.parseInt(timestamp.substring(5, 2)) - 1);
        if (timestamp.length() == 7) {
            return result.getTime();
        }
        result.set(5, Integer.parseInt(timestamp.substring(8, 2)));
        if (timestamp.length() == 10) {
            return result.getTime();
        }
        result.set(10, Integer.parseInt(timestamp.substring(11, 2)));
        if (timestamp.length() == 13) {
            return result.getTime();
        }
        result.set(12, Integer.parseInt(timestamp.substring(14, 2)));
        if (timestamp.length() == 16) {
            return result.getTime();
        }
        result.set(13, Integer.parseInt(timestamp.substring(17, 2)));
        return result.getTime();
    }
}

