/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.mime;

import java.util.Date;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import org.ontoware.rdf2go.exception.ModelException;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.node.Literal;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.rdf.util.ModelUtil;
import org.semanticdesktop.aperture.vocabulary.NCO;
import org.semanticdesktop.aperture.vocabulary.NMO;

public class MailUtil {
    public static void getDates(Message message, RDFContainer container) throws MessagingException {
        Date receivedDate;
        Date sentDate = message.getSentDate();
        if (sentDate != null) {
            container.add(NMO.sentDate, sentDate);
        }
        if ((receivedDate = message.getReceivedDate()) != null) {
            container.add(NMO.receivedDate, receivedDate);
        }
        if (sentDate == null && receivedDate == null) {
            container.add(NMO.receivedDate, new Date());
        }
    }

    public static void addAddressMetadata(InternetAddress address, URI predicate, RDFContainer metadata) throws ModelException {
        String emailAddress;
        String name = address.getPersonal();
        if (name != null) {
            name = name.trim();
        }
        if ((emailAddress = address.getAddress()) != null) {
            emailAddress = emailAddress.trim();
        }
        if (MailUtil.hasRealValue(name) || MailUtil.hasRealValue(emailAddress)) {
            Literal literal;
            Model model = metadata.getModel();
            URI contact = model.createURI(MailUtil.getPersonURI(emailAddress, name));
            model.addStatement(contact, RDF.type, NCO.Contact);
            if (MailUtil.hasRealValue(name)) {
                literal = metadata.getValueFactory().createLiteral(name);
                model.addStatement(contact, NCO.fullname, literal);
            }
            if (MailUtil.hasRealValue(emailAddress)) {
                literal = metadata.getValueFactory().createLiteral(emailAddress);
                Resource emailResource = ModelUtil.generateRandomResource(model);
                model.addStatement(contact, NCO.hasEmailAddress, emailResource);
                model.addStatement(emailResource, RDF.type, NCO.EmailAddress);
                model.addStatement(emailResource, NCO.emailAddress, literal);
            }
            metadata.add(predicate, contact);
        }
    }

    public static String getPersonURI(String email, String name) throws IllegalArgumentException {
        if (MailUtil.hasRealValue(email)) {
            return "email:" + email;
        }
        if (MailUtil.hasRealValue(name)) {
            return "emailperson:" + name;
        }
        throw new IllegalArgumentException("no valid email or name, email = " + email + ", name = " + name);
    }

    private static boolean hasRealValue(String string) {
        return string != null && string.length() > 0;
    }
}

