/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.impl;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.semanticdesktop.aperture.extractor.ExtractorFactory;
import org.semanticdesktop.aperture.extractor.FileExtractorFactory;
import org.semanticdesktop.aperture.extractor.impl.ExtractorRegistryImpl;
import org.semanticdesktop.aperture.util.ResourceUtil;
import org.semanticdesktop.aperture.util.SimpleSAXAdapter;
import org.semanticdesktop.aperture.util.SimpleSAXParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class DefaultExtractorRegistry
extends ExtractorRegistryImpl {
    private static final String DEFAULT_FILE = "org/semanticdesktop/aperture/extractor/impl/defaults.xml";
    private static final String EXTRACTOR_FACTORY_TAG = "extractorFactory";
    private static final String NAME_TAG = "name";

    public DefaultExtractorRegistry() {
        try {
            InputStream stream = ResourceUtil.getInputStream(DEFAULT_FILE, DefaultExtractorRegistry.class);
            BufferedInputStream buffer = new BufferedInputStream(stream);
            this.parse(buffer);
            buffer.close();
        }
        catch (IOException e) {
            throw new RuntimeException("unable to parse org/semanticdesktop/aperture/extractor/impl/defaults.xml", e);
        }
    }

    public DefaultExtractorRegistry(InputStream stream) throws IOException {
        this.parse(stream);
    }

    private void parse(InputStream stream) throws IOException {
        try {
            SimpleSAXParser parser = new SimpleSAXParser();
            parser.setListener(new ExtractorParser());
            parser.parse(stream);
        }
        catch (ParserConfigurationException e) {
            IOException ie = new IOException(e.getMessage());
            ie.initCause(e);
            throw ie;
        }
        catch (SAXException e) {
            IOException ie = new IOException(e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }

    private class ExtractorParser
    extends SimpleSAXAdapter {
        private Logger logger = LoggerFactory.getLogger(this.getClass());
        private boolean insideFactoryElement = false;

        private ExtractorParser() {
        }

        public void startTag(String tagName, Map atts, String text) throws SAXException {
            if (DefaultExtractorRegistry.EXTRACTOR_FACTORY_TAG.equals(tagName)) {
                this.insideFactoryElement = true;
            } else if (DefaultExtractorRegistry.NAME_TAG.equals(tagName) && this.insideFactoryElement && text != null) {
                this.processClassName(text);
            }
        }

        public void endTag(String tagName) {
            if (DefaultExtractorRegistry.EXTRACTOR_FACTORY_TAG.equals(tagName)) {
                this.insideFactoryElement = false;
            }
        }

        private void processClassName(String className) {
            if (!(className = className.trim()).equals("")) {
                try {
                    Class<?> clazz = Class.forName(className);
                    Object instance = clazz.newInstance();
                    if (instance instanceof ExtractorFactory) {
                        ExtractorFactory factory = (ExtractorFactory)instance;
                        DefaultExtractorRegistry.this.add(factory);
                    } else if (instance instanceof FileExtractorFactory) {
                        FileExtractorFactory factory = (FileExtractorFactory)instance;
                        DefaultExtractorRegistry.this.add(factory);
                    }
                }
                catch (ClassNotFoundException e) {
                    this.logger.warn("unable to find class " + className + ", ignoring", e);
                }
                catch (InstantiationException e) {
                    this.logger.warn("unable to instantiate class " + className + ", ignoring", e);
                }
                catch (IllegalAccessException e) {
                    this.logger.warn("unable to access class " + className + ", ignoring", e);
                }
                catch (ClassCastException e) {
                    this.logger.warn("unable to cast instance to " + ExtractorFactory.class.getName() + ", ignoring", e);
                }
            }
        }
    }
}

