/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.excel;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.FooterRecord;
import org.apache.poi.hssf.record.HeaderRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NameRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.hssf.record.chart.SeriesTextRecord;
import org.apache.poi.hssf.record.common.UnicodeString;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.extractor.Extractor;
import org.semanticdesktop.aperture.extractor.ExtractorException;
import org.semanticdesktop.aperture.extractor.microsoft.util.PoiUtil;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelExtractor
implements Extractor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String END_OF_LINE = System.getProperty("line.separator", "\n");

    public void extract(URI id, InputStream stream, Charset charset, String mimeType, RDFContainer result) throws ExtractorException {
        PoiUtil.extractAll(stream, new ExcelTextExtractor(), result, this.logger);
        result.add(RDF.type, NFO.Spreadsheet);
    }

    public static String getText(DirectoryNode dirNode, POIFSFileSystem fs) throws IOException {
        DocumentInputStream docStream = dirNode.createDocumentInputStream("Workbook");
        HSSFRequest request = new HSSFRequest();
        ExcelEventListener listener = new ExcelEventListener();
        request.addListener((HSSFListener)listener, (short)133);
        request.addListener((HSSFListener)listener, (short)515);
        request.addListener((HSSFListener)listener, (short)252);
        request.addListener((HSSFListener)listener, (short)253);
        request.addListener((HSSFListener)listener, (short)519);
        request.addListener((HSSFListener)listener, (short)20);
        request.addListener((HSSFListener)listener, (short)21);
        request.addListener((HSSFListener)listener, (short)24);
        request.addListener((HSSFListener)listener, (short)4109);
        HSSFEventFactory factory = new HSSFEventFactory();
        factory.processEvents(request, (InputStream)docStream);
        docStream.close();
        return listener.getText();
    }

    private static class ExcelEventListener
    implements HSSFListener {
        private SSTRecord sstrec;
        private final StringBuilder buffer = new StringBuilder(65536);

        private ExcelEventListener() {
        }

        public void processRecord(Record record) {
            switch (record.getSid()) {
                case 133: {
                    BoundSheetRecord bsr = (BoundSheetRecord)record;
                    String sheetName = bsr.getSheetname();
                    if (sheetName == null) break;
                    this.buffer.append(END_OF_LINE);
                    this.buffer.append(sheetName);
                    this.buffer.append(END_OF_LINE);
                    this.buffer.append(END_OF_LINE);
                    break;
                }
                case 515: {
                    NumberRecord numrec = (NumberRecord)record;
                    this.buffer.append(numrec.getValue());
                    this.buffer.append(' ');
                    break;
                }
                case 252: {
                    this.sstrec = (SSTRecord)record;
                    break;
                }
                case 253: {
                    UnicodeString uString;
                    LabelSSTRecord lrec = (LabelSSTRecord)record;
                    if (this.sstrec == null || (uString = this.sstrec.getString(lrec.getSSTIndex())) == null) break;
                    this.append(uString.toString(), this.buffer);
                    break;
                }
                case 519: {
                    StringRecord sRecord = (StringRecord)record;
                    this.append(sRecord.getString(), this.buffer);
                    break;
                }
                case 20: {
                    HeaderRecord hRecord = (HeaderRecord)record;
                    this.append(hRecord.getText(), this.buffer);
                    break;
                }
                case 21: {
                    FooterRecord fRecord = (FooterRecord)record;
                    this.append(fRecord.getText(), this.buffer);
                    break;
                }
                case 24: {
                    NameRecord nRecord = (NameRecord)record;
                    this.append(nRecord.getNameText(), this.buffer);
                    this.append(nRecord.getDescriptionText(), this.buffer);
                    break;
                }
                case 4109: {
                    SeriesTextRecord stRecord = (SeriesTextRecord)record;
                    this.append(stRecord.getText(), this.buffer);
                }
            }
        }

        private void append(String string, StringBuilder buffer) {
            if (string != null) {
                buffer.append(string);
                buffer.append(' ');
            }
        }

        public String getText() {
            return this.buffer.toString().trim();
        }
    }

    private static class ExcelTextExtractor
    implements PoiUtil.TextExtractor {
        private ExcelTextExtractor() {
        }

        public String getText(DirectoryNode dirNode, POIFSFileSystem fs) throws IOException {
            return ExcelExtractor.getText(dirNode, fs);
        }
    }
}

