/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.corel.util;

import java.io.IOException;
import java.io.InputStream;
import org.semanticdesktop.aperture.extractor.corel.util.WPFilterInputStream;
import org.semanticdesktop.aperture.util.StringExtractor;

public class WPStringExtractor
extends StringExtractor {
    private static final String[] EXACT_START_LINES = new String[]{"doc init", "tech init"};
    private static final String[] START_EXCLUDES = new String[]{"wpc", "monotype sorts", "section", "columns", "aligned ", "standard", "default ", "biblio", "footnote", "gfootnote", "endnote", "heading", "header for ", "underlined heading", "centered heading", "technical", "object #", "microsoft word"};
    private static final String[] END_EXCLUDES = new String[]{"aligned paragraph numbers", "heading", "bullet list"};
    private static final String[] EXACT_EXCLUDES = new String[]{"nlus.", "usjp", "initialize technical style", "document style", "pleading", "times", "and", "where", "left", "right", "over", "(k over", "document", "header", "footer", "itemize", "page number", "pages", "body text", "word", "sjablone", "d printer"};
    private static final String[] CONTAIN_EXCLUDES = new String[]{"left (", "right )", "right ]", "right par", "default paragraph"};

    public String extract(InputStream stream) throws IOException {
        return super.extract(new WPFilterInputStream(stream));
    }

    protected boolean isTextCharacter(int charNumber) {
        return super.isTextCharacter(charNumber) || charNumber >= 192 && charNumber <= 255 || charNumber == 145 || charNumber == 146;
    }

    protected boolean isStartLine(String lineLowerCase) {
        for (int i = 0; i < EXACT_START_LINES.length; ++i) {
            if (!lineLowerCase.equals(EXACT_START_LINES[i])) continue;
            return true;
        }
        return false;
    }

    protected boolean isValidLine(String lineLowerCase) {
        int i;
        for (i = 0; i < EXACT_EXCLUDES.length; ++i) {
            if (!lineLowerCase.equals(EXACT_EXCLUDES[i])) continue;
            return false;
        }
        for (i = 0; i < START_EXCLUDES.length; ++i) {
            if (!lineLowerCase.startsWith(START_EXCLUDES[i])) continue;
            return false;
        }
        for (i = 0; i < END_EXCLUDES.length; ++i) {
            if (!lineLowerCase.endsWith(END_EXCLUDES[i])) continue;
            return false;
        }
        for (i = 0; i < CONTAIN_EXCLUDES.length; ++i) {
            if (lineLowerCase.indexOf(CONTAIN_EXCLUDES[i]) < 0) continue;
            return false;
        }
        return super.isValidLine(lineLowerCase);
    }
}

