/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.detector.filesystem;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.ontoware.rdf2go.RDF2Go;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.node.URI;
import org.semanticdesktop.aperture.datasource.config.DomainBoundaries;
import org.semanticdesktop.aperture.datasource.config.RegExpPattern;
import org.semanticdesktop.aperture.datasource.config.UrlPattern;
import org.semanticdesktop.aperture.datasource.filesystem.FILESYSTEMDS;
import org.semanticdesktop.aperture.datasource.filesystem.FileSystemDataSource;
import org.semanticdesktop.aperture.detector.DataSourceDescription;
import org.semanticdesktop.aperture.detector.DataSourceDetector;
import org.semanticdesktop.aperture.rdf.impl.RDFContainerImpl;
import org.semanticdesktop.aperture.rdf.util.ModelUtil;
import org.semanticdesktop.aperture.util.OSUtils;
import org.semanticdesktop.aperture.util.RegistryReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HomeFolderDetector
implements DataSourceDetector {
    private List<UrlPattern> getExcludes() {
        Vector<UrlPattern> res = new Vector<UrlPattern>();
        res.add(new RegExpPattern("^\\.svn"));
        return res;
    }

    private String getWinDir() {
        return RegistryReader.getCurrentUserPersonalFolderPath();
    }

    private String getMacDir() {
        return System.getProperty("user.home") + File.separator + "Documents";
    }

    private String getLinuxDir() {
        String home = System.getProperty("user.home");
        File f = new File(home + File.separator + "Documents");
        if (f.exists()) {
            return f.getAbsolutePath();
        }
        return home;
    }

    @Override
    public List<DataSourceDescription> detect() throws Exception {
        String path;
        if (OSUtils.isLinux()) {
            path = this.getLinuxDir();
        } else if (OSUtils.isMac()) {
            path = this.getMacDir();
        } else if (OSUtils.isWindows()) {
            path = this.getWinDir();
        } else {
            throw new Exception("Cannot detect your home-folder on your operating system: " + System.getProperty("os.name") + ". Linux, windows, mac are supported, please add your document folder manually.");
        }
        FileSystemDataSource ds = new FileSystemDataSource();
        Model m = RDF2Go.getModelFactory().createModel();
        m.open();
        URI id = ModelUtil.generateRandomURI(m);
        ds.setConfiguration(new RDFContainerImpl(m, id));
        ds.setName("My Documents");
        ds.setComment("This datasource will crawl your files from the folder " + path);
        ds.setRootFolder(path);
        ds.setDomainBoundaries(new DomainBoundaries(Collections.EMPTY_LIST, this.getExcludes()));
        ArrayList<DataSourceDescription> result = new ArrayList<DataSourceDescription>(1);
        result.add(new DataSourceDescription(ds));
        return result;
    }

    @Override
    public URI getSupportedType() {
        return FILESYSTEMDS.FileSystemDataSource;
    }
}

