/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.datasource.impl;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.semanticdesktop.aperture.datasource.DataSourceFactory;
import org.semanticdesktop.aperture.datasource.impl.DataSourceRegistryImpl;
import org.semanticdesktop.aperture.util.ResourceUtil;
import org.semanticdesktop.aperture.util.SimpleSAXAdapter;
import org.semanticdesktop.aperture.util.SimpleSAXParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class DefaultDataSourceRegistry
extends DataSourceRegistryImpl {
    private static final String DEFAULT_FILE = "org/semanticdesktop/aperture/datasource/impl/defaults.xml";
    private static final String SOURCE_FACTORY_TAG = "dataSourceFactory";
    private static final String NAME_TAG = "name";

    public DefaultDataSourceRegistry() {
        try {
            InputStream stream = ResourceUtil.getInputStream(DEFAULT_FILE, DefaultDataSourceRegistry.class);
            BufferedInputStream buffer = new BufferedInputStream(stream);
            this.parse(buffer);
            buffer.close();
        }
        catch (IOException e) {
            throw new RuntimeException("unable to parse org/semanticdesktop/aperture/datasource/impl/defaults.xml", e);
        }
    }

    public DefaultDataSourceRegistry(InputStream stream) throws IOException {
        this.parse(stream);
    }

    private void parse(InputStream stream) throws IOException {
        try {
            SimpleSAXParser parser = new SimpleSAXParser();
            parser.setListener(new DataSourceParser());
            parser.parse(stream);
        }
        catch (ParserConfigurationException e) {
            IOException ie = new IOException(e.getMessage());
            ie.initCause(e);
            throw ie;
        }
        catch (SAXException e) {
            IOException ie = new IOException(e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }

    private class DataSourceParser
    extends SimpleSAXAdapter {
        private Logger logger = LoggerFactory.getLogger(this.getClass());
        private boolean insideFactoryElement = false;

        private DataSourceParser() {
        }

        public void startTag(String tagName, Map atts, String text) throws SAXException {
            if (DefaultDataSourceRegistry.SOURCE_FACTORY_TAG.equals(tagName)) {
                this.insideFactoryElement = true;
            } else if (DefaultDataSourceRegistry.NAME_TAG.equals(tagName) && this.insideFactoryElement && text != null) {
                this.processClassName(text);
            }
        }

        public void endTag(String tagName) {
            if (DefaultDataSourceRegistry.SOURCE_FACTORY_TAG.equals(tagName)) {
                this.insideFactoryElement = false;
            }
        }

        private void processClassName(String className) {
            if (!(className = className.trim()).equals("")) {
                try {
                    Class<?> clazz = Class.forName(className);
                    Object instance = clazz.newInstance();
                    DataSourceFactory factory = (DataSourceFactory)instance;
                    DefaultDataSourceRegistry.this.add(factory);
                }
                catch (ClassNotFoundException e) {
                    this.logger.warn("unable to find class " + className + ", ignoring", e);
                }
                catch (InstantiationException e) {
                    this.logger.warn("unable to instantiate class " + className + ", ignoring", e);
                }
                catch (IllegalAccessException e) {
                    this.logger.warn("unable to access class " + className + ", ignoring", e);
                }
                catch (ClassCastException e) {
                    this.logger.warn("unable to cast instance to " + DataSourceFactory.class.getName() + ", ignoring", e);
                }
            }
        }
    }
}

