/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.datasource.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.node.URI;
import org.semanticdesktop.aperture.datasource.DataSourceFactory;
import org.semanticdesktop.aperture.datasource.DataSourceRegistry;
import org.semanticdesktop.aperture.vocabulary.DATASOURCE;
import org.semanticdesktop.aperture.vocabulary.SOURCEFORMAT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceRegistryImpl
implements DataSourceRegistry {
    private HashMap factories = new HashMap();

    public void add(DataSourceFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory is not allowed to be null");
        }
        URI type = factory.getSupportedType();
        HashSet<DataSourceFactory> factorySet = (HashSet<DataSourceFactory>)this.factories.get(type);
        if (factorySet == null) {
            factorySet = new HashSet<DataSourceFactory>();
            this.factories.put(type, factorySet);
        }
        factorySet.add(factory);
    }

    public void remove(DataSourceFactory factory) {
        URI type = factory.getSupportedType();
        Set factorySet = (Set)this.factories.get(type);
        if (factorySet != null) {
            factorySet.remove(factory);
            if (factorySet.isEmpty()) {
                this.factories.remove(type);
            }
        }
    }

    public Set get(URI type) {
        Set factorySet = (Set)this.factories.get(type);
        if (factorySet == null) {
            return Collections.EMPTY_SET;
        }
        return new HashSet(factorySet);
    }

    public Set getAll() {
        HashSet result = new HashSet();
        for (Set factorySet : this.factories.values()) {
            result.addAll(factorySet);
        }
        return result;
    }

    public void getDataSourceOntologyAndDescriptions(Model model) {
        try {
            SOURCEFORMAT.getSOURCEFORMATOntology(model);
            DATASOURCE.getDATASOURCEOntology(model);
            for (Set set : this.factories.values()) {
                for (Object factoryObject : set) {
                    DataSourceFactory factory = (DataSourceFactory)factoryObject;
                    factory.getDescription(model);
                }
            }
        }
        catch (Exception me) {
            Logger logger = LoggerFactory.getLogger(this.getClass());
            logger.error("Could not get data source ontology and descriptions", me);
        }
    }
}

