/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.datasource.imap;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.URI;
import org.semanticdesktop.aperture.datasource.config.DomainBoundableDataSource;
import org.semanticdesktop.aperture.datasource.imap.IMAPDS;
import org.semanticdesktop.aperture.rdf.util.ModelUtil;
import org.semanticdesktop.aperture.vocabulary.DATASOURCE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImapDataSource
extends DomainBoundableDataSource {
    @Override
    public URI getType() {
        return IMAPDS.ImapDataSource;
    }

    public String getHostname() {
        return this.getConfiguration().getString(IMAPDS.hostname);
    }

    public void setHostname(String hostname) {
        if (hostname == null) {
            this.getConfiguration().remove(IMAPDS.hostname);
        } else {
            this.getConfiguration().put(IMAPDS.hostname, hostname);
        }
    }

    public Integer getPort() {
        return this.getConfiguration().getInteger(IMAPDS.port);
    }

    public void setPort(Integer port) {
        if (port == null) {
            this.getConfiguration().remove(IMAPDS.port);
        } else {
            this.getConfiguration().put(IMAPDS.port, port);
        }
    }

    public String getUsername() {
        return this.getConfiguration().getString(DATASOURCE.username);
    }

    public void setUsername(String username) {
        if (username == null) {
            this.getConfiguration().remove(DATASOURCE.username);
        } else {
            this.getConfiguration().put(DATASOURCE.username, username);
        }
    }

    public String getPassword() {
        return this.getConfiguration().getString(DATASOURCE.password);
    }

    public void setPassword(String password) {
        if (password == null) {
            this.getConfiguration().remove(DATASOURCE.password);
        } else {
            this.getConfiguration().put(DATASOURCE.password, password);
        }
    }

    public Collection<String> getAllBasepaths() {
        Collection collection = this.getConfiguration().getAll(IMAPDS.basepath);
        LinkedList<String> result = new LinkedList<String>();
        for (Node node : collection) {
            String object = (String)ModelUtil.convertNode(node, String.class);
            if (object == null) continue;
            result.add(object);
        }
        return result;
    }

    public void setBasepath(String basepath) {
        if (basepath == null) {
            this.getConfiguration().remove(IMAPDS.basepath);
        } else {
            this.getConfiguration().put(IMAPDS.basepath, basepath);
        }
    }

    public void setAllBasepaths(List<String> basepath) {
        if (basepath == null) {
            ModelUtil.removeAllPropertyValues(this.getConfiguration().getModel(), this.getConfiguration().getDescribedUri(), IMAPDS.basepath);
        } else {
            ModelUtil.removeAllPropertyValues(this.getConfiguration().getModel(), this.getConfiguration().getDescribedUri(), IMAPDS.basepath);
            for (String value : basepath) {
                this.getConfiguration().add(IMAPDS.basepath, value);
            }
        }
    }

    public Boolean getIncludeInbox() {
        return this.getConfiguration().getBoolean(IMAPDS.includeInbox);
    }

    public void setIncludeInbox(Boolean includeInbox) {
        if (includeInbox == null) {
            this.getConfiguration().remove(IMAPDS.includeInbox);
        } else {
            this.getConfiguration().put(IMAPDS.includeInbox, includeInbox);
        }
    }

    public Long getMaximumSize() {
        return this.getConfiguration().getLong(IMAPDS.maximumSize);
    }

    public void setMaximumSize(Long maximumSize) {
        if (maximumSize == null) {
            this.getConfiguration().remove(IMAPDS.maximumSize);
        } else {
            this.getConfiguration().put(IMAPDS.maximumSize, maximumSize);
        }
    }

    public Integer getMaximumDepth() {
        return this.getConfiguration().getInteger(IMAPDS.maximumDepth);
    }

    public void setMaximumDepth(Integer maximumDepth) {
        if (maximumDepth == null) {
            this.getConfiguration().remove(IMAPDS.maximumDepth);
        } else {
            this.getConfiguration().put(IMAPDS.maximumDepth, maximumDepth);
        }
    }

    public Boolean getIgnoreUidValidity() {
        return this.getConfiguration().getBoolean(IMAPDS.ignoreUidValidity);
    }

    public void setIgnoreUidValidity(Boolean ignoreUidValidity) {
        if (ignoreUidValidity == null) {
            this.getConfiguration().remove(IMAPDS.ignoreUidValidity);
        } else {
            this.getConfiguration().put(IMAPDS.ignoreUidValidity, ignoreUidValidity);
        }
    }

    public ConnectionSecurity getConnectionSecurity() {
        return ConnectionSecurity.fromUri(this.getConfiguration().getURI(IMAPDS.connectionSecurity));
    }

    public void setConnectionSecurity(ConnectionSecurity connectionSecurity) {
        if (connectionSecurity == null) {
            this.getConfiguration().remove(IMAPDS.connectionSecurity);
        } else {
            this.getConfiguration().put(IMAPDS.connectionSecurity, connectionSecurity.toUri());
        }
    }

    public String getSslFileName() {
        return this.getConfiguration().getString(IMAPDS.sslFileName);
    }

    public void setSslFileName(String sslFileName) {
        if (sslFileName == null) {
            this.getConfiguration().remove(IMAPDS.sslFileName);
        } else {
            this.getConfiguration().put(IMAPDS.sslFileName, sslFileName);
        }
    }

    public String getSslFilePassword() {
        return this.getConfiguration().getString(IMAPDS.sslFilePassword);
    }

    public void setSslFilePassword(String sslFilePassword) {
        if (sslFilePassword == null) {
            this.getConfiguration().remove(IMAPDS.sslFilePassword);
        } else {
            this.getConfiguration().put(IMAPDS.sslFilePassword, sslFilePassword);
        }
    }

    public Boolean getUseHeadersHash() {
        return this.getConfiguration().getBoolean(IMAPDS.useHeadersHash);
    }

    public void setUseHeadersHash(Boolean useHeadersHash) {
        if (useHeadersHash == null) {
            this.getConfiguration().remove(IMAPDS.useHeadersHash);
        } else {
            this.getConfiguration().put(IMAPDS.useHeadersHash, useHeadersHash);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConnectionSecurity {
        PLAIN,
        SSL,
        SSL_NO_CERT;


        public static ConnectionSecurity fromUri(URI uri) {
            if (uri == null) {
                return null;
            }
            if (uri.equals(IMAPDS.PLAIN)) {
                return PLAIN;
            }
            if (uri.equals(IMAPDS.SSL)) {
                return SSL;
            }
            if (uri.equals(IMAPDS.SSL_NO_CERT)) {
                return SSL_NO_CERT;
            }
            return null;
        }

        public URI toUri() {
            if (this.equals((Object)PLAIN)) {
                return IMAPDS.PLAIN;
            }
            if (this.equals((Object)SSL)) {
                return IMAPDS.SSL;
            }
            if (this.equals((Object)SSL_NO_CERT)) {
                return IMAPDS.SSL_NO_CERT;
            }
            return null;
        }
    }
}

