/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.datasource.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.semanticdesktop.aperture.datasource.config.UrlPattern;

public class DomainBoundaries {
    private ArrayList includePatterns;
    private ArrayList excludePatterns;

    public DomainBoundaries() {
        this(new ArrayList(1), new ArrayList(1));
    }

    public DomainBoundaries(List includePatterns, List excludePatterns) {
        this.includePatterns = new ArrayList(includePatterns);
        this.excludePatterns = new ArrayList(excludePatterns);
    }

    public void addIncludePattern(UrlPattern pattern) {
        this.includePatterns.add(pattern);
    }

    public boolean removeIncludePattern(UrlPattern pattern) {
        return this.includePatterns.remove(pattern);
    }

    public void removeAllIncludePatterns() {
        this.includePatterns.clear();
    }

    public List getIncludePatterns() {
        return Collections.unmodifiableList(this.includePatterns);
    }

    public void setIncludePatterns(List includePatterns) {
        this.includePatterns = new ArrayList(includePatterns);
    }

    public void addExcludePattern(UrlPattern pattern) {
        this.excludePatterns.add(pattern);
    }

    public boolean removeExcludePattern(UrlPattern pattern) {
        return this.excludePatterns.remove(pattern);
    }

    public void removeAllExcludePatterns() {
        this.excludePatterns.clear();
    }

    public List getExcludePatterns() {
        return Collections.unmodifiableList(this.excludePatterns);
    }

    public void setExcludePatterns(List excludePatterns) {
        this.excludePatterns = new ArrayList(excludePatterns);
    }

    public void removeAllPatterns() {
        this.removeAllIncludePatterns();
        this.removeAllExcludePatterns();
    }

    public boolean inDomain(String url) {
        UrlPattern pattern;
        boolean insideDomain = false;
        int nrIncludePatterns = this.includePatterns.size();
        if (nrIncludePatterns == 0) {
            insideDomain = true;
        } else {
            for (int i = 0; i < nrIncludePatterns; ++i) {
                pattern = (UrlPattern)this.includePatterns.get(i);
                if (!pattern.matches(url)) continue;
                insideDomain = true;
                break;
            }
        }
        if (insideDomain) {
            int nrExcludePatterns = this.excludePatterns.size();
            for (int i = 0; i < nrExcludePatterns; ++i) {
                pattern = (UrlPattern)this.excludePatterns.get(i);
                if (!pattern.matches(url)) continue;
                insideDomain = false;
                break;
            }
        }
        return insideDomain;
    }
}

