/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.crawler.mbox;

import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.URLName;
import javax.mail.internet.MimeMessage;
import net.fortuna.mstor.util.CapabilityHints;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.semanticdesktop.aperture.accessor.AccessData;
import org.semanticdesktop.aperture.accessor.UrlNotFoundException;
import org.semanticdesktop.aperture.crawler.ExitCode;
import org.semanticdesktop.aperture.crawler.mail.AbstractJavaMailCrawler;
import org.semanticdesktop.aperture.crawler.mail.MailUtil;
import org.semanticdesktop.aperture.datasource.DataSource;
import org.semanticdesktop.aperture.datasource.mbox.MboxDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MboxCrawler
extends AbstractJavaMailCrawler {
    private static final String MBOX_URL_SCHEME = "mbox:";
    private static final String MSTOR_PROVIDER_PATH_PREFX = "mstor:";
    private static final String SIZE_KEY = "size";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private MboxDataSource configuredDataSource;
    private URLName mboxStoreName;
    private String uriPrefix;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExitCode crawlObjects() {
        this.retrieveConfigurationData(this.getDataSource());
        try {
            this.ensureConnectedStore();
        }
        catch (MessagingException e) {
            this.closeConnection();
            return this.reportFatalErrorCause("Unable to open and MBOX file", e);
        }
        try {
            int nrFolders = this.baseFolders.size();
            if (nrFolders == 0) {
                Folder folder = this.store.getDefaultFolder();
                folder.open(1);
                this.crawlFolder(this.store.getDefaultFolder(), 0);
            } else {
                for (int i = 0; i < nrFolders; ++i) {
                    String baseFolderName = (String)this.baseFolders.get(i);
                    Folder baseFolder = this.store.getFolder(baseFolderName);
                    this.crawlFolder(baseFolder, 0);
                }
            }
        }
        catch (MessagingException e) {
            ExitCode exitCode = this.reportFatalErrorCause("MessagingException while crawling", e);
            return exitCode;
        }
        finally {
            this.closeConnection();
        }
        if (this.isStopRequested()) {
            return ExitCode.STOP_REQUESTED;
        }
        return ExitCode.COMPLETED;
    }

    protected void retrieveConfigurationData(DataSource dataSource) {
        if (dataSource == this.configuredDataSource) {
            return;
        }
        this.configuredDataSource = (MboxDataSource)dataSource;
        this.baseFolders.clear();
        String mboxFilePath = this.configuredDataSource.getMboxPath();
        if (mboxFilePath == null) {
            this.mboxStoreName = null;
        } else {
            this.uriPrefix = "mbox:/" + this.encodeFolderPath(mboxFilePath);
            this.mboxStoreName = new URLName(MSTOR_PROVIDER_PATH_PREFX + mboxFilePath.replace('\\', '/'));
        }
        Integer maxDepthI = this.configuredDataSource.getMaximumDepth();
        this.maxDepth = maxDepthI == null ? -1 : maxDepthI;
        Long maximumSize = this.configuredDataSource.getMaximumSize();
        this.maximumByteSize = maximumSize == null ? Long.MAX_VALUE : maximumSize;
        if (this.store != null) {
            this.closeConnection();
            this.store = null;
        }
    }

    protected void ensureConnectedStore() throws MessagingException {
        if (this.store == null) {
            System.setProperty("mstor.mbox.metadataStrategy", "none");
            System.setProperty("mstor.mbox.encoding", "ISO-8859-1");
            System.setProperty("mstor.mbox.bufferStrategy", "default");
            System.setProperty("mstor.mbox.cacheBuffers", "disabled");
            System.setProperty("mstor.cache.disabled", "true");
            CapabilityHints.setHintEnabled((String)"mstor.mbox.parsing.relaxed", (boolean)true);
            CapabilityHints.setHintEnabled((String)"mstor.mbox.mozillaCompatibility", (boolean)true);
            Properties p = new Properties();
            p.setProperty("mstor.metadata", "disabled");
            Session session = Session.getDefaultInstance(p);
            this.store = session.getStore(this.mboxStoreName);
        }
        if (!this.store.isConnected()) {
            this.store.connect();
        }
    }

    protected void closeConnection() {
        try {
            if (this.currentFolder != null && this.currentFolder.isOpen()) {
                this.currentFolder.close(false);
            }
        }
        catch (MessagingException e) {
            this.logger.warn("Unable to close folder", e);
        }
        super.closeConnection();
    }

    protected void recordCurrentFolderInAccessData(AccessData newAccessData) throws MessagingException {
        if (newAccessData != null) {
            String subFoldersString;
            if (MboxCrawler.holdsMessages(this.currentFolder)) {
                int messageCount = this.currentFolder.getMessageCount() - this.currentFolder.getDeletedMessageCount();
                newAccessData.put(this.currentFolderURI.toString(), SIZE_KEY, String.valueOf(messageCount));
            }
            if (MboxCrawler.holdsFolders(this.currentFolder) && (subFoldersString = this.getSubFoldersString(this.currentFolder)) != null) {
                newAccessData.put(this.currentFolderURI.toString(), "subfolders", subFoldersString);
            }
        }
    }

    protected boolean checkIfCurrentFolderHasBeenChanged(AccessData newAccessData) throws MessagingException {
        if (!this.currentFolder.isOpen()) {
            return false;
        }
        if (newAccessData == null) {
            return true;
        }
        boolean folderChanged = false;
        int messageCount = this.getCurrentFolderMessageCount();
        Set knownFolderChildren = newAccessData.getReferredIDs(this.currentFolderURI.toString());
        knownFolderChildren = knownFolderChildren == null ? Collections.EMPTY_SET : new HashSet(knownFolderChildren);
        HashSet<String> encounteredFolderChildren = new HashSet<String>(knownFolderChildren.size());
        for (int i = 1; i <= messageCount && !this.isStopRequested(); ++i) {
            MimeMessage message = (MimeMessage)this.getMessageFromCurrentFolder(i);
            String uri = this.getMessageUri(this.currentFolder, message);
            if (knownFolderChildren.contains(uri)) {
                encounteredFolderChildren.add(uri);
            } else {
                folderChanged = true;
            }
            if (newAccessData.get(uri, "accessed") != null || !this.isAcceptable(message)) continue;
            folderChanged = true;
        }
        for (String childUri : knownFolderChildren) {
            if (encounteredFolderChildren.contains(childUri)) continue;
            newAccessData.removeReferredID(this.currentFolderURI.toString(), childUri);
            folderChanged = true;
        }
        if (!folderChanged) {
            return this.checkSubfoldersChanged(newAccessData);
        }
        return folderChanged;
    }

    private String getFolderURIPrefix(Folder folder) throws MessagingException {
        StringBuilder buffer = new StringBuilder(100);
        buffer.append(MBOX_URL_SCHEME);
        buffer.append('/');
        buffer.append(this.encodeFolderPath(folder.getFullName()));
        return buffer.toString();
    }

    private String encodeFolderPath(String string) {
        int length = string.length();
        StringBuilder buffer = new StringBuilder(length + 10);
        for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            if (c == ' ') {
                buffer.append('+');
                continue;
            }
            char cInt = c;
            if (cInt >= '0' && cInt <= '9' || cInt >= 'A' && cInt <= 'Z' || cInt >= 'a' && cInt <= 'z' || cInt == '/' || cInt == ':' || cInt == '.' || cInt == '-') {
                buffer.append(c);
                continue;
            }
            if (cInt == '\\') {
                buffer.append('/');
                continue;
            }
            buffer.append('%');
            String hexVal = Integer.toHexString(c);
            if (hexVal.length() == 1) {
                buffer.append('0');
            }
            buffer.append(hexVal);
        }
        return buffer.toString();
    }

    protected URI getFolderURI(Folder folder) throws MessagingException {
        return new URIImpl(this.getFolderURIPrefix(folder));
    }

    protected String getMessageUri(Folder folder, Message message) throws MessagingException {
        return this.getFolderURIPrefix(folder) + "/" + MailUtil.getMessageId((MimeMessage)message);
    }

    protected String getFolderName(String url) throws UrlNotFoundException {
        if (!url.startsWith(this.uriPrefix)) {
            throw new UrlNotFoundException(url);
        }
        if (this.uriPrefix.equals(url)) {
            return "";
        }
        String name = null;
        name = url.contains("%40") || url.contains("@") ? url.substring(this.uriPrefix.length(), url.lastIndexOf("/")) : url.substring(this.uriPrefix.length());
        if (name.startsWith("/")) {
            return name.substring(1);
        }
        return name;
    }
}

