/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.crawler.mail;

import com.beetstra.jutf7.CharsetProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.PlainLiteral;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.accessor.AccessData;
import org.semanticdesktop.aperture.accessor.DataObject;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.vocabulary.NCO;
import org.semanticdesktop.aperture.vocabulary.NIE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailUtil {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("d MMM yyyy H:m:s Z", Locale.US);
    private static Charset utf7;
    private static final Charset normal;
    private static final Pattern EMAIL_ADDRESS_PATTERN;
    private static final Character SEMICOLON;
    private static final Character QUOTATION_MARK;
    private static final Character LT_BRACKET;
    private static final Character COMMA;
    private static final Character BACKSLASH;
    private static final String LINEAR_WHITE_SPACE_CHARS = "\r\n \t";

    public static String utf7Encode(String input) {
        return MailUtil.performConversion(input, utf7, normal);
    }

    public static String utf7Decode(String input) {
        return MailUtil.performConversion(input, normal, utf7);
    }

    private static String performConversion(String input, Charset inputCharset, Charset outputCharset) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(input.length() * 3);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, inputCharset);
            osw.write(input);
            osw.flush();
            byte[] array = baos.toByteArray();
            StringBuilder builder = new StringBuilder(input.length() * 3);
            InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream(array), outputCharset);
            int charRead = 0;
            while ((charRead = reader.read()) != -1) {
                builder.append((char)charRead);
            }
            return builder.toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static List<LiberalInternetAddress> getAddressHeader(Message msg, String name) throws MessagingException {
        String[] headers = msg.getHeader(name);
        if (headers == null) {
            return null;
        }
        ArrayList<LiberalInternetAddress> addrs = new ArrayList<LiberalInternetAddress>();
        for (int i = 0; i < headers.length; ++i) {
            String header = headers[i];
            addrs.addAll(MailUtil.parseAddressHeaderValue(header));
        }
        return addrs;
    }

    public static List<LiberalInternetAddress> parseAddressHeaderValue(String header) {
        ArrayList<LiberalInternetAddress> addrs = new ArrayList<LiberalInternetAddress>();
        ArrayList<String> chunks = new ArrayList<String>();
        ArrayList<Character> separators = new ArrayList<Character>();
        MailUtil.tokenize(header, chunks, separators);
        int chunkIndex = 0;
        while (chunkIndex < chunks.size()) {
            String chunk = chunks.get(chunkIndex).trim();
            if (chunk.length() == 0) {
                ++chunkIndex;
                continue;
            }
            LiberalInternetAddress newAddress = new LiberalInternetAddress(null, null, new String[0]);
            int newChunkIndex = 0;
            newChunkIndex = MailUtil.processSingleChunkCase(newAddress, chunk, chunks, separators, chunkIndex);
            if (newChunkIndex > chunkIndex) {
                chunkIndex = newChunkIndex;
                addrs.add(newAddress);
                continue;
            }
            newChunkIndex = MailUtil.processNameWithQuotationMarksAndAddress(newAddress, chunk, chunks, separators, chunkIndex);
            if (newChunkIndex > chunkIndex) {
                chunkIndex = newChunkIndex;
                addrs.add(newAddress);
                continue;
            }
            newChunkIndex = MailUtil.processNameWithoutQuotationMarksAndAddress(newAddress, chunk, chunks, separators, chunkIndex);
            if (newChunkIndex > chunkIndex) {
                chunkIndex = newChunkIndex;
                addrs.add(newAddress);
                continue;
            }
            ++chunkIndex;
        }
        return addrs;
    }

    private static int processSingleChunkCase(LiberalInternetAddress newAddress, String chunk, ArrayList<String> chunks, ArrayList<Character> separators, int chunkIndex) {
        Character leftSeparator = MailUtil.getLeftSeparator(separators, chunkIndex);
        Character rightSeparator = MailUtil.getRightSeparator(separators, chunkIndex);
        if (LT_BRACKET.equals(leftSeparator)) {
            if (MailUtil.isAddress(chunk)) {
                newAddress.getAddresses().add(chunk);
                while (SEMICOLON.equals(MailUtil.getRightSeparator(separators, chunkIndex)) && chunkIndex < chunks.size() - 1) {
                    newAddress.getAddresses().add(chunks.get(++chunkIndex));
                }
                return chunkIndex + 1;
            }
        } else if (rightSeparator == null || COMMA.equals(rightSeparator) || SEMICOLON.equals(rightSeparator)) {
            if (MailUtil.isAddress(chunk)) {
                newAddress.getAddresses().add(chunk);
            } else {
                newAddress.setName(MailUtil.decodeText(chunk));
            }
            return chunkIndex + 1;
        }
        return 0;
    }

    private static int processNameWithQuotationMarksAndAddress(LiberalInternetAddress newAddress, String chunk, ArrayList<String> chunks, ArrayList<Character> separators, int chunkIndex) {
        Character leftSeparator = MailUtil.getLeftSeparator(separators, chunkIndex);
        Character rightSeparator = MailUtil.getRightSeparator(separators, chunkIndex);
        if (QUOTATION_MARK.equals(leftSeparator) && QUOTATION_MARK.equals(rightSeparator)) {
            newAddress.setName(MailUtil.decodeText(chunk));
            ++chunkIndex;
            if (++chunkIndex < chunks.size()) {
                String address = chunks.get(chunkIndex);
                newAddress.getAddresses().add(address);
                while (SEMICOLON.equals(MailUtil.getRightSeparator(separators, chunkIndex)) && chunkIndex < chunks.size() - 1) {
                    newAddress.getAddresses().add(chunks.get(++chunkIndex));
                }
            }
            return ++chunkIndex;
        }
        return 0;
    }

    private static int processNameWithoutQuotationMarksAndAddress(LiberalInternetAddress newAddress, String chunk, ArrayList<String> chunks, ArrayList<Character> separators, int chunkIndex) {
        Character rightSeparator = MailUtil.getRightSeparator(separators, chunkIndex);
        if (LT_BRACKET.equals(rightSeparator)) {
            String name = chunks.get(chunkIndex);
            newAddress.setName(MailUtil.decodeText(name));
            if (++chunkIndex < chunks.size()) {
                String address = chunks.get(chunkIndex);
                if (address.trim().length() > 0) {
                    newAddress.getAddresses().add(address);
                }
                while (SEMICOLON.equals(MailUtil.getRightSeparator(separators, chunkIndex)) && chunkIndex < chunks.size() - 1) {
                    String addressChunk;
                    if ((addressChunk = chunks.get(++chunkIndex)).trim().length() <= 0) continue;
                    newAddress.getAddresses().add(addressChunk);
                }
            }
            return ++chunkIndex;
        }
        return 0;
    }

    private static Character getRightSeparator(ArrayList<Character> separators, int chunkIndex) {
        Character rightSeparator = chunkIndex < separators.size() ? separators.get(chunkIndex) : null;
        return rightSeparator;
    }

    private static Character getLeftSeparator(ArrayList<Character> separators, int chunkIndex) {
        Character leftSeparator = chunkIndex > 0 && separators.size() >= chunkIndex ? separators.get(chunkIndex - 1) : null;
        return leftSeparator;
    }

    private static void tokenize(String header, ArrayList<String> chunks, ArrayList<Character> separators) {
        MailUtil.tokenize(header, chunks, separators, true);
        boolean repeat = false;
        for (int i = 0; i < separators.size(); ++i) {
            Character s = separators.get(i);
            if (!COMMA.equals(s) || (i <= 0 || !SEMICOLON.equals(separators.get(i - 1))) && (i >= separators.size() - 1 || !SEMICOLON.equals(separators.get(i + 1)))) continue;
            repeat = true;
            break;
        }
        if (repeat) {
            chunks.clear();
            separators.clear();
            MailUtil.tokenize(header, chunks, separators, false);
        }
    }

    private static void tokenize(String header, ArrayList<String> chunks, ArrayList<Character> separators, boolean commaIsASeparator) {
        StringBuilder currentChunk = new StringBuilder();
        boolean insideQuotes = false;
        for (int i = 0; i < header.length(); ++i) {
            char c = header.charAt(i);
            if (BACKSLASH.equals(Character.valueOf(c))) {
                if (++i >= header.length()) continue;
                char c2 = header.charAt(i);
                currentChunk.append(c2);
                continue;
            }
            if (QUOTATION_MARK.equals(Character.valueOf(c))) {
                chunks.add(currentChunk.toString().trim());
                separators.add(Character.valueOf(c));
                currentChunk = new StringBuilder();
                if (insideQuotes) {
                    insideQuotes = false;
                    continue;
                }
                insideQuotes = true;
                continue;
            }
            if (!insideQuotes && MailUtil.isSeparator(c, commaIsASeparator)) {
                chunks.add(currentChunk.toString().trim());
                separators.add(Character.valueOf(c));
                currentChunk = new StringBuilder();
                continue;
            }
            if (MailUtil.isLineBreak(c)) {
                while (i + 1 < header.length() && Character.isWhitespace(header.charAt(i + 1))) {
                    ++i;
                }
                currentChunk.append(" ");
                continue;
            }
            currentChunk.append(c);
        }
        chunks.add(currentChunk.toString().trim());
    }

    private static boolean isAddress(String chunk) {
        return EMAIL_ADDRESS_PATTERN.matcher(chunk).matches();
    }

    private static boolean isSeparator(char s, boolean commaIsASeparator) {
        if (commaIsASeparator) {
            return s == '<' || s == '>' || s == ',' || s == ';';
        }
        return s == '<' || s == '>' || s == ';';
    }

    private static boolean isLineBreak(char c) {
        return c == '\n' || c == '\r';
    }

    public static String decodeText(String encodedText) {
        int encodedWordStart = encodedText.indexOf("=?");
        if (encodedWordStart == -1) {
            return encodedText;
        }
        StringBuilder decodedText = new StringBuilder(encodedText.length());
        int encodedWordEnd = -2;
        while (encodedWordStart != -1) {
            String decodedWord;
            String plainText = encodedText.substring(encodedWordEnd + 2, encodedWordStart);
            if (!MailUtil.isLinearWhiteSpace(plainText)) {
                decodedText.append(plainText);
            }
            int charsetEnd = encodedText.indexOf(63, encodedWordStart + 2);
            int encodingEnd = encodedText.indexOf(63, charsetEnd + 1);
            encodedWordEnd = encodedText.indexOf("?=", encodingEnd + 1);
            if (charsetEnd == -1 || encodingEnd == -1 || encodedWordEnd == -1) {
                encodedWordEnd = encodedWordStart - 2;
                break;
            }
            String encodedWord = encodedText.substring(encodedWordStart, encodedWordEnd + 2);
            try {
                decodedWord = MimeUtility.decodeWord(encodedWord);
            }
            catch (ParseException e) {
                decodedWord = encodedWord;
            }
            catch (UnsupportedEncodingException e) {
                decodedWord = encodedWord;
            }
            decodedText.append(decodedWord);
            encodedWordStart = encodedText.indexOf("=?", encodedWordEnd + 2);
        }
        decodedText.append(encodedText.substring(encodedWordEnd + 2));
        return decodedText.toString();
    }

    private static boolean isLinearWhiteSpace(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (LINEAR_WHITE_SPACE_CHARS.indexOf(s.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }

    public static Date getStereotypicalContentCreatedDate(Message message) throws MessagingException {
        Date result = message.getSentDate();
        if (result == null) {
            result = message.getReceivedDate();
        }
        return result;
    }

    public static void addAddressMetadata(InternetAddress address, URI predicate, RDFContainer metadata) {
        String emailAddress;
        String name = address.getPersonal();
        if (name != null) {
            name = name.trim();
        }
        if ((emailAddress = address.getAddress()) != null) {
            emailAddress = emailAddress.trim();
        }
        if (MailUtil.hasRealValue(name) || MailUtil.hasRealValue(emailAddress)) {
            PlainLiteral literal;
            URI person = metadata.getModel().createURI(MailUtil.getPersonURI(emailAddress, name));
            metadata.add(predicate, person);
            metadata.getModel().addStatement(person, RDF.type, NCO.Contact);
            if (MailUtil.hasRealValue(name)) {
                literal = metadata.getModel().createPlainLiteral(name);
                metadata.getModel().addStatement(person, NCO.fullname, literal);
            }
            if (MailUtil.hasRealValue(emailAddress)) {
                literal = metadata.getModel().createPlainLiteral(emailAddress);
                URI emailResource = metadata.getModel().createURI(MailUtil.getEmailURI("mailto:", emailAddress));
                metadata.getModel().addStatement(person, NCO.hasEmailAddress, emailResource);
                metadata.getModel().addStatement(emailResource, RDF.type, NCO.EmailAddress);
                metadata.getModel().addStatement(emailResource, NCO.emailAddress, literal);
            }
        }
    }

    public static void addAddressMetadata(LiberalInternetAddress address, URI predicate, RDFContainer metadata) {
        String name = address.getName();
        if (name != null) {
            name = name.trim();
        }
        List<String> addrs = address.getAddresses();
        if (MailUtil.hasRealValue(name) || addrs.size() > 0) {
            URI person = metadata.getModel().createURI(MailUtil.getPersonURI(null, null));
            metadata.add(predicate, person);
            metadata.getModel().addStatement(person, RDF.type, NCO.Contact);
            if (MailUtil.hasRealValue(name)) {
                PlainLiteral literal = metadata.getModel().createPlainLiteral(name);
                metadata.getModel().addStatement(person, NCO.fullname, literal);
            }
            for (String emailAddress : addrs) {
                if (!MailUtil.hasRealValue(emailAddress)) continue;
                PlainLiteral literal = metadata.getModel().createPlainLiteral(emailAddress);
                URI emailResource = metadata.getModel().createURI(MailUtil.getEmailURI("mailto:", emailAddress));
                metadata.getModel().addStatement(person, NCO.hasEmailAddress, emailResource);
                metadata.getModel().addStatement(emailResource, RDF.type, NCO.EmailAddress);
                metadata.getModel().addStatement(emailResource, NCO.emailAddress, literal);
            }
        }
    }

    public static String getPersonURI(String email, String name) throws IllegalArgumentException {
        return "emailperson:" + UUID.randomUUID().toString();
    }

    private static String getEmailURI(String prefix, String email) throws IllegalArgumentException {
        if (MailUtil.hasRealValue(email)) {
            if (!MailUtil.isValidEmailAddress(email)) {
                return prefix + MailUtil.urlifyString(email);
            }
            return prefix + email;
        }
        throw new IllegalArgumentException("Email invalid");
    }

    private static boolean isValidEmailAddress(String email) {
        if (email.length() < 3) {
            return false;
        }
        if (email.indexOf("@") == -1) {
            return false;
        }
        if (email.indexOf(" ") != -1) {
            return false;
        }
        try {
            new URIImpl("mailto:" + email, true);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String urlifyString(String input) {
        try {
            return URLEncoder.encode(input, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Really weird....", e);
        }
    }

    private static boolean hasRealValue(String string) {
        return string != null && string.length() > 0;
    }

    public static void registerParentRelationshipInAccessData(DataObject object, AccessData accessData) {
        if (accessData == null) {
            return;
        }
        URI parent = MailUtil.getParent(object);
        if (parent != null) {
            String parentID = parent.toString();
            String childID = object.getID().toString();
            if (accessData.isKnownId(parentID) && !parentID.equals(childID)) {
                accessData.putReferredID(parentID, childID);
                accessData.putAggregatedID(parentID, childID);
            }
        }
    }

    public static URI getParent(DataObject object) {
        HashSet parentIDs = object.getMetadata().getAll(NIE.isPartOf);
        if (!(parentIDs instanceof Set)) {
            parentIDs = new HashSet(parentIDs);
        }
        if (parentIDs.isEmpty()) {
            return null;
        }
        if (parentIDs.size() > 1) {
            return null;
        }
        Node parent = (Node)parentIDs.iterator().next();
        if (parent instanceof URI) {
            return (URI)parent;
        }
        return null;
    }

    public static Date parseReceivedHeader(String st) throws java.text.ParseException {
        String whole = st.replaceAll("(\r\n)|(\t)", " ");
        String datePart = whole.substring(whole.lastIndexOf(";") + 1).trim();
        if (datePart.contains(",")) {
            datePart = datePart.substring(datePart.indexOf(",") + 1).trim();
        }
        if (datePart.contains("(")) {
            datePart = datePart.substring(0, datePart.indexOf("("));
        }
        return dateFormat.parse(datePart);
    }

    public static String getMessageId(MimeMessage message) throws MessagingException {
        String[] messageIds = message.getHeader("Message-ID");
        String id = null;
        String hash = null;
        try {
            hash = MailUtil.getHash(message);
        }
        catch (IOException e1) {
            throw new MessagingException("Couldn't obtain a hash of the message", e1);
        }
        if (messageIds != null && messageIds.length > 0) {
            id = messageIds[0];
            if (id.startsWith("<")) {
                id = id.substring(1);
            }
            if (id.endsWith(">")) {
                id = id.substring(0, id.length() - 1);
            }
            try {
                id = URLEncoder.encode(id, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {}
        } else {
            StringBuilder builder = new StringBuilder();
            Enumeration enumeration = message.getAllHeaders();
            while (enumeration.hasMoreElements()) {
                Header header = (Header)enumeration.nextElement();
                builder.append(header.getName());
                builder.append(header.getValue());
            }
            id = String.valueOf(builder.toString().hashCode());
        }
        return id + "-" + hash;
    }

    public static String getHash(MimeMessage msg) throws MessagingException, IOException {
        try {
            int bytesRead;
            MessageDigest digest = MessageDigest.getInstance("SHA");
            digest.reset();
            Enumeration headers = msg.getAllHeaderLines();
            while (headers.hasMoreElements()) {
                String line = (String)headers.nextElement();
                digest.update(line.getBytes());
            }
            byte[] buffer = new byte[4096];
            InputStream stream = msg.getRawInputStream();
            while ((bytesRead = stream.read(buffer)) != -1) {
                digest.update(buffer, 0, bytesRead);
            }
            byte[] res = digest.digest();
            StringBuilder resBuilder = new StringBuilder(20);
            for (byte b : res) {
                int i = b + 128;
                resBuilder.append(Integer.toHexString(i));
            }
            return resBuilder.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public static String getMessageIdWithHeadersHash(Message message) throws MessagingException {
        String[] messageIds = message.getHeader("Message-ID");
        String[] dates = message.getHeader("Date");
        String[] receiveds = message.getHeader("Received");
        String id = null;
        if (messageIds != null && messageIds.length > 0) {
            id = messageIds[0];
            if (id.startsWith("<")) {
                id = id.substring(1);
            }
            if (id.endsWith(">")) {
                id = id.substring(0, id.length() - 1);
            }
            try {
                id = URLEncoder.encode(id, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {}
        } else {
            StringBuilder builder = new StringBuilder();
            Enumeration enumeration = message.getAllHeaders();
            while (enumeration.hasMoreElements()) {
                Header header = (Header)enumeration.nextElement();
                builder.append(header.getName());
                builder.append(header.getValue());
            }
            id = String.valueOf(builder.toString().hashCode());
        }
        StringBuilder hashBldr = new StringBuilder("");
        StringBuilder bldr = new StringBuilder("");
        if (messageIds != null) {
            for (String msgId : messageIds) {
                bldr.append(msgId);
            }
        }
        if (dates != null) {
            for (String msgDate : dates) {
                bldr.append(msgDate);
            }
        }
        if (receiveds != null) {
            for (String msgReceived : receiveds) {
                bldr.append(msgReceived);
            }
        }
        try {
            byte[] res;
            MessageDigest digest = MessageDigest.getInstance("SHA");
            for (byte b : res = digest.digest(bldr.toString().getBytes())) {
                int i = b + 128;
                hashBldr.append(Integer.toHexString(i));
            }
        }
        catch (NoSuchAlgorithmException e) {
            // empty catch block
        }
        return id + "-" + hashBldr.toString();
    }

    static {
        try {
            utf7 = Charset.forName("X-MODIFIED-UTF-7");
        }
        catch (Exception x) {
            try {
                utf7 = new CharsetProvider().charsetForName("X-MODIFIED-UTF-7");
            }
            catch (Exception y) {
                throw new RuntimeException("Cannot load X-MODIFIED-UTF-7, com.beetstra.jutf7.CharsetProvider problem: " + y, y);
            }
        }
        normal = Charset.forName("ISO-8859-1");
        EMAIL_ADDRESS_PATTERN = Pattern.compile(".+@.+\\.\\w+");
        SEMICOLON = new Character(';');
        QUOTATION_MARK = new Character('\"');
        LT_BRACKET = new Character('<');
        COMMA = new Character(',');
        BACKSLASH = new Character('\\');
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LiberalInternetAddress {
        private String name;
        private List<String> addresses = new ArrayList<String>();

        public LiberalInternetAddress(String name, String address, String ... additionalAddresses) {
            this.setName(name);
            if (address != null) {
                this.getAddresses().add(address);
            }
            if (additionalAddresses != null) {
                for (String a : additionalAddresses) {
                    if (a == null || a.trim().length() <= 0) continue;
                    this.getAddresses().add(a.trim());
                }
            }
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public List<String> getAddresses() {
            return this.addresses;
        }
    }
}

