/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.crawler.mail;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import org.ontoware.rdf2go.exception.ModelRuntimeException;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.node.DatatypeLiteral;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.ontoware.rdf2go.vocabulary.XSD;
import org.semanticdesktop.aperture.accessor.DataObject;
import org.semanticdesktop.aperture.accessor.RDFContainerFactory;
import org.semanticdesktop.aperture.accessor.base.FileDataObjectBase;
import org.semanticdesktop.aperture.crawler.mail.MailUtil;
import org.semanticdesktop.aperture.crawler.mail.MessageDataObject;
import org.semanticdesktop.aperture.crawler.mail.base.MessageDataObjectBase;
import org.semanticdesktop.aperture.datasource.DataSource;
import org.semanticdesktop.aperture.helper.html.HtmlParserException;
import org.semanticdesktop.aperture.helper.html.HtmlParserUtil;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.rdf.util.ModelUtil;
import org.semanticdesktop.aperture.util.DateUtil;
import org.semanticdesktop.aperture.vocabulary.APERTURE_NIE_EXTENSIONS;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.semanticdesktop.aperture.vocabulary.NIE;
import org.semanticdesktop.aperture.vocabulary.NMO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataObjectFactory {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String ID_KEY = "id";
    private static final String CHILDREN_KEY = "children";
    private static final String MAIL_PART_KEY = "mail-part";
    private static final Pattern START_PGP_MESSAGE_PATTERN = Pattern.compile("^(-)+BEGIN PGP MESSAGE(-)+$", 8);
    private static final Pattern END_PGP_MESSAGE_PATTERN = Pattern.compile("^(-)+END PGP MESSAGE(-)+$", 8);
    private static final Pattern START_PGP_SIGNEDMESSAGE_PATTERN = Pattern.compile("^(-)+BEGIN PGP SIGNED MESSAGE(-)+$", 8);
    private static final Pattern START_PGP_SIGNATURE_PATTERN = Pattern.compile("^(-)+BEGIN PGP SIGNATURE(-)+$", 8);
    private static final Pattern END_PGP_SIGNATURE_PATTERN = Pattern.compile("^(-)+END PGP SIGNATURE(-)+$", 8);
    private DataSource dataSource;
    private RDFContainerFactory containerFactory;
    private PartStreamFactory streamFactory;
    private MimeMessage message;
    private URI messageURI;
    private String subPartUriPrefix;
    private URI folderUri;
    private List<DataObject> dataObjectsToReturn;
    private int currentDataObjectToReturn;
    private String partUriDelimiter;

    public DataObjectFactory(MimeMessage message, RDFContainerFactory containerFactory, PartStreamFactory streamFactory, DataSource dataSource, URI messageUri, URI folderUri, String partUriDelimiter, String attachmentUriPrefix) throws IOException, MessagingException {
        this.message = message;
        this.partUriDelimiter = partUriDelimiter;
        this.containerFactory = containerFactory;
        this.dataSource = dataSource;
        this.folderUri = folderUri;
        this.currentDataObjectToReturn = 0;
        this.dataObjectsToReturn = new ArrayList<DataObject>(10);
        this.messageURI = messageUri;
        this.subPartUriPrefix = attachmentUriPrefix.toString();
        this.streamFactory = streamFactory == null ? new PartStreamFactory(){

            public InputStream getPartStream(Part part) throws MessagingException, IOException {
                return part.getInputStream();
            }

            public MessageDataObject createDataObject(URI dataObjectId, DataSource dataSource, RDFContainer metadata, MimeMessage msg) {
                return new MessageDataObjectBase(dataObjectId, dataSource, metadata, msg);
            }
        } : streamFactory;
        try {
            this.createDataObjects();
        }
        catch (MessagingException e) {
            this.disposeRemainingObjects();
            throw e;
        }
        catch (IOException e) {
            this.disposeRemainingObjects();
            throw e;
        }
    }

    public DataObjectFactory(MimeMessage message, RDFContainerFactory containerFactory, PartStreamFactory streamFactory, DataSource dataSource, URI messageUri, URI folderUri, String partUriDelimiter) throws IOException, MessagingException {
        this(message, containerFactory, streamFactory, dataSource, messageUri, folderUri, partUriDelimiter, messageUri.toString());
    }

    public DataObjectFactory(MimeMessage message, RDFContainerFactory containerFactory, PartStreamFactory streamFactory, DataSource dataSource, URI messageUri, URI folderUri) throws IOException, MessagingException {
        this(message, containerFactory, streamFactory, dataSource, messageUri, folderUri, null);
    }

    public DataObject getObject() throws MessagingException, IOException {
        if (this.currentDataObjectToReturn >= this.dataObjectsToReturn.size()) {
            return null;
        }
        DataObject result = this.dataObjectsToReturn.get(this.currentDataObjectToReturn);
        ++this.currentDataObjectToReturn;
        return result;
    }

    public void disposeRemainingObjects() {
        while (this.currentDataObjectToReturn < this.dataObjectsToReturn.size()) {
            try {
                this.dataObjectsToReturn.get(this.currentDataObjectToReturn).dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++this.currentDataObjectToReturn;
        }
        this.dataObjectsToReturn.clear();
    }

    public DataObject getObject(String url) {
        Iterator<DataObject> it = this.dataObjectsToReturn.iterator();
        while (it.hasNext()) {
            DataObject object = it.next();
            if (!object.getID().toString().equals(url)) continue;
            it.remove();
            return object;
        }
        return null;
    }

    public DataObject getObjectAndDisposeAllOtherObjects(String url) {
        DataObject objectToReturn = null;
        for (DataObject object : this.dataObjectsToReturn) {
            if (object.getID().toString().equals(url)) {
                objectToReturn = object;
                continue;
            }
            object.dispose();
        }
        this.dataObjectsToReturn.clear();
        return objectToReturn;
    }

    public Map<URI, DataObject> getAllDataObjects() throws MessagingException, IOException {
        HashMap<URI, DataObject> result = new HashMap<URI, DataObject>();
        DataObject ob = null;
        while ((ob = this.getObject()) != null) {
            result.put(ob.getID(), ob);
        }
        return result;
    }

    private void createDataObjects() throws MessagingException, IOException {
        HashMap map = this.handleMailPart(this.message, this.messageURI, MailUtil.getStereotypicalContentCreatedDate(this.message), true);
        this.createDataObjects(map, this.folderUri, this.dataObjectsToReturn);
        RDFContainer msgContainer = this.dataObjectsToReturn.get(0).getMetadata();
        msgContainer.add(RDF.type, NMO.Email);
        msgContainer.add(RDF.type, NMO.MailboxDataObject);
    }

    private HashMap handleMailPart(Part mailPart, URI uri, Date messageCreationDate, boolean firstPart) throws MessagingException, IOException {
        ContentType contentType = null;
        String primaryType = null;
        String contentTypeStr = null;
        try {
            contentTypeStr = mailPart.getContentType();
        }
        catch (MessagingException me) {
            if (me.getMessage().contains("Unable to load BODYSTRUCTURE") && mailPart instanceof MimeMessage) {
                mailPart = new MimeMessage((MimeMessage)mailPart);
                contentTypeStr = mailPart.getContentType();
            }
            throw me;
        }
        if (contentTypeStr != null) {
            contentType = new ContentType(contentTypeStr);
            primaryType = this.normalizeString(contentType.getPrimaryType());
        }
        if ("multipart".equals(primaryType)) {
            Object content = mailPart.getContent();
            if (content instanceof Multipart) {
                return this.handleMultipart((Multipart)content, contentType, uri, messageCreationDate);
            }
            this.logger.warn("multipart '" + uri + "' does not contain a Multipart object: ");
            return null;
        }
        return this.handleSinglePart(mailPart, contentType, uri, messageCreationDate, false, firstPart);
    }

    private HashMap handleSinglePart(Part mailPart, ContentType contentType, URI uri, Date messageCreationDate, boolean emptyContent, boolean firstPart) throws MessagingException, IOException {
        String mimeType = this.getMimeTypeFromContentType(contentType);
        String charsetStr = this.getCharsetStringFromContentType(contentType, mimeType, mailPart);
        HashMap result = null;
        if (emptyContent) {
            result = this.handleEmptyContentSinglePart(uri, messageCreationDate);
        } else {
            if ("message/rfc822".equals(mimeType) || "text/rfc822-headers".equals(mimeType)) {
                result = this.handleRfc822SinglePart(mailPart, uri);
                result.put(NIE.mimeType, mimeType);
                return result;
            }
            result = this.handleNormalSinglePart(mailPart, charsetStr, mimeType, uri, messageCreationDate, firstPart);
        }
        this.extractGenericSinglePartMetadata(mailPart, result, messageCreationDate);
        if (mailPart instanceof Message) {
            this.extractMessageSinglePartMetadata(mailPart, result, mimeType);
        } else {
            this.extractNonMessageSinglePartMetadata(mailPart, result, mimeType);
        }
        result.put(MAIL_PART_KEY, mailPart);
        if (contentType.getPrimaryType().equalsIgnoreCase("application") && contentType.getSubType().toLowerCase().contains("pkcs7-mime") && contentType.getParameter("name") != null && contentType.getParameter("name").endsWith(".p7m")) {
            result.put(NFO.encryptionStatus, NFO.encryptedStatus);
        }
        return result;
    }

    private String getMimeTypeFromContentType(ContentType contentType) {
        if (contentType != null) {
            return this.normalizeString(contentType.getBaseType());
        }
        return "text/plain";
    }

    private String getCharsetStringFromContentType(ContentType contentType, String mimeType, Part part) {
        String charsetStr = null;
        if (contentType != null) {
            charsetStr = this.normalizeString(contentType.getParameter("charset"));
        }
        if (charsetStr == null && (part instanceof MimeMessage || mimeType.startsWith("text/"))) {
            charsetStr = "us-ascii";
        }
        if (charsetStr == null || charsetStr.length() == 0) {
            return null;
        }
        charsetStr = MimeUtility.javaCharset(charsetStr);
        charsetStr = charsetStr.toLowerCase();
        return charsetStr;
    }

    private HashMap handleEmptyContentSinglePart(URI uri, Date messageCreationDate) {
        HashMap<Object, Comparable<Node>> result = new HashMap<Object, Comparable<Node>>();
        result.put(ID_KEY, uri);
        if (messageCreationDate != null) {
            result.put(NIE.contentCreated, messageCreationDate);
        }
        return result;
    }

    private HashMap handleRfc822SinglePart(Part mailPart, URI uri) throws MessagingException, IOException {
        Object content = mailPart.getContent();
        if (content instanceof Message) {
            Message nestedMessage = (Message)content;
            HashMap result = this.handleMailPart(nestedMessage, uri, MailUtil.getStereotypicalContentCreatedDate(nestedMessage), true);
            result.put(RDF.type, NMO.Email);
            return result;
        }
        if (content instanceof InputStream) {
            MimeMessage nestedMessage = new MimeMessage(null, (InputStream)content);
            HashMap result = this.handleMailPart(nestedMessage, uri, MailUtil.getStereotypicalContentCreatedDate(nestedMessage), true);
            result.put(RDF.type, NMO.Email);
            return result;
        }
        this.logger.warn("message/rfc822 part with unknown content class: " + (content == null ? null : content.getClass()));
        return null;
    }

    private HashMap handleNormalSinglePart(Part normalSinglePart, String charsetStr, String mimeType, URI uri, Date messageCreationDate, boolean firstPart) throws MessagingException, IOException {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        result.put(ID_KEY, uri);
        String fileName = normalSinglePart.getFileName();
        if (fileName != null) {
            try {
                fileName = MimeUtility.decodeText(fileName);
            }
            catch (UnsupportedEncodingException e) {
                this.logger.warn("Unable to decode text", e);
            }
            result.put(NFO.fileName, fileName);
            result.put(RDF.type, NFO.Attachment);
        } else if (firstPart && messageCreationDate != null) {
            result.put(NIE.contentCreated, messageCreationDate);
        }
        Object content = null;
        try {
            content = normalSinglePart.getContent();
        }
        catch (Exception e) {
            this.logger.warn("Coudln't get the message content", e);
        }
        if (content != null && content instanceof String && fileName == null && firstPart) {
            this.addStringContent((String)content, mimeType, result);
            boolean start = START_PGP_MESSAGE_PATTERN.matcher((String)content).find();
            if (start) {
                if (END_PGP_MESSAGE_PATTERN.matcher((String)content).find()) {
                    result.put(NFO.encryptionStatus, NFO.encryptedStatus);
                }
            } else {
                boolean startSignedMessage = START_PGP_SIGNEDMESSAGE_PATTERN.matcher((String)content).find();
                if (startSignedMessage) {
                    boolean startSignature = START_PGP_SIGNATURE_PATTERN.matcher((String)content).find();
                    boolean endSignature = END_PGP_SIGNATURE_PATTERN.matcher((String)content).find();
                    if (startSignature && endSignature) {
                        result.put(APERTURE_NIE_EXTENSIONS.hasSignature, Boolean.TRUE);
                        result.put(APERTURE_NIE_EXTENSIONS.signatureContainedIn, uri);
                    }
                }
            }
        }
        if (charsetStr != null) {
            result.put(NIE.characterSet, charsetStr);
        }
        return result;
    }

    private void addStringContent(String content, String mimeType, HashMap result) {
        if (mimeType.equals("text/html")) {
            content = this.extractTextFromHtml(content);
        }
        result.put(NMO.plainTextMessageContent, content);
    }

    private String extractTextFromHtml(String string) {
        HtmlParserUtil.ContentExtractor extractor = new HtmlParserUtil.ContentExtractor();
        ByteArrayInputStream stream = new ByteArrayInputStream(string.getBytes());
        try {
            HtmlParserUtil.parse(stream, null, extractor);
        }
        catch (HtmlParserException e) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(32768);
        this.append(buffer, extractor.getTitle());
        this.append(buffer, extractor.getAuthor());
        this.append(buffer, extractor.getDescription());
        Iterator keywords = extractor.getKeywords();
        while (keywords.hasNext()) {
            this.append(buffer, (String)keywords.next());
        }
        this.append(buffer, extractor.getText());
        return buffer.toString();
    }

    private void append(StringBuilder buffer, String text) {
        if (text != null) {
            buffer.append(text);
            buffer.append(' ');
        }
    }

    private void extractGenericSinglePartMetadata(Part mailPart, HashMap result, Date messageCreationDate) throws MessagingException {
        int size = mailPart.getSize();
        if (size >= 0) {
            result.put(NIE.byteSize, size);
        }
    }

    private void extractMessageSinglePartMetadata(Part mailPart, HashMap result, String mimeType) throws MessagingException {
        result.put(NIE.mimeType, "message/rfc822");
        result.put(NMO.contentMimeType, mimeType);
        Message localMessage = (Message)mailPart;
        try {
            this.addSentAndReceivedDates(mailPart, result);
            String subject = localMessage.getSubject();
            if (subject != null) {
                subject = MailUtil.decodeText(subject);
                result.put(NMO.messageSubject, subject);
            }
            this.addObjectIfNotNull(NMO.messageId, this.getMessageId(localMessage), result);
            List<MailUtil.LiberalInternetAddress> from = MailUtil.getAddressHeader(localMessage, "From");
            if (from == null) {
                from = MailUtil.getAddressHeader(localMessage, "Sender");
            }
            this.addContactArrayIfNotNull(NMO.from, from, result);
            this.addContactArrayIfNotNull(NMO.to, MailUtil.getAddressHeader(localMessage, "To"), result);
            this.addContactArrayIfNotNull(NMO.cc, MailUtil.getAddressHeader(localMessage, "Cc"), result);
            this.addContactArrayIfNotNull(NMO.bcc, MailUtil.getAddressHeader(localMessage, "Bcc"), result);
            this.addBlankMessageArrayIfNotNull(NMO.references, localMessage.getHeader("References"), result);
            this.addBlankMessageArrayIfNotNull(NMO.inReplyTo, localMessage.getHeader("In-Reply-To"), result);
        }
        catch (Exception e) {
            // empty catch block
        }
        result.put(RDF.type, NMO.Email);
        if (localMessage instanceof MimeMessage) {
            MimeMessage mimeMessage = (MimeMessage)localMessage;
            this.addObjectIfNotNull(NMO.sender, mimeMessage.getSender(), result);
        }
    }

    private String[] getMessageId(Message localMessage) throws MessagingException {
        String trimmedId;
        ArrayList<String> result = new ArrayList<String>();
        String[] ids = localMessage.getHeader("Message-ID");
        if (ids != null && ids.length > 0) {
            for (String id : ids) {
                if (id == null || (trimmedId = id.trim()).length() <= 0 || result.contains(trimmedId)) continue;
                result.add(trimmedId);
            }
        }
        if ((ids = localMessage.getHeader("Mapi-Smtp-Message-Id")) != null && ids.length > 0) {
            for (String id : ids) {
                if (id == null || (trimmedId = id.trim()).length() <= 0 || result.contains(trimmedId)) continue;
                result.add(trimmedId);
            }
        }
        if ((ids = localMessage.getHeader("Mapi-125-Message-Id")) != null && ids.length > 0) {
            for (String id : ids) {
                if (id == null || (trimmedId = id.trim()).length() <= 0 || result.contains(trimmedId)) continue;
                result.add(trimmedId);
            }
        }
        if (result.size() > 0) {
            return result.toArray(new String[0]);
        }
        return null;
    }

    private void addBlankMessageArrayIfNotNull(URI uri, String[] headers, HashMap result) {
        if (headers == null || headers.length == 0) {
            return;
        }
        result.put(uri, headers);
    }

    private void extractNonMessageSinglePartMetadata(Part mailPart, HashMap result, String mimeType) {
        result.put(NIE.mimeType, mimeType);
        if (result.get(RDF.type) == null) {
            result.put(RDF.type, NMO.MimeEntity);
        }
    }

    private HashMap handleMultipart(Multipart multipart, ContentType contentType, URI uri, Date messageCreationDate) throws MessagingException, IOException {
        String subType = this.normalizeString(contentType.getSubType());
        if ("mixed".equals(subType)) {
            return this.handleMixedPart(multipart, contentType, uri, messageCreationDate);
        }
        if ("alternative".equals(subType)) {
            return this.handleAlternativePart(multipart, contentType, uri, messageCreationDate);
        }
        if ("digest".equals(subType)) {
            return this.handleDigestPart(multipart, contentType, uri, messageCreationDate);
        }
        if ("related".equals(subType)) {
            return this.handleRelatedPart(multipart, contentType, uri, messageCreationDate);
        }
        if ("signed".equals(subType)) {
            return this.handleSignedPart(multipart, contentType, uri, messageCreationDate);
        }
        if ("encrypted".equals(subType)) {
            return this.handleEncryptedPart(multipart, contentType, uri, messageCreationDate);
        }
        if ("report".equals(subType)) {
            return this.handleReportPart(multipart, contentType, uri, messageCreationDate);
        }
        if ("parallel".equals(subType)) {
            return this.handleParallelPart(multipart, contentType, uri, messageCreationDate);
        }
        return this.handleUnknownTypePart(multipart, contentType, uri, messageCreationDate);
    }

    private HashMap handleMixedPart(Multipart part, ContentType contentType, URI uri, Date date) throws MessagingException, IOException {
        Object oldChildren;
        Part parentPart = part.getParent();
        if (parentPart == null) {
            return null;
        }
        HashMap parent = this.handleSinglePart(parentPart, contentType, uri, date, true, true);
        if (parent == null) {
            return null;
        }
        String uriPrefix = this.getBodyPartURIPrefix(uri);
        int nrParts = 0;
        nrParts = this.getNestedPartCount(part);
        if (nrParts == -1) {
            return parent;
        }
        ArrayList<HashMap> children = new ArrayList<HashMap>(nrParts);
        boolean first = true;
        for (int i = 0; i < nrParts; ++i) {
            BodyPart bodyPart = part.getBodyPart(i);
            if (bodyPart == null) continue;
            URIImpl bodyURI = new URIImpl(uriPrefix + i);
            HashMap childResult = this.handleMailPart(bodyPart, bodyURI, date, first);
            first = false;
            if (childResult == null) continue;
            children.add(childResult);
        }
        int nrChildren = children.size();
        for (int i = 0; i < nrChildren; ++i) {
            HashMap child = (HashMap)children.get(i);
            Object bodyMimeType = child.get(NIE.mimeType);
            if (!"text/plain".equals(bodyMimeType) && !"text/html".equals(bodyMimeType)) continue;
            children.remove(i);
            this.transferInfo(child, parent);
            break;
        }
        if ((oldChildren = parent.get(CHILDREN_KEY)) != null) {
            ArrayList list = (ArrayList)oldChildren;
            list.addAll(children);
        } else {
            parent.put(CHILDREN_KEY, children);
        }
        return parent;
    }

    private HashMap handleAlternativePart(Multipart part, ContentType contentType, URI uri, Date date) throws MessagingException, IOException {
        Part parentPart = part.getParent();
        HashMap parent = null;
        if (parentPart instanceof Message) {
            parent = this.handleSinglePart(parentPart, contentType, uri, date, true, true);
        }
        if (this.getNestedPartCount(part) <= 0) {
            return parent;
        }
        int plaintextindex = this.getPartWithMimeType(part, "text/plain");
        int htmlindex = this.getPartWithMimeType(part, "text/html");
        int multipartIndex = this.getPartWithMimeType(part, "multipart");
        int index = multipartIndex;
        if (index < 0) {
            index = plaintextindex;
        }
        if (index < 0) {
            index = htmlindex;
        }
        if (index < 0) {
            index = 0;
        }
        HashMap child = this.handleMailPart(part.getBodyPart(index), uri, date, true);
        if (parent == null) {
            return child;
        }
        this.transferInfo(child, parent);
        return parent;
    }

    private HashMap handleDigestPart(Multipart part, ContentType contentType, URI uri, Date date) throws MessagingException, IOException {
        Part parentPart = part.getParent();
        if (parentPart == null) {
            return null;
        }
        HashMap parent = this.handleSinglePart(parentPart, contentType, uri, date, true, true);
        if (parent == null) {
            return null;
        }
        String bodyURIPrefix = this.getBodyPartURIPrefix(uri);
        ArrayList<HashMap> children = new ArrayList<HashMap>();
        int nrParts = 0;
        nrParts = this.getNestedPartCount(part);
        if (nrParts == -1) {
            return parent;
        }
        for (int i = 0; i < nrParts; ++i) {
            URIImpl bodyURI;
            HashMap child;
            BodyPart bodyPart = part.getBodyPart(i);
            if (bodyPart == null || (child = this.handleMailPart(bodyPart, bodyURI = new URIImpl(bodyURIPrefix + i), date, false)) == null) continue;
            children.add(child);
        }
        parent.put(CHILDREN_KEY, children);
        return parent;
    }

    private HashMap handleRelatedPart(Multipart part, ContentType contentType, URI uri, Date date) throws MessagingException, IOException {
        Part parentPart = part.getParent();
        if (parentPart == null) {
            return null;
        }
        HashMap parent = this.handleSinglePart(parentPart, contentType, uri, date, true, true);
        if (parent == null) {
            return null;
        }
        String bodyURIPrefix = this.getBodyPartURIPrefix(uri);
        int rootPartIndex = 0;
        int nrBodyParts = 0;
        nrBodyParts = this.getNestedPartCount(part);
        if (nrBodyParts == -1) {
            return parent;
        }
        String rootPartString = contentType.getParameter("start");
        if (rootPartString != null && (rootPartString = rootPartString.trim()).length() > 0) {
            for (int i = 0; i < nrBodyParts; ++i) {
                BodyPart bodyPart = part.getBodyPart(i);
                String bodyID = this.getHeader(bodyPart, "Content-ID");
                if (!rootPartString.equals(bodyID)) continue;
                rootPartIndex = i;
                break;
            }
        }
        ArrayList<HashMap> children = new ArrayList<HashMap>();
        for (int i = 0; i < nrBodyParts; ++i) {
            URIImpl bodyURI;
            BodyPart bodyPart = part.getBodyPart(i);
            HashMap child = this.handleMailPart(bodyPart, bodyURI = new URIImpl(bodyURIPrefix + i), date, i == rootPartIndex);
            if (child == null) continue;
            if (i == rootPartIndex) {
                this.transferInfo(child, parent);
                continue;
            }
            children.add(child);
        }
        parent.put(CHILDREN_KEY, children);
        return parent;
    }

    private HashMap handleSignedPart(Multipart part, ContentType contentType, URI uri, Date date) throws MessagingException, IOException {
        HashMap result = this.handleMixedPart(part, contentType, uri, date);
        ArrayList children = (ArrayList)result.get(CHILDREN_KEY);
        if (children != null && children.size() == 1) {
            HashMap childHashmap = (HashMap)children.get(0);
            URI signatureId = (URI)childHashmap.get(ID_KEY);
            if (this.isMulitpartSignedSignature(childHashmap)) {
                result.put(APERTURE_NIE_EXTENSIONS.hasSignature, Boolean.TRUE);
                result.put(APERTURE_NIE_EXTENSIONS.signatureContainedIn, signatureId);
            }
        }
        return result;
    }

    private boolean isMulitpartSignedSignature(HashMap childHashmap) {
        String mimeType = (String)childHashmap.get(NIE.mimeType);
        return mimeType != null && mimeType.contains("signature");
    }

    private HashMap handleEncryptedPart(Multipart part, ContentType contentType, URI uri, Date date) throws MessagingException, IOException {
        HashMap result = this.handleProtectedPart(part, 1, contentType, uri, date);
        result.put(NFO.encryptionStatus, NFO.encryptedStatus);
        return result;
    }

    private HashMap handleProtectedPart(Multipart part, int partIndex, ContentType contentType, URI uri, Date date) throws MessagingException, IOException {
        HashMap child = null;
        int nrParts = this.getNestedPartCount(part);
        if (nrParts >= 2) {
            child = this.handleMailPart(part.getBodyPart(partIndex), uri, date, false);
        } else {
            this.logger.warn("multipart/signed or multipart/encrypted without enough body parts, uri = " + uri);
        }
        Part parentPart = part.getParent();
        if (parentPart instanceof Message) {
            HashMap parent = this.handleSinglePart(parentPart, contentType, uri, date, true, true);
            if (parent == null) {
                return child;
            }
            if (child != null) {
                this.transferInfo(child, parent);
            }
            return parent;
        }
        return child;
    }

    private HashMap handleReportPart(Multipart part, ContentType contentType, URI uri, Date date) throws MessagingException, IOException {
        ArrayList<HashMap> children;
        Object oldChildren;
        URIImpl nestedURI;
        HashMap errorPart;
        Part parentPart = part.getParent();
        if (parentPart == null) {
            return null;
        }
        HashMap parent = this.handleSinglePart(parentPart, contentType, uri, date, true, true);
        if (parent == null) {
            return null;
        }
        int count = 0;
        count = this.getNestedPartCount(part);
        if (count == -1) {
            return parent;
        }
        if (count > 0 && (errorPart = this.handleMailPart(part.getBodyPart(0), uri, date, true)) != null) {
            this.transferInfo(errorPart, parent);
        }
        if (count > 1) {
            nestedURI = new URIImpl(this.getBodyPartURIPrefix(uri) + "1");
            HashMap deliveryStatusPart = this.handleMailPart(part.getBodyPart(1), nestedURI, date, true);
            if (deliveryStatusPart != null) {
                oldChildren = parent.get(CHILDREN_KEY);
                if (oldChildren != null) {
                    ((ArrayList)oldChildren).add(deliveryStatusPart);
                } else {
                    children = new ArrayList<HashMap>();
                    children.add(deliveryStatusPart);
                    parent.put(CHILDREN_KEY, children);
                }
            }
        }
        if (count > 2) {
            nestedURI = new URIImpl(this.getBodyPartURIPrefix(uri) + "0");
            HashMap returnedMessage = this.handleMailPart(part.getBodyPart(2), nestedURI, date, true);
            if (returnedMessage != null) {
                oldChildren = parent.get(CHILDREN_KEY);
                if (oldChildren != null) {
                    ((ArrayList)oldChildren).add(returnedMessage);
                } else {
                    children = new ArrayList();
                    children.add(returnedMessage);
                    parent.put(CHILDREN_KEY, children);
                }
            }
        }
        return parent;
    }

    private HashMap handleParallelPart(Multipart part, ContentType contentType, URI uri, Date date) throws MessagingException, IOException {
        return this.handleMixedPart(part, contentType, uri, date);
    }

    private HashMap handleUnknownTypePart(Multipart part, ContentType contentType, URI uri, Date date) throws MessagingException, IOException {
        this.logger.warn("Unknown multipart MIME type: \"" + contentType.getBaseType() + "\", treating as multipart/mixed");
        return this.handleMixedPart(part, contentType, uri, date);
    }

    private void createDataObjects(HashMap dataObjectHashMap, URI parentUri, List<DataObject> resultDataObjectList) {
        URI dataObjectId = (URI)dataObjectHashMap.get(ID_KEY);
        Part mailPart = (Part)dataObjectHashMap.get(MAIL_PART_KEY);
        RDFContainer metadata = this.containerFactory.getRDFContainer(dataObjectId);
        DataObject dataObject = null;
        if (mailPart instanceof MimeMessage) {
            try {
                dataObject = this.streamFactory.createDataObject(dataObjectId, this.dataSource, metadata, (MimeMessage)mailPart);
            }
            catch (MessagingException e) {
                this.logger.warn("Couldn't create a data object for a message", e);
            }
        } else {
            InputStream content = null;
            try {
                content = this.streamFactory.getPartStream(mailPart);
            }
            catch (Exception e) {
                this.logger.warn("Couldn't get a stream from a mail part" + e);
            }
            if (content != null && !content.markSupported()) {
                content = new BufferedInputStream(content, 16384);
            }
            dataObject = new FileDataObjectBase(dataObjectId, this.dataSource, metadata, content);
        }
        if (dataObject == null) {
            return;
        }
        resultDataObjectList.add(dataObject);
        if (parentUri != null) {
            metadata.add(NIE.isPartOf, parentUri);
            if (dataObjectId.equals(this.messageURI)) {
                metadata.getModel().addStatement(parentUri, RDF.type, NFO.Folder);
            } else {
                metadata.getModel().addStatement(parentUri, RDF.type, NMO.MimeEntity);
            }
        }
        this.copyString(NIE.characterSet, dataObjectHashMap, metadata);
        this.copyUniqueString(NIE.mimeType, dataObjectHashMap, metadata);
        this.copyString(NMO.contentMimeType, dataObjectHashMap, metadata);
        this.copyString(NMO.messageSubject, dataObjectHashMap, metadata);
        this.copyString(NFO.fileName, dataObjectHashMap, metadata);
        String messageContent = (String)dataObjectHashMap.get(NMO.plainTextMessageContent);
        if (messageContent != null) {
            metadata.add(NMO.plainTextMessageContent, messageContent);
            metadata.add(RDF.type, NMO.Email);
        }
        this.copyStringArray(NMO.messageId, dataObjectHashMap, metadata);
        this.copyInt(NIE.byteSize, dataObjectHashMap, metadata);
        this.copyDate(NIE.contentCreated, dataObjectHashMap, metadata);
        this.copyDate(NMO.sentDate, dataObjectHashMap, metadata);
        this.copyDate(NMO.receivedDate, dataObjectHashMap, metadata);
        this.copyAddresses(NMO.from, dataObjectHashMap, metadata);
        this.copyAddresses(NMO.sender, dataObjectHashMap, metadata);
        this.copyAddresses(NMO.to, dataObjectHashMap, metadata);
        this.copyAddresses(NMO.cc, dataObjectHashMap, metadata);
        this.copyAddresses(NMO.bcc, dataObjectHashMap, metadata);
        this.copyUri(RDF.type, dataObjectHashMap, metadata);
        this.copyUri(NFO.encryptionStatus, dataObjectHashMap, metadata);
        this.copyUri(APERTURE_NIE_EXTENSIONS.signatureContainedIn, dataObjectHashMap, metadata);
        this.copyBoolean(APERTURE_NIE_EXTENSIONS.hasSignature, dataObjectHashMap, metadata);
        this.copyBlankMessages(NMO.inReplyTo, dataObjectHashMap, metadata);
        this.copyBlankMessages(NMO.references, dataObjectHashMap, metadata);
        metadata.add(RDF.type, NMO.MimeEntity);
        metadata.add(RDF.type, NMO.MailboxDataObject);
        ArrayList children = (ArrayList)dataObjectHashMap.get(CHILDREN_KEY);
        if (children != null) {
            int nrChildren = children.size();
            for (int i = 0; i < nrChildren; ++i) {
                HashMap childHashMap = (HashMap)children.get(i);
                URI childID = (URI)childHashMap.get(ID_KEY);
                metadata.getModel().addStatement(childID, NIE.isPartOf, dataObjectId);
                metadata.getModel().addStatement(childID, RDF.type, NMO.MailboxDataObject);
                this.createDataObjects(childHashMap, dataObjectId, resultDataObjectList);
            }
        }
    }

    private void copyStringArray(URI predicate, HashMap map, RDFContainer metadata) {
        String[] value = (String[])map.get(predicate);
        if (value != null) {
            for (String string : value) {
                metadata.add(predicate, string);
            }
        }
    }

    private void copyString(URI predicate, HashMap map, RDFContainer metadata) {
        String value = (String)map.get(predicate);
        if (value != null) {
            metadata.add(predicate, value);
        }
    }

    private void copyUniqueString(URI predicate, HashMap map, RDFContainer metadata) {
        String value = (String)map.get(predicate);
        if (value != null) {
            metadata.remove(predicate);
            metadata.add(predicate, value);
        }
    }

    private void copyInt(URI predicate, HashMap map, RDFContainer metadata) {
        Integer value = (Integer)map.get(predicate);
        if (value != null) {
            metadata.add(predicate, value);
        }
    }

    private void copyBoolean(URI predicate, HashMap map, RDFContainer metadata) {
        Boolean value = (Boolean)map.get(predicate);
        if (value != null) {
            metadata.add(predicate, value);
        }
    }

    private void copyDate(URI predicate, HashMap map, RDFContainer metadata) {
        Date value = (Date)map.get(predicate);
        if (value != null) {
            String utcDate = DateUtil.dateTime2UTCString(value);
            DatatypeLiteral dateLiteral = metadata.getModel().createDatatypeLiteral(utcDate, XSD._dateTime);
            metadata.add(predicate, dateLiteral);
        }
    }

    private void copyUri(URI predicate, HashMap map, RDFContainer metadata) {
        URI uri = (URI)map.get(predicate);
        if (uri != null) {
            metadata.add(predicate, uri);
        }
    }

    private void copyAddresses(URI predicate, HashMap map, RDFContainer metadata) {
        Object value = map.get(predicate);
        try {
            if (value instanceof InternetAddress) {
                MailUtil.addAddressMetadata((InternetAddress)value, predicate, metadata);
            } else if (value instanceof InternetAddress[]) {
                InternetAddress[] array = (InternetAddress[])value;
                for (int i = 0; i < array.length; ++i) {
                    MailUtil.addAddressMetadata(array[i], predicate, metadata);
                }
            } else if (value instanceof List) {
                List list = (List)value;
                for (Object obj : list) {
                    MailUtil.LiberalInternetAddress a = (MailUtil.LiberalInternetAddress)obj;
                    MailUtil.addAddressMetadata(a, predicate, metadata);
                }
            } else if (value != null) {
                this.logger.warn("Unknown address class: " + value.getClass().getName());
            }
        }
        catch (ModelRuntimeException e) {
            this.logger.error("ModelException while handling address metadata", e);
        }
    }

    private void copyBlankMessages(URI predicate, HashMap map, RDFContainer metadata) {
        Object value = map.get(predicate);
        if (value == null || !(value instanceof String[])) {
            return;
        }
        String[] headers = (String[])value;
        Model model = metadata.getModel();
        for (String header : headers) {
            String[] subheaders;
            for (String subheader : subheaders = header.split("\\s+")) {
                Resource res = ModelUtil.generateRandomResource(model);
                model.addStatement(res, NMO.messageId, subheader);
                model.addStatement(res, RDF.type, NMO.Email);
                model.addStatement(metadata.getDescribedUri(), predicate, res);
            }
        }
    }

    private String normalizeString(String string) {
        if (string != null) {
            string = string.trim().toLowerCase();
        }
        return string;
    }

    private void addContactArrayIfNotNull(URI predicate, List<MailUtil.LiberalInternetAddress> addresses, HashMap result) {
        if (addresses != null) {
            result.put(predicate, addresses);
        }
    }

    private String getBodyPartURIPrefix(URI parentURI) {
        if (parentURI.equals(this.messageURI)) {
            if (this.partUriDelimiter == null) {
                return this.subPartUriPrefix + (this.subPartUriPrefix.indexOf(35) < 0 ? "#" : "-");
            }
            return this.subPartUriPrefix + this.partUriDelimiter;
        }
        String prefix = parentURI.toString();
        if (this.partUriDelimiter == null) {
            return prefix + (prefix.indexOf(35) < 0 ? "#" : "-");
        }
        return prefix + this.partUriDelimiter;
    }

    private int getNestedPartCount(Multipart part) throws MessagingException {
        try {
            int nrParts = part.getCount();
            return nrParts;
        }
        catch (MessagingException e) {
            String msg = e.getMessage();
            if (msg != null && msg.contains("Missing") && msg.contains("boundary")) {
                return -1;
            }
            throw e;
        }
    }

    private void transferInfo(HashMap fromObject, HashMap toObject) throws IOException {
        ArrayList fromChildren;
        Object fromType = fromObject.get(NIE.mimeType);
        if (fromType != null) {
            Object toType = toObject.get(NIE.mimeType);
            URI predicate = "message/rfc822".equals(toType) ? NMO.contentMimeType : NIE.mimeType;
            toObject.put(predicate, fromType);
        }
        if ((fromChildren = (ArrayList)fromObject.get(CHILDREN_KEY)) != null && !fromChildren.isEmpty()) {
            ArrayList toChildren = (ArrayList)toObject.get(CHILDREN_KEY);
            if (toChildren == null) {
                toChildren = new ArrayList();
                toObject.put(CHILDREN_KEY, toChildren);
            }
            toChildren.addAll(fromChildren);
        }
        for (Map.Entry entryObject : fromObject.entrySet()) {
            Map.Entry entry = entryObject;
            String keyString = entry.getKey().toString();
            if (keyString.equals(ID_KEY) || keyString.equals(MAIL_PART_KEY) || keyString.equals(NIE.mimeType.toString()) || keyString.equals(CHILDREN_KEY) || keyString.equals(NIE.byteSize.toString())) continue;
            toObject.put(entry.getKey(), entry.getValue());
        }
    }

    private int getPartWithMimeType(Multipart multipart, String mimeType) throws MessagingException {
        int count = multipart.getCount();
        for (int i = 0; i < count; ++i) {
            BodyPart bodyPart = multipart.getBodyPart(i);
            String partType = this.getMimeType(bodyPart);
            if (!partType.toLowerCase().startsWith(mimeType)) continue;
            return i;
        }
        return -1;
    }

    private String getMimeType(Part mailPart) throws MessagingException {
        String contentType = mailPart.getContentType();
        if (contentType != null) {
            ContentType ct = new ContentType(contentType);
            return ct.getBaseType();
        }
        return null;
    }

    private String getHeader(Part mailPart, String headerName) throws MessagingException {
        String[] headerValues = mailPart.getHeader(headerName);
        return headerValues != null && headerValues.length > 0 ? headerValues[0] : null;
    }

    private void addObjectIfNotNull(URI predicate, Object value, HashMap map) {
        if (value != null) {
            map.put(predicate, value);
        }
    }

    private void addSentAndReceivedDates(Part part, HashMap result) throws MessagingException {
        if (part instanceof MimeMessage) {
            MimeMessage mm = (MimeMessage)part;
            this.addObjectIfNotNull(NMO.sentDate, mm.getSentDate(), result);
            Date date = mm.getReceivedDate();
            if (date != null) {
                result.put(NMO.receivedDate, date);
            } else {
                String[] s = mm.getHeader("Received");
                if (s != null && s.length > 0) {
                    try {
                        date = MailUtil.parseReceivedHeader(s[0]);
                        result.put(NMO.receivedDate, date);
                    }
                    catch (ParseException e) {
                        this.logger.warn("Coudln't parse the Received date: " + s[0]);
                    }
                }
            }
        }
    }

    public static interface PartStreamFactory {
        public InputStream getPartStream(Part var1) throws MessagingException, IOException;

        public MessageDataObject createDataObject(URI var1, DataSource var2, RDFContainer var3, MimeMessage var4) throws MessagingException;
    }
}

